/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol.packet;

import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcspPacket {
    private static final Logger log = LoggerFactory.getLogger(EcspPacket.class);
    private final int lengthField;
    private final ByteBuffer payload;
    private final InetSocketAddress remoteAddress;
    private final InetSocketAddress localAddress;

    public static EcspPacket buildFromMessage(Message message) {
        ByteBuffer payload = message.pack();
        int length = payload.capacity();
        return EcspPacket.builder().lengthField(length).payload(payload).build();
    }

    public static EcspPacket buildFromMessageStr(String messageStr) {
        ByteBuffer payload = ByteBuffer.wrap(messageStr.getBytes(StandardCharsets.UTF_8));
        int length = payload.capacity();
        return EcspPacket.builder().lengthField(length).payload(payload).build();
    }

    public static EcspMessage parseEcspMessage(EcspPacket ecspPacket) {
        return EcspPacket.parseEcspMessage(ecspPacket, null);
    }

    public static EcspMessage parseEcspMessage(String ecspPacketPayloadJson, InetSocketAddress deviceIp) {
        EcspMessage ecspMessage = EcspMessage.parseEcspMessage(ecspPacketPayloadJson);
        return EcspPacket.parseEcspMessage(ecspMessage, deviceIp);
    }

    public static EcspMessage parseEcspMessage(EcspPacket ecspPacket, InetSocketAddress deviceIp) {
        EcspMessage ecspMessage = EcspMessage.parseEcspMessage(ecspPacket.getPayload());
        return EcspPacket.parseEcspMessage(ecspMessage, deviceIp);
    }

    public static EcspMessage parseEcspMessage(EcspMessage ecspMessage, InetSocketAddress deviceIp) {
        MessageHeader messageHeader = ecspMessage.getHeader();
        if (Objects.isNull(messageHeader) || StringUtils.isEmpty(messageHeader.getMac())) {
            return null;
        }
        MessageHeader headerWithTimestamp = Objects.nonNull(deviceIp) ? messageHeader.toBuilder().timestamp(System.currentTimeMillis()).ip(deviceIp.getHostString()).build() : messageHeader.toBuilder().timestamp(System.currentTimeMillis()).build();
        return ecspMessage.toBuilder().header(headerWithTimestamp).build();
    }

    EcspPacket(int lengthField, ByteBuffer payload, InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        this.lengthField = lengthField;
        this.payload = payload;
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
    }

    public static EcspPacketBuilder builder() {
        return new EcspPacketBuilder();
    }

    public EcspPacketBuilder toBuilder() {
        return new EcspPacketBuilder().lengthField(this.lengthField).payload(this.payload).remoteAddress(this.remoteAddress).localAddress(this.localAddress);
    }

    public int getLengthField() {
        return this.lengthField;
    }

    public ByteBuffer getPayload() {
        return this.payload;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public static class EcspPacketBuilder {
        private int lengthField;
        private ByteBuffer payload;
        private InetSocketAddress remoteAddress;
        private InetSocketAddress localAddress;

        EcspPacketBuilder() {
        }

        public EcspPacketBuilder lengthField(int lengthField) {
            this.lengthField = lengthField;
            return this;
        }

        public EcspPacketBuilder payload(ByteBuffer payload) {
            this.payload = payload;
            return this;
        }

        public EcspPacketBuilder remoteAddress(InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public EcspPacketBuilder localAddress(InetSocketAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public EcspPacket build() {
            return new EcspPacket(this.lengthField, this.payload, this.remoteAddress, this.localAddress);
        }

        public String toString() {
            return "EcspPacket.EcspPacketBuilder(lengthField=" + this.lengthField + ", payload=" + this.payload + ", remoteAddress=" + this.remoteAddress + ", localAddress=" + this.localAddress + ")";
        }
    }
}

