/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol.packet;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.common.util.KMPUtils;
import com.tplink.smb.ecsp.common.util.LzoUtils;
import com.tplink.smb.ecsp.common.util.MacUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.common.util.encrypt.CipherUtils;
import com.tplink.smb.ecsp.protocol.packet.InformEcspMessage;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.ecsp.protocol.packet.body.AbstractMessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseConfigResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseGetResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.CompressBody;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcspMessage
implements Message {
    private static final Logger log = LoggerFactory.getLogger(EcspMessage.class);
    private static final String HEADER_MAP = "header";
    private static final String BODY_MAP = "body";
    private MessageHeader header;
    private MessageBody body;

    @Override
    public ByteBuffer pack() {
        return ByteBuffer.wrap(JacksonUtils.pojo2Json(this).getBytes());
    }

    public static EcspMessage parseEcspMessage(Object object) {
        if (object instanceof EcspMessage) {
            return new EcspMessage((EcspMessage)object);
        }
        if (object instanceof ByteBuffer) {
            return new EcspMessage((ByteBuffer)object);
        }
        if (object instanceof String) {
            String json = (String)object;
            if (EcspMessage.isInform(json)) {
                return new EcspMessage(json, MessageType.INFORM_REQUEST, CompressBody.class);
            }
            return new EcspMessage(json);
        }
        if (object instanceof Map) {
            return new EcspMessage((Map)object);
        }
        return new EcspMessage(null, null);
    }

    private EcspMessage(EcspMessage ecspMessage) {
        boolean valid = !EcspMessage.isNotValid(ecspMessage);
        this.header = valid ? ecspMessage.getHeader() : null;
        this.body = valid ? ecspMessage.getBody() : null;
    }

    private EcspMessage(ByteBuffer byteBuffer) {
        EcspMessage ecspMessage = EcspMessage.parseEcspMessage(StandardCharsets.UTF_8.decode(byteBuffer).toString());
        this.header = ecspMessage.getHeader();
        this.body = ecspMessage.getBody();
    }

    private EcspMessage(String messageStr) {
        this(JacksonUtils.json2Map(messageStr));
    }

    private EcspMessage(String messageStr, MessageType messageType, Class<CompressBody> compressClass) {
        InformEcspMessage informEcspMessage = JacksonUtils.json2Pojo(messageStr, InformEcspMessage.class);
        MessageHeader messageHeader = informEcspMessage.getHeader();
        MessageBody messageBody = informEcspMessage.getBody();
        String compress = informEcspMessage.getHeader().getCompress();
        if (StringUtils.isNull(compress)) {
            this.header = messageHeader.toBuilder().mac(MacUtils.formatMacDb(messageHeader.getMac())).build();
            this.body = messageBody;
        } else {
            messageBody = JacksonUtils.map2Bean(messageBody.getData(), compressClass);
            this.header = messageHeader.toBuilder().mac(MacUtils.formatMacDb(messageHeader.getMac())).compress(null).build();
            this.body = this.unCompressBody(this.header, (CompressBody)messageBody, messageType, compress);
        }
    }

    private EcspMessage(Map<String, Object> map) {
        this.header = null;
        this.body = null;
        if (map == null || map.isEmpty()) {
            return;
        }
        MessageHeader messageHeader = (MessageHeader)JacksonUtils.parseJsonMap(map, HEADER_MAP, MessageHeader.class);
        if (messageHeader == null) {
            return;
        }
        MessageType messageType = MessageType.fromInteger(messageHeader.getType());
        String compress = messageHeader.getCompress();
        Class<? extends AbstractMessageBody> clazz = EcspMessage.getEcspMessageBodyClass(compress, messageType);
        if (clazz == null) {
            return;
        }
        AbstractMessageBody messageBody = (AbstractMessageBody)JacksonUtils.parseJsonMap(map, BODY_MAP, clazz);
        if (CompressBody.class.equals(clazz)) {
            this.header = messageHeader.toBuilder().mac(MacUtils.formatMacDb(messageHeader.getMac())).compress(null).build();
            this.body = this.unCompressBody(this.header, (CompressBody)messageBody, messageType, compress);
        } else {
            this.header = messageHeader.toBuilder().mac(MacUtils.formatMacDb(messageHeader.getMac())).build();
            this.body = messageBody;
        }
    }

    private MessageBody unCompressBody(MessageHeader messageHeader, CompressBody compressBody, MessageType messageType, String compress) {
        if (!"lzo-2.07".equalsIgnoreCase(compress)) {
            log.info("do not support this compress method {}", (Object)compress);
            return compressBody;
        }
        MessageBody messageBody = compressBody;
        try {
            byte[] compressData = CipherUtils.decryptBASE64(compressBody.getCompressData());
            byte[] unCompressData = LzoUtils.decompress(compressData);
            String bodyJson = new String(unCompressData, StandardCharsets.UTF_8);
            messageBody = JacksonUtils.json2Pojo(bodyJson, messageType.getMessageBodyClass());
        }
        catch (IOException e) {
            log.info("decompress message body failed for {}, type {}", new Object[]{messageHeader.getMac(), messageHeader.getType(), e});
        }
        return messageBody;
    }

    public static AbstractMessageBody parseMessageBody(EcspMessage ecspMessage) {
        if (EcspMessage.isNotValid(ecspMessage)) {
            return null;
        }
        MessageHeader header = ecspMessage.getHeader();
        Class<? extends AbstractMessageBody> clazz = EcspMessage.getEcspMessageBodyClass(header.getCompress(), MessageType.fromInteger(header.getType()));
        return clazz != null ? JacksonUtils.obj2Obj(ecspMessage.getBody(), clazz) : null;
    }

    private static Class<? extends AbstractMessageBody> getEcspMessageBodyClass(String compress, MessageType messageType) {
        return StringUtils.isNull(compress) ? messageType.getMessageBodyClass() : CompressBody.class;
    }

    public static boolean isNotValid(EcspMessage message) {
        MessageHeader header;
        if (message == null || (header = message.getHeader()) == null) {
            return true;
        }
        DeviceType deviceType = DeviceType.resolve(header.getDevice());
        MessageType messageType = MessageType.fromInteger(header.getType());
        if (StringUtils.isEmpty(header.getMac()) || deviceType == null || messageType == null) {
            return true;
        }
        return EcspMessage.isMessageBodyNotValid(message.getBody(), messageType);
    }

    private static boolean isMessageBodyNotValid(MessageBody messageBody, MessageType messageType) {
        if (messageBody == null || messageType == null) {
            return !MessageType.isMessageBodyEmpty(messageType);
        }
        Class<?> bodyClass = messageBody.getClass();
        if (CompressBody.class.equals(bodyClass)) {
            return false;
        }
        if (MessageType.SET_REQUEST.equals((Object)messageType)) {
            return !bodyClass.equals(MessageType.SET_REQUEST.getMessageBodyClass()) && !bodyClass.equals(MessageType.INIT_SYNC.getMessageBodyClass());
        }
        return !bodyClass.equals(messageType.getMessageBodyClass());
    }

    public boolean matchMac(String mac) {
        return !EcspMessage.isNotValid(this) && !StringUtils.isEmpty(mac) && mac.equalsIgnoreCase(this.header.getMac());
    }

    public static boolean isInform(String json) {
        return KMPUtils.contain(json, ",\"type\":256,");
    }

    @JsonIgnore
    public String getMac() {
        return this.header.getMac();
    }

    @JsonIgnore
    public String getDeviceType() {
        return this.header.getDevice();
    }

    @JsonIgnore
    public Integer getMessageType() {
        return this.header.getType();
    }

    @JsonIgnore
    public Integer getError() {
        return this.header.getError();
    }

    @JsonIgnore
    public String getVersion() {
        return this.header.getVersion();
    }

    @JsonIgnore
    public Integer getVerCap() {
        return this.header.getVerCap();
    }

    @JsonIgnore
    public String getDest() {
        return this.header.getDest();
    }

    @JsonIgnore
    public Long getTimestamp() {
        return this.header.getTimestamp();
    }

    @JsonIgnore
    public Integer getSeq() {
        Integer sequenceId = this.header.getSeq();
        if (sequenceId != null) {
            return sequenceId;
        }
        AbstractMessageBody messageBody = EcspMessage.parseMessageBody(this);
        if (messageBody != null) {
            sequenceId = messageBody instanceof BaseConfigResponse ? ((BaseConfigResponse)messageBody).getSequenceId() : (messageBody instanceof BaseGetResponse ? ((BaseGetResponse)messageBody).getSequenceId() : (Integer)messageBody.getAdditionalProperties().get("sequenceId"));
        }
        return sequenceId;
    }

    @JsonIgnore
    public Boolean getLast() {
        return this.header.getLast();
    }

    @JsonIgnore
    public String getSeqNum() {
        return this.header.getSeqNum();
    }

    @JsonIgnore
    public boolean isFragMsg() {
        return Objects.nonNull(this.header.getLast());
    }

    public static EcspMessageBuilder builder() {
        return new EcspMessageBuilder();
    }

    public EcspMessageBuilder toBuilder() {
        return new EcspMessageBuilder().header(this.header).body(this.body);
    }

    public String toString() {
        return "EcspMessage(header=" + this.getHeader() + ", body=" + this.getBody() + ")";
    }

    public MessageHeader getHeader() {
        return this.header;
    }

    public MessageBody getBody() {
        return this.body;
    }

    public EcspMessage() {
    }

    public EcspMessage(MessageHeader header, MessageBody body) {
        this.header = header;
        this.body = body;
    }

    public static class EcspMessageBuilder {
        private MessageHeader header;
        private MessageBody body;

        EcspMessageBuilder() {
        }

        public EcspMessageBuilder header(MessageHeader header) {
            this.header = header;
            return this;
        }

        public EcspMessageBuilder body(MessageBody body) {
            this.body = body;
            return this;
        }

        public EcspMessage build() {
            return new EcspMessage(this.header, this.body);
        }

        public String toString() {
            return "EcspMessage.EcspMessageBuilder(header=" + this.header + ", body=" + this.body + ")";
        }
    }
}

