/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol;

import java.util.HashMap;
import java.util.Map;

public enum ServerType {
    DISCOVERY("discovery"),
    ADOPT("adopt"),
    MANAGE("manage"),
    UPGRADE("upgrade"),
    TRANSFER("transfer"),
    RTTY("rtty"),
    MONITOR("monitor");

    private final String type;
    private static final Map<String, ServerType> typeMap;

    private ServerType(String type) {
        this.type = type;
    }

    public static ServerType fromString(String type) {
        return typeMap.get(type);
    }

    public String getType() {
        return this.type;
    }

    static {
        typeMap = new HashMap<String, ServerType>(4);
        for (ServerType type : ServerType.values()) {
            typeMap.put(type.getType(), type);
        }
    }
}

