/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol;

import java.util.Objects;

public enum DeviceNetStatus {
    DISCOVERY(1),
    ADOPTING_PENDING_PRE_ADOPT(2),
    ADOPTING_PRE_ADOPT(3),
    ADOPTING_PRE_CONNECT(4),
    ADOPTING_DEVICE_VERIFY(5),
    ADOPTING_SYSTEM_VERIFY(6),
    ADOPT_SUCCESS(7),
    CONNECTED(8),
    DISCOVERY_TIMEOUT(9),
    ADOPTING_TIMEOUT(10),
    ADOPTED_TIMEOUT(11),
    CONNECTED_TIMEOUT(12),
    CONNECTED_ERROR(13);

    private final int value;

    private DeviceNetStatus(int value) {
        this.value = value;
    }

    public static boolean isAdopting(DeviceNetStatus netStatus) {
        if (netStatus == null) {
            return false;
        }
        return Objects.equals((Object)netStatus, (Object)ADOPTING_PENDING_PRE_ADOPT) || Objects.equals((Object)netStatus, (Object)ADOPTING_PRE_ADOPT) || Objects.equals((Object)netStatus, (Object)ADOPTING_PRE_CONNECT) || Objects.equals((Object)netStatus, (Object)ADOPTING_DEVICE_VERIFY) || Objects.equals((Object)netStatus, (Object)ADOPTING_SYSTEM_VERIFY);
    }

    public static boolean isDiscovering(DeviceNetStatus netStatus) {
        if (netStatus == null) {
            return false;
        }
        return Objects.equals((Object)netStatus, (Object)DISCOVERY) || Objects.equals((Object)netStatus, (Object)ADOPTING_PENDING_PRE_ADOPT) || Objects.equals((Object)netStatus, (Object)ADOPTING_PRE_ADOPT);
    }

    public static boolean isPreAdopt(int netStatusValue) {
        return netStatusValue == ADOPTING_PENDING_PRE_ADOPT.getValue() || netStatusValue == ADOPTING_PRE_ADOPT.getValue();
    }

    public static boolean isV1AdoptConnected(DeviceNetStatus netStatus) {
        if (netStatus == null) {
            return false;
        }
        return Objects.equals((Object)netStatus, (Object)ADOPTING_PRE_CONNECT) || Objects.equals((Object)netStatus, (Object)ADOPT_SUCCESS);
    }

    public static boolean isV1ManageConnected(DeviceNetStatus netStatus) {
        if (netStatus == null) {
            return false;
        }
        return Objects.equals((Object)netStatus, (Object)CONNECTED);
    }

    public static boolean isV2ManageConnected(DeviceNetStatus netStatus) {
        if (netStatus == null) {
            return false;
        }
        return Objects.equals((Object)netStatus, (Object)ADOPTING_PRE_CONNECT) || Objects.equals((Object)netStatus, (Object)ADOPTING_DEVICE_VERIFY) || Objects.equals((Object)netStatus, (Object)ADOPTING_SYSTEM_VERIFY) || Objects.equals((Object)netStatus, (Object)ADOPT_SUCCESS) || Objects.equals((Object)netStatus, (Object)CONNECTED);
    }

    public int getValue() {
        return this.value;
    }
}

