/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.protocol;

import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtils {
    private static final Logger log = LoggerFactory.getLogger(DebugUtils.class);
    private static Map<String, Map<String, PIIMaskStrategy>> maskMessageMap = new HashMap<String, Map<String, PIIMaskStrategy>>();
    private static Map<String, PIIMaskStrategy> referMap = new HashMap<String, PIIMaskStrategy>();

    private DebugUtils() {
    }

    public static boolean isDeviceMsgEnable() {
        return DebugHolder.isDeviceMsgEnable();
    }

    public static void setDeviceMsgEnable(boolean enable) {
        DebugHolder.setDeviceMsgEnable(enable);
    }

    public static boolean isDeviceInformEnable() {
        return DebugHolder.isDeviceInformEnable();
    }

    public static Map<String, PIIMaskStrategy> getMaskMessageMapForDevice(String deviceType) {
        return CollectionUtils.isEmptyMap(maskMessageMap) ? null : maskMessageMap.get(deviceType);
    }

    public static Map<String, PIIMaskStrategy> getMaskGrpcRequestMap() {
        return DebugHolder.grpcRequestMaskMap;
    }

    public static void setMaskMessageMap(Map<String, Map<String, PIIMaskStrategy>> maskMessageMap) {
        DebugUtils.maskMessageMap = maskMessageMap;
    }

    static {
        referMap.put("hash", PIIMaskStrategy.HASH);
        referMap.put("encrypt", PIIMaskStrategy.ENCRYPT);
        referMap.put("mask", PIIMaskStrategy.MASK);
        referMap.put("trunc_2", PIIMaskStrategy.TRUNC_2);
        referMap.put("none", PIIMaskStrategy.NONE);
    }

    private static class DebugHolder {
        static AtomicBoolean DEVICE_MSG_ENABLE = new AtomicBoolean(false);
        static AtomicBoolean HAS_READ_DEVICE_MSG_ENABLE = new AtomicBoolean(false);
        static AtomicBoolean DEVICE_INFORM_ENABLE = new AtomicBoolean(false);
        static AtomicBoolean HAS_READ_DEVICE_INFORM_ENABLE = new AtomicBoolean(false);
        static Map<String, PIIMaskStrategy> grpcRequestMaskMap = new HashMap<String, PIIMaskStrategy>();

        private DebugHolder() {
        }

        static boolean isDeviceMsgEnable() {
            if (HAS_READ_DEVICE_MSG_ENABLE.get()) {
                return DEVICE_MSG_ENABLE.get();
            }
            DEVICE_MSG_ENABLE.getAndSet(Boolean.parseBoolean(System.getProperty("debug.device.msg.enable")));
            HAS_READ_DEVICE_MSG_ENABLE.getAndSet(true);
            return DEVICE_MSG_ENABLE.get();
        }

        static void setDeviceMsgEnable(boolean enable) {
            DEVICE_MSG_ENABLE.getAndSet(enable);
        }

        static boolean isDeviceInformEnable() {
            if (HAS_READ_DEVICE_INFORM_ENABLE.get()) {
                return DEVICE_INFORM_ENABLE.get();
            }
            DEVICE_INFORM_ENABLE.getAndSet(Boolean.parseBoolean(System.getProperty("debug.device.inform.enable")));
            HAS_READ_DEVICE_INFORM_ENABLE.getAndSet(true);
            return DEVICE_INFORM_ENABLE.get();
        }

        static {
            grpcRequestMaskMap.put("$.adoptInfoList[*].username", PIIMaskStrategy.MASK);
            grpcRequestMaskMap.put("$.adoptInfoList[*].password", PIIMaskStrategy.MASK);
            grpcRequestMaskMap.put("$.deviceMessageInfo.messageBody", PIIMaskStrategy.MASK);
            try (InputStream is = DebugUtils.class.getResourceAsStream("/json/ecsp.json");){
                if (is != null) {
                    EcspConfig ecspConfig = JacksonUtils.readInputStream(is, EcspConfig.class);
                    log.debug("ecspConfigs: {}", (Object)ecspConfig);
                    if (ecspConfig != null && CollectionUtils.isNotEmptyMap(ecspConfig.getGrpcRequestMaskMap())) {
                        Map<String, String> grpcRequestMap = ecspConfig.getGrpcRequestMaskMap();
                        for (Map.Entry<String, String> entry : grpcRequestMap.entrySet()) {
                            grpcRequestMaskMap.putIfAbsent(entry.getKey(), referMap.get(entry.getValue()));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.info("Load ecsp properties failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class EcspConfig {
        private Map<String, String> ecspConfigMap;
        private Map<String, String> grpcRequestMaskMap;

        public Map<String, String> getEcspConfigMap() {
            return this.ecspConfigMap;
        }

        public Map<String, String> getGrpcRequestMaskMap() {
            return this.grpcRequestMaskMap;
        }

        public void setEcspConfigMap(Map<String, String> ecspConfigMap) {
            this.ecspConfigMap = ecspConfigMap;
        }

        public void setGrpcRequestMaskMap(Map<String, String> grpcRequestMaskMap) {
            this.grpcRequestMaskMap = grpcRequestMaskMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EcspConfig)) {
                return false;
            }
            EcspConfig other = (EcspConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$ecspConfigMap = this.getEcspConfigMap();
            Map<String, String> other$ecspConfigMap = other.getEcspConfigMap();
            if (this$ecspConfigMap == null ? other$ecspConfigMap != null : !((Object)this$ecspConfigMap).equals(other$ecspConfigMap)) {
                return false;
            }
            Map<String, String> this$grpcRequestMaskMap = this.getGrpcRequestMaskMap();
            Map<String, String> other$grpcRequestMaskMap = other.getGrpcRequestMaskMap();
            return !(this$grpcRequestMaskMap == null ? other$grpcRequestMaskMap != null : !((Object)this$grpcRequestMaskMap).equals(other$grpcRequestMaskMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EcspConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $ecspConfigMap = this.getEcspConfigMap();
            result = result * 59 + ($ecspConfigMap == null ? 43 : ((Object)$ecspConfigMap).hashCode());
            Map<String, String> $grpcRequestMaskMap = this.getGrpcRequestMaskMap();
            result = result * 59 + ($grpcRequestMaskMap == null ? 43 : ((Object)$grpcRequestMaskMap).hashCode());
            return result;
        }

        public String toString() {
            return "DebugUtils.EcspConfig(ecspConfigMap=" + this.getEcspConfigMap() + ", grpcRequestMaskMap=" + this.getGrpcRequestMaskMap() + ")";
        }
    }

    private static class Keys {
        static final String PROPERTIES_PATH_KEY = "/json/ecsp.json";
        static final String DEBUG_DEVICE_MSG_ENABLE = "debug.device.msg.enable";
        static final String DEBUG_DEVICE_INFORM_ENABLE = "debug.device.inform.enable";

        private Keys() {
        }
    }
}

