/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util.encrypt;

import java.util.Arrays;

public class TEAUtils {
    private static final int[] KEY = new int[]{-707509657, -1887749506, 1427902494, -1686606610};
    private static final int DELTA = -1640531527;
    private static final int ENCRYPT_ROUNDS = 64;

    private TEAUtils() {
    }

    public static byte[] encrypt(byte[] content) {
        int n = 8 - content.length % 8;
        byte[] encryptStr = new byte[content.length + n];
        encryptStr[0] = (byte)n;
        System.arraycopy(content, 0, encryptStr, n, content.length);
        byte[] result = new byte[encryptStr.length];
        for (int offset = 0; offset < result.length; offset += 8) {
            byte[] tempEncrpt = TEAUtils.encrypt(encryptStr, offset, KEY, 64);
            System.arraycopy(tempEncrpt, 0, result, offset, 8);
        }
        return result;
    }

    public static byte[] decrypt(byte[] encryptContent) {
        byte[] decryptStr = null;
        byte[] tempDecrypt = new byte[encryptContent.length];
        for (int offset = 0; offset < encryptContent.length; offset += 8) {
            decryptStr = TEAUtils.decrypt(encryptContent, offset, KEY, 64);
            System.arraycopy(decryptStr, 0, tempDecrypt, offset, 8);
        }
        byte n = tempDecrypt[0];
        return Arrays.copyOfRange(tempDecrypt, (int)n, decryptStr.length);
    }

    public static byte[] encrypt(byte[] content, int offset) {
        return TEAUtils.encrypt(content, offset, KEY, 64);
    }

    public static byte[] decrypt(byte[] encryptContent, int offset) {
        return TEAUtils.decrypt(encryptContent, offset, KEY, 64);
    }

    private static byte[] encrypt(byte[] content, int offset, int[] key, int times) {
        int[] tempInt = TEAUtils.byteToInt(content, offset);
        int y = tempInt[0];
        int z = tempInt[1];
        int sum = 0;
        int a = key[0];
        int b = key[1];
        int c = key[2];
        int d = key[3];
        for (int i = 0; i < times; ++i) {
            z += ((y += (z << 4) + a ^ z + (sum -= 1640531527) ^ (z >> 5) + b) << 4) + c ^ y + sum ^ (y >> 5) + d;
        }
        tempInt[0] = y;
        tempInt[1] = z;
        return TEAUtils.intToByte(tempInt, 0);
    }

    private static byte[] decrypt(byte[] encryptContent, int offset, int[] key, int times) {
        int[] tempInt = TEAUtils.byteToInt(encryptContent, offset);
        int y = tempInt[0];
        int z = tempInt[1];
        int sum = 0;
        int delta = -1640531527;
        int a = key[0];
        int b = key[1];
        int c = key[2];
        int d = key[3];
        sum = times == 32 ? -957401312 : (times == 16 ? -478700656 : delta * times);
        for (int i = 0; i < times; ++i) {
            y -= ((z -= (y << 4) + c ^ y + sum ^ (y >> 5) + d) << 4) + a ^ z + sum ^ (z >> 5) + b;
            sum -= delta;
        }
        tempInt[0] = y;
        tempInt[1] = z;
        return TEAUtils.intToByte(tempInt, 0);
    }

    private static int[] byteToInt(byte[] content, int offset) {
        int[] result = new int[content.length >> 2];
        int i = 0;
        for (int j = offset; j < content.length; j += 4) {
            result[i] = TEAUtils.transform(content[j + 3]) | TEAUtils.transform(content[j + 2]) << 8 | TEAUtils.transform(content[j + 1]) << 16 | content[j] << 24;
            ++i;
        }
        return result;
    }

    private static byte[] intToByte(int[] content, int offset) {
        byte[] result = new byte[content.length << 2];
        int i = 0;
        for (int j = offset; j < result.length; j += 4) {
            result[j + 3] = (byte)(content[i] & 0xFF);
            result[j + 2] = (byte)(content[i] >> 8 & 0xFF);
            result[j + 1] = (byte)(content[i] >> 16 & 0xFF);
            result[j] = (byte)(content[i] >> 24 & 0xFF);
            ++i;
        }
        return result;
    }

    private static int transform(byte temp) {
        int tempInt = temp;
        if (tempInt < 0) {
            tempInt += 256;
        }
        return tempInt;
    }
}

