/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util.encrypt;

import com.tplink.smb.ecsp.common.exception.TransException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RsaUtils {
    private static final Logger log = LoggerFactory.getLogger(RsaUtils.class);
    private static final String ENCRYPT_ALGORITHM = "RSA";

    public static RsaKeyPair createKeyPair() {
        return RsaUtils.createKeyPair(1024);
    }

    private RsaUtils() {
    }

    public static RsaKeyPair createKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ENCRYPT_ALGORITHM);
            keyPairGen.initialize(keySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            BigInteger modulus = publicKey.getModulus();
            BigInteger publicExponent = publicKey.getPublicExponent();
            BigInteger privateExponent = privateKey.getPrivateExponent();
            KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPT_ALGORITHM);
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
            RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(modulus, privateExponent);
            return new RsaKeyPair((RSAPublicKey)keyFactory.generatePublic(pubKeySpec), (RSAPrivateKey)keyFactory.generatePrivate(priKeySpec));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error(e.toString(), (Throwable)e);
            throw new TransException(1100);
        }
    }

    public static String encodeToPem(String type, Key key) {
        try {
            StringWriter stringWriter = new StringWriter();
            PemWriter pemWriter = new PemWriter((Writer)stringWriter);
            pemWriter.writeObject((PemObjectGenerator)new PemObject(type, key.getEncoded()));
            pemWriter.close();
            return stringWriter.toString();
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            throw new TransException(1100);
        }
    }

    public static byte[] doCipher(byte[] data, Key key, int mode, String transformation) {
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            throw new TransException(1100);
        }
    }

    public static class RsaKeyPair {
        private RSAPublicKey publicKey;
        private RSAPrivateKey privateKey;

        private RsaKeyPair(RSAPublicKey publicKey, RSAPrivateKey privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public void setPublicKey(RSAPublicKey publicKey) {
            this.publicKey = publicKey;
        }

        public void setPrivateKey(RSAPrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        public RSAPublicKey getPublicKey() {
            return this.publicKey;
        }

        public RSAPrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }
}

