/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util.encrypt;

import com.tplink.smb.ecsp.common.exception.TransException;
import com.tplink.smb.ecsp.common.util.encrypt.CipherUtils;
import com.tplink.smb.ecsp.common.util.encrypt.GlobalConfig;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RsaCipher {
    private static final Logger logger = LoggerFactory.getLogger(RsaCipher.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final Object _lock = new Object();
    public static volatile boolean initialized = false;
    private static PrivateKey PRIVATE_KEY;

    private RsaCipher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (!initialized) {
            Object object = _lock;
            synchronized (object) {
                if (!initialized) {
                    String priKey = RsaCipher.loadPrivateKey(GlobalConfig.NETTY_RSA_PRIVATE_KEY);
                    RsaCipher.generatePrivateKey(priKey);
                }
                initialized = true;
            }
        }
    }

    public static String sign(byte[] data) {
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(PRIVATE_KEY);
            signature.update(data);
            return CipherUtils.encryptBASE64(signature.sign());
        }
        catch (Exception e) {
            throw new TransException(1100, "sign failed");
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(1, PRIVATE_KEY);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            logger.warn("encrypt by private key failed", (Throwable)e);
            throw new TransException(1100, "encrypt by private key failed");
        }
    }

    public static byte[] decryptByPrivateKey(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(2, PRIVATE_KEY);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            logger.warn("decrypt by private key failed", (Throwable)e);
            throw new TransException(1100, "decrypt by private key failed");
        }
    }

    private static void generatePrivateKey(String key) {
        try {
            byte[] keyBytes = CipherUtils.decryptBASE64(key);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PRIVATE_KEY = keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (Exception e) {
            logger.warn("generate private key error .", (Throwable)e);
            throw new TransException(1100, "generate private key error .");
        }
    }

    private static String loadPrivateKey(String privateKeyStr) {
        try {
            byte[] buffer = CipherUtils.decryptBASE64(privateKeyStr);
            org.bouncycastle.asn1.pkcs.RSAPrivateKey asn1PrivKey = org.bouncycastle.asn1.pkcs.RSAPrivateKey.getInstance((Object)ASN1Sequence.fromByteArray((byte[])buffer));
            RSAPrivateKeySpec rsaPrivKeySpec = new RSAPrivateKeySpec(asn1PrivKey.getModulus(), asn1PrivKey.getPrivateExponent());
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(rsaPrivKeySpec);
            return CipherUtils.encryptBASE64(privateKey.getEncoded());
        }
        catch (Exception e) {
            logger.error("Load private key failed.", (Throwable)e);
            throw new TransException(1100, "Load private key failed.");
        }
    }
}

