/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util.encrypt;

import com.tplink.smb.ecsp.common.util.encrypt.TEAUtils;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RC4Utils {
    private static final Logger log = LoggerFactory.getLogger(RC4Utils.class);
    private static final byte[] ENCRYPTED_ENCRYPT_KEY = new byte[]{11, 42, -108, -52, -55, -48, -37, 127, 56, 121, 115, 83, 100, 82, 82, 73, 53, 52, 88, 78, 81, 72, 66, 69, 98, 79, 73, 82, 113, 78, 106, 81, 103, 89, 120, 115, 84, 109, 117, 87, 51, 115, 114, 83, 86, 82, 86, 70, 121, 76, 104, 56, 109, 119, 118, 104, 66, 76, 80, 70, 81, 112, 104, 51, 101, 99, 68, 77, 76, 110, 68, 116, 106, 68, 85, 100, 114, 85, 119, 116, 55, 111, 84, 115, 74, 117, 89, 108, 55, 50, 104, 88, 69, 83, 78, 105, 68, 54, 106, 70, 73, 81, 67, 116, 81, 78, 49, 117, 110, 115, 109, 110, 51, 74, 88, 106, 101, 89, 119, 71, 74, 53, 53, 112, 113, 84, 107, 86, 121, 78, 50, 79, 79, 109, 51, 118, 101, 107, 70, 54, 71, 49, 76, 77, 52, 116, 51, 107, 105, 105, 71, 52, 108, 71, 119, 98, 120, 71, 52, 67, 71, 49, 115, 53, 83, 108, 105, 55, 103, 99, 73, 78, 70, 66, 79, 76, 88, 81, 110, 80, 112, 115, 81, 78, 87, 68, 109, 80, 98, 79, 109, 55, 52, 109, 69, 55, 101, 121, 82, 51, 76, 55, 116, 107, 56, 116, 85, 104, 73, 49, 55, 70, 76, 75, 109, 49, 49, 104, 114, 114, 100, 49, 99, 107, 55, 52, 98, 77, 119, 51, 86, 89, 83, 75, 51, 88, 53, 82, 114, 68, 103, 88, 101, 108, 101, 119, 77, 85, 54, 111, 49, 116, 74, 51, 105, 88};

    private RC4Utils() {
    }

    public static String getEncryptKey() {
        return new String(TEAUtils.decrypt(ENCRYPTED_ENCRYPT_KEY, 0), StandardCharsets.UTF_8);
    }

    public static byte[] crypt(byte[] data, byte[] key) {
        int[] iS = RC4Utils.initKey(key);
        return RC4Utils.doCrypt(data, iS);
    }

    public static String crypt(String aInput, String aKey) {
        int[] iS = RC4Utils.initKey(aKey);
        char[] iOutputChar = RC4Utils.doCrypt(aInput, iS);
        return new String(iOutputChar);
    }

    private static byte[] doCrypt(byte[] data, int[] iS) {
        int i = 0;
        int j = 0;
        int t = 0;
        byte[] cryptedData = new byte[data.length];
        for (int k = 0; k < data.length; ++k) {
            i = i + 1 & 0xFF;
            j = j + iS[i] & 0xFF;
            int temp = iS[i];
            iS[i] = iS[j];
            iS[j] = temp;
            t = iS[i] + iS[j] & 0xFF;
            cryptedData[k] = (byte)(data[k] ^ iS[t]);
        }
        return cryptedData;
    }

    private static char[] doCrypt(String aInput, int[] iS) {
        char[] iInputChar = aInput.toCharArray();
        char[] iOutputChar = new char[iInputChar.length];
        for (int x = 0; x < iInputChar.length; ++x) {
            int i = 0;
            int j = 0;
            i = (i + 1) % 256;
            j = (j + iS[i]) % 256;
            int temp = iS[i];
            iS[i] = iS[j];
            iS[j] = temp;
            int t = (iS[i] + iS[j] % 256) % 256;
            int iY = iS[t];
            char iCY = (char)iY;
            iOutputChar[x] = (char)(iInputChar[x] ^ iCY);
        }
        return iOutputChar;
    }

    private static int[] initKey(byte[] keyByte) {
        int[] iS = new int[256];
        byte[] iK = new byte[256];
        for (int i = 0; i < 256; ++i) {
            iS[i] = i;
            iK[i] = keyByte[i % keyByte.length];
        }
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = j + iS[i] + iK[i] & 0xFF;
            int temp = iS[i];
            iS[i] = iS[j];
            iS[j] = temp;
        }
        return iS;
    }

    private static int[] initKey(String aKey) {
        return RC4Utils.initKey(aKey.getBytes());
    }
}

