/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util.encrypt;

import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.common.util.encrypt.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.Locale;

public class CipherUtils {
    public static final String KEY_SHA = "SHA";
    public static final String KEY_SHA_256 = "SHA-256";
    public static final String KEY_MD5 = "MD5";
    public static final HexFormat HEX_FORMAT = HexFormat.of().withUpperCase();

    private CipherUtils() {
    }

    public static byte[] decryptBASE64(String key) {
        return Base64Utils.base64DecoderCompatible(key);
    }

    public static String encryptBASE64(byte[] key) {
        return Base64Utils.encodeCompatibleEndWithLineSeparator(key);
    }

    public static byte[] encryptMD5(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance(KEY_MD5);
        md5.update(data);
        return md5.digest();
    }

    public static String encryptMD5Str(String data) throws NoSuchAlgorithmException {
        if (StringUtils.isNull(data)) {
            return null;
        }
        return CipherUtils.bytesToHexString(CipherUtils.encryptMD5(data.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] encryptSHA(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance(KEY_SHA);
        sha.update(data);
        return sha.digest();
    }

    public static byte[] encryptSHA256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance(KEY_SHA_256);
        sha.update(data);
        return sha.digest();
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte b : src) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase(Locale.ROOT);
    }

    public static String encryptSHA256WithSalt(String password, String salt) throws NoSuchAlgorithmException {
        byte[] md5Digest = CipherUtils.encryptMD5(password.getBytes(StandardCharsets.UTF_8));
        byte[] saltBytes = HEX_FORMAT.parseHex(salt);
        byte[] sourceBytes = new byte[16 + saltBytes.length];
        System.arraycopy(md5Digest, 0, sourceBytes, 0, 16);
        System.arraycopy(saltBytes, 0, sourceBytes, 16, saltBytes.length);
        return CipherUtils.bytesToHexString(CipherUtils.encryptSHA256(sourceBytes));
    }
}

