/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util.encrypt;

import java.util.Base64;

public class Base64Utils {
    private static final int BASE64_LINE_MAX = 76;
    private static final String LINE_SEPARATOR_REG = "[\n\r]";

    private Base64Utils() {
    }

    public static byte[] base64DecoderCompatible(String origin) {
        return Base64.getDecoder().decode(origin.replaceAll(LINE_SEPARATOR_REG, ""));
    }

    public static String encodeCompatible(byte[] bytes) {
        return Base64.getMimeEncoder(76, System.lineSeparator().getBytes()).encodeToString(bytes);
    }

    public static String encodeCompatibleEndWithLineSeparator(byte[] bytes) {
        return Base64.getMimeEncoder(76, System.lineSeparator().getBytes()).encodeToString(bytes) + System.lineSeparator();
    }

    public static String encodeToString(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decode(String src) {
        return Base64.getDecoder().decode(src);
    }

    public static String urlEncodeToString(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes);
    }

    public static byte[] urlDecode(String src) {
        return Base64.getUrlDecoder().decode(src);
    }

    public static String mimeEncodeToString(byte[] bytes, int length, byte[] lineSeparator) {
        return Base64.getMimeEncoder(length, lineSeparator).encodeToString(bytes);
    }

    public static String mimeEncodeToString(byte[] bytes) {
        return Base64.getMimeEncoder().encodeToString(bytes);
    }

    public static byte[] mimeDecode(String src) {
        return Base64.getMimeDecoder().decode(src);
    }
}

