/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.nbu.common.pii.utils.PIIMaskUtil;
import com.tplink.smb.ecsp.common.util.StringUtils;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class OmadaPIIUtils {
    private static final Logger log = LoggerFactory.getLogger(OmadaPIIUtils.class);
    private static final long DEFAULT_PII_CACHE_SIZE = 25000L;
    private static final long DEFAULT_EXPIRE_TIMEOUT_SECOND = 60L;
    private static final Cache<String, String> PII_ENCRYPT_CACHE;

    public static String encryptWithCache(String info) {
        try {
            if (StringUtils.isNull(info)) {
                return info;
            }
            return (String)PII_ENCRYPT_CACHE.get((Object)info, () -> PIIMaskUtil.encrypt((String)info));
        }
        catch (Throwable e) {
            log.error("pii encrypt fail", e);
            return "";
        }
    }

    public static String encryptWithoutCache(String info) {
        try {
            if (StringUtils.isNull(info)) {
                return info;
            }
            return PIIMaskUtil.encrypt((String)info);
        }
        catch (Throwable e) {
            log.error("pii encrypt fail", e);
            return "";
        }
    }

    public static String hash(String info) {
        try {
            if (StringUtils.isNull(info)) {
                return info;
            }
            return PIIMaskUtil.hash((String)info);
        }
        catch (Throwable e) {
            log.error("pii hash fail", e);
            return "";
        }
    }

    public static void clearCache() {
        PII_ENCRYPT_CACHE.cleanUp();
    }

    private OmadaPIIUtils() {
    }

    static {
        YamlPropertiesFactoryBean yamlProperties = new YamlPropertiesFactoryBean();
        yamlProperties.setResources(new Resource[]{new ClassPathResource("application.yaml")});
        Properties propertiesObject = yamlProperties.getObject();
        long piiCacheSize = Optional.ofNullable(propertiesObject).map(properties -> properties.get("ecsp.pii.cache.size")).map(String::valueOf).map(Long::valueOf).orElse(25000L);
        long expireTimeoutSecond = Optional.ofNullable(propertiesObject).map(properties -> properties.get("ecsp.pii.cache.expire-time-second")).map(String::valueOf).map(Long::valueOf).orElse(60L);
        log.info("pii cache size: {}, timeout: {} s", (Object)piiCacheSize, (Object)expireTimeoutSecond);
        PII_ENCRYPT_CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).maximumSize(piiCacheSize).expireAfterAccess(expireTimeoutSecond, TimeUnit.SECONDS).build();
    }
}

