/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    private static final int RND_PORT_START = 30000;
    private static final int RND_PORT_RANGE = 10000;
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static volatile String HOST_ADDRESS;

    private NetUtils() {
    }

    public static int getRandomPort() {
        return 30000 + ThreadLocalRandom.current().nextInt(10000);
    }

    public static int getAvailablePort() {
        int n;
        ServerSocket ss = new ServerSocket();
        try {
            ss.bind(null);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return NetUtils.getRandomPort();
            }
        }
        ss.close();
        return n;
    }

    public static boolean isLocalHost(String host) {
        return host != null && (LOCAL_IP_PATTERN.matcher(host).matches() || host.equalsIgnoreCase("localhost"));
    }

    public static boolean isInvalidLocalHost(String host) {
        return host == null || host.length() == 0 || host.equalsIgnoreCase("localhost") || host.equals("0.0.0.0") || host.startsWith("127.");
    }

    static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !"0.0.0.0".equals(name) && !"127.0.0.1".equals(name);
    }

    public static String toAddressString(InetSocketAddress address) {
        if (address == null || address.getAddress() == null) {
            return "";
        }
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    private static boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        return networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
    }

    private static List<NetworkInterface> getValidNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (NetUtils.ignoreNetworkInterface(networkInterface)) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    public static String filterLocalHost(String host) {
        if (host == null || host.length() == 0) {
            return host;
        }
        if (host.contains("://")) {
            URL u = URL.valueOf(host);
            if (NetUtils.isInvalidLocalHost(u.getHost())) {
                return u.toBuilder().host(NetUtils.getLocalHost()).build().toFullString();
            }
        } else if (host.contains(":")) {
            int i = host.lastIndexOf(58);
            if (NetUtils.isInvalidLocalHost(host.substring(0, i))) {
                return NetUtils.getLocalHost() + host.substring(i);
            }
        } else if (NetUtils.isInvalidLocalHost(host)) {
            return NetUtils.getLocalHost();
        }
        return host;
    }

    public static String getLocalHost() {
        if (HOST_ADDRESS != null) {
            return HOST_ADDRESS;
        }
        InetAddress address = NetUtils.getLocalAddress();
        if (address != null) {
            HOST_ADDRESS = address.getHostAddress();
            return HOST_ADDRESS;
        }
        return "127.0.0.1";
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            NetworkInterface networkInterface = NetUtils.findNetworkInterface();
            if (Objects.nonNull(networkInterface)) {
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
                    if (!addressOp.isPresent()) continue;
                    try {
                        if (!addressOp.get().isReachable(100)) continue;
                        return addressOp.get();
                    }
                    catch (IOException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return localAddress;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtils.isPreferIPV6Address()) {
                return Optional.ofNullable(NetUtils.normalizeV6Address(v6Address));
            }
        }
        if (NetUtils.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + "%" + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    public static NetworkInterface findNetworkInterface() {
        List<Object> validNetworkInterfaces = Collections.emptyList();
        try {
            validNetworkInterfaces = NetUtils.getValidNetworkInterfaces();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        NetworkInterface result = null;
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!NetUtils.isPreferredNetworkInterface(networkInterface)) continue;
            result = networkInterface;
            break;
        }
        if (result == null) {
            block5: for (NetworkInterface networkInterface : validNetworkInterfaces) {
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
                    if (!addressOp.isPresent()) continue;
                    try {
                        if (!addressOp.get().isReachable(100)) continue;
                        result = networkInterface;
                        continue block5;
                    }
                    catch (IOException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (result == null) {
            result = (NetworkInterface)NetUtils.first(validNetworkInterfaces);
        }
        return result;
    }

    public static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty("network.interface.preferred");
        return Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface);
    }

    public static <T> T first(Collection<T> values) {
        return CollectionUtils.isEmpty(values) ? null : (values instanceof List ? (T)((List)values).get(0) : (T)values.iterator().next());
    }
}

