/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.google.protobuf.ByteString;
import com.tplink.smb.ecsp.common.util.StringUtils;
import java.util.HexFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MacUtils {
    public static final HexFormat UPPER_DASH_FORMAT = HexFormat.ofDelimiter("-").withUpperCase();
    public static final HexFormat LOWER_DASH_FORMAT = HexFormat.ofDelimiter("-").withLowerCase();
    public static final HexFormat UPPER_COLON_FORMAT = HexFormat.ofDelimiter(":").withUpperCase();
    public static final HexFormat LOWER_COLON_FORMAT = HexFormat.ofDelimiter(":").withLowerCase();
    private static final Pattern MAC_PATTERN = Pattern.compile("[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}");

    private MacUtils() {
    }

    public static String formatDefault(byte[] bytes) {
        return UPPER_DASH_FORMAT.formatHex(bytes);
    }

    public static ByteString parse(String macAddr) {
        macAddr = macAddr.replaceAll("[-:]", "").toLowerCase(Locale.ROOT);
        return ByteString.copyFrom((byte[])HexFormat.of().parseHex(macAddr));
    }

    public static String formatDefault(ByteString byteString) {
        return UPPER_DASH_FORMAT.formatHex(byteString.toByteArray());
    }

    public static String format(byte[] bytes, boolean upperCase, @Nullable String delimiter) {
        if (delimiter == null) {
            return upperCase ? HexFormat.of().withUpperCase().formatHex(bytes) : HexFormat.of().withLowerCase().formatHex(bytes);
        }
        return switch (delimiter) {
            case "-" -> {
                if (upperCase) {
                    yield UPPER_DASH_FORMAT.formatHex(bytes);
                }
                yield LOWER_DASH_FORMAT.formatHex(bytes);
            }
            case ":" -> {
                if (upperCase) {
                    yield UPPER_COLON_FORMAT.formatHex(bytes);
                }
                yield LOWER_COLON_FORMAT.formatHex(bytes);
            }
            default -> upperCase ? HexFormat.ofDelimiter(delimiter).withUpperCase().formatHex(bytes) : HexFormat.ofDelimiter(delimiter).withLowerCase().formatHex(bytes);
        };
    }

    public static boolean validatorMac(String mac) {
        if (mac == null) {
            return false;
        }
        Matcher matcher = MAC_PATTERN.matcher(mac);
        if (matcher.matches()) {
            return !"00-00-00-00-00-00".equals(mac);
        }
        return false;
    }

    public static String formatMacDb(String mac) {
        if (!StringUtils.isNull(mac)) {
            mac = mac.replace(":", "-").toUpperCase(Locale.ROOT);
        }
        return mac;
    }

    public static String formatMacCL(String mac) {
        if (!StringUtils.isNull(mac)) {
            mac = mac.replace("-", ":").toLowerCase(Locale.ROOT);
        }
        return mac;
    }

    public static String formatMacCU(String mac) {
        if (!StringUtils.isNull(mac)) {
            mac = mac.replace("-", ":").toUpperCase(Locale.ROOT);
        }
        return mac;
    }
}

