/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoDecompressor;
import org.anarres.lzo.LzoInputStream;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.LzoOutputStream;
import org.springframework.util.StreamUtils;

public class LzoUtils {
    private LzoUtils() {
    }

    public static byte[] compress(byte[] srcBytes) throws IOException {
        LzoCompressor compressor = LzoLibrary.getInstance().newCompressor(LzoAlgorithm.LZO1X, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        LzoOutputStream lzoInputStream = new LzoOutputStream((OutputStream)os, compressor);
        lzoInputStream.write(srcBytes);
        lzoInputStream.close();
        return os.toByteArray();
    }

    public static byte[] decompress(byte[] bytes) throws IOException {
        int count;
        LzoDecompressor decompressor = LzoLibrary.getInstance().newDecompressor(LzoAlgorithm.LZO1X, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        LzoInputStream lzoInputStream = new LzoInputStream((InputStream)is, decompressor);
        byte[] buffer = new byte[2048];
        while ((count = lzoInputStream.read(buffer)) != -1) {
            os.write(buffer, 0, count);
        }
        return os.toByteArray();
    }

    @Nonnull
    public static ByteString compress(@Nonnull ByteString data) throws IOException {
        LzoCompressor compressor = LzoLibrary.getInstance().newCompressor(LzoAlgorithm.LZO1X, null);
        ByteString.Output output = ByteString.newOutput();
        try (LzoOutputStream outputStream = new LzoOutputStream((OutputStream)output, compressor);){
            ByteString byteString;
            block11: {
                InputStream inStream = data.newInput();
                try {
                    StreamUtils.copy((InputStream)inStream, (OutputStream)outputStream);
                    byteString = output.toByteString();
                    if (inStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inStream.close();
            }
            return byteString;
        }
    }

    @Nonnull
    public static ByteString decompress(@Nonnull ByteString data) throws IOException {
        LzoDecompressor decompressor = LzoLibrary.getInstance().newDecompressor(LzoAlgorithm.LZO1X, null);
        try (LzoInputStream inputStream = new LzoInputStream(data.newInput(), decompressor);){
            ByteString byteString = ByteString.readFrom((InputStream)inputStream);
            return byteString;
        }
    }
}

