/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

public class KMPUtils {
    private KMPUtils() {
    }

    public static boolean contain(String str, String sub) {
        return KMPUtils.contain(str, sub, 0);
    }

    public static boolean contain(String str, String sub, int pos) {
        int kmp = KMPUtils.kmp(str, sub, pos);
        return kmp != -1;
    }

    private static int kmp(String str, String sub, int pos) {
        if (str == null || sub == null) {
            return -1;
        }
        if (pos >= str.length() || pos < 0) {
            return -1;
        }
        int i = pos;
        int j = 0;
        int[] next = new int[sub.length()];
        KMPUtils.getNext(next, sub);
        while (i < str.length() && j < sub.length()) {
            if (j == -1 || str.charAt(i) == sub.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            j = next[j];
        }
        if (j >= sub.length()) {
            return i - j;
        }
        return -1;
    }

    private static void getNext(int[] next, String sub) {
        next[0] = -1;
        next[1] = 0;
        int i = 2;
        int k = 0;
        while (i < next.length) {
            if (k == -1 || sub.charAt(k) == sub.charAt(i - 1)) {
                next[i] = k + 1;
                ++i;
                ++k;
                continue;
            }
            k = next[k];
        }
    }
}

