/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtils {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtils.class);
    public static ObjectMapper objectMapper = new ObjectMapper();

    private JacksonUtils() {
    }

    public static <T> T json2Pojo(String jsonStr, Class<T> clazz) {
        Object object = null;
        try {
            object = objectMapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            JacksonUtils.logParseException(e);
        }
        return (T)object;
    }

    public static <T, D> T json2Pojo(String json, Class<T> tClass, Class<D> dClass) {
        Object object = null;
        try {
            object = objectMapper.readValue(json, objectMapper.getTypeFactory().constructParametricType(tClass, new Class[]{dClass}));
        }
        catch (IOException e) {
            JacksonUtils.logParseException(e);
        }
        return (T)object;
    }

    public static <T> List<T> jsonArray2PojoList(String jsonStr, Class<T> clazz) {
        List pojoList = null;
        try {
            CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
            pojoList = (List)objectMapper.readValue(jsonStr, (JavaType)listType);
        }
        catch (IOException e) {
            JacksonUtils.logParseException(e);
        }
        return pojoList;
    }

    public static <T> T readInputStream(InputStream inputStream, Class<T> tClass) {
        Object object = null;
        try {
            object = objectMapper.readValue(inputStream, tClass);
        }
        catch (IOException e) {
            JacksonUtils.logParseException(e);
        }
        return (T)object;
    }

    public static String pojo2Json(Object obj) {
        String jsonStr = "";
        try {
            jsonStr = objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            JacksonUtils.logParseException((IOException)((Object)e));
        }
        return jsonStr;
    }

    public static Map pojo2Map(Object obj) {
        Map map = null;
        try {
            map = (Map)objectMapper.convertValue(obj, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (Exception e) {
            log.warn("Parse json message exception.", (Throwable)e);
        }
        return map;
    }

    public static <T> T obj2Obj(Object fromObj, Class<T> clazz) {
        return (T)objectMapper.convertValue(fromObj, clazz);
    }

    public static List<Map<String, Object>> jsonArray2ListMap(String jsonArray) {
        List convertedListMap = null;
        try {
            convertedListMap = (List)objectMapper.readValue(jsonArray, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (IOException e) {
            JacksonUtils.logParseException(e);
        }
        return convertedListMap;
    }

    public static Map<String, Object> json2Map(String json) {
        HashMap convertedMap = null;
        try {
            convertedMap = (HashMap)objectMapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (IOException e) {
            JacksonUtils.logParseException(e);
        }
        return convertedMap;
    }

    public static <T> T map2Bean(Map<String, Object> map, Class<T> tClass) {
        return (T)objectMapper.convertValue(map, tClass);
    }

    public static String listMap2JsonArray(List<Map<String, Object>> listMap) {
        String jsonStr = "";
        try {
            jsonStr = objectMapper.writeValueAsString(listMap);
        }
        catch (JsonProcessingException e) {
            JacksonUtils.logParseException((IOException)((Object)e));
        }
        return jsonStr;
    }

    public static <T> Object parseJsonMap(Map<String, Object> map, String jsonKey, Class<T> tClass) {
        if (map == null) {
            return null;
        }
        Map jsonValue = (Map)map.get(jsonKey);
        return jsonValue == null ? null : JacksonUtils.map2Bean(jsonValue, tClass);
    }

    private static void logParseException(IOException e) {
        log.warn("Parse json message exception.", (Throwable)e);
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

