/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.tplink.smb.ecsp.common.util.StringUtils;
import java.net.InterfaceAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    private IpUtils() {
    }

    public static String getCorrectLocalIp(String remoteIp, List<InterfaceAddress> localInterfaceAddresses) {
        if (CollectionUtils.isEmpty(localInterfaceAddresses)) {
            log.warn("network interfaces is null or empty");
            return null;
        }
        for (InterfaceAddress interfaceAddress : localInterfaceAddresses) {
            String localSubnetMask = IpUtils.getSubnetMaskByNetWorkPrefixLength(interfaceAddress.getNetworkPrefixLength());
            String localIp = interfaceAddress.getAddress().getHostAddress();
            if (!IpUtils.isLocalIpRemoteIpMatch(remoteIp, localIp, localSubnetMask)) continue;
            return localIp;
        }
        return null;
    }

    public static String getSubnetMaskByNetWorkPrefixLength(int networkPrefixLength) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                s.append(".");
            }
            StringBuilder sb = new StringBuilder();
            for (int j = i * 8; j < (i + 1) * 8; ++j) {
                if (j < networkPrefixLength) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
            s.append(Integer.valueOf(sb.toString(), 2));
        }
        return s.toString();
    }

    public static boolean isLocalIpRemoteIpMatch(String remoteIp, String localIp, String mask) {
        int[] remoteIpInts;
        int[] maskInts = IpUtils.getIntegerArraysByIp(mask);
        if (maskInts.length != (remoteIpInts = IpUtils.getIntegerArraysByIp(remoteIp)).length) {
            return false;
        }
        for (int i = 0; i < remoteIpInts.length; ++i) {
            remoteIpInts[i] = remoteIpInts[i] & maskInts[i];
        }
        int[] localIpInts = IpUtils.getIntegerArraysByIp(localIp);
        boolean flag = false;
        for (int i = 0; i < localIpInts.length; ++i) {
            localIpInts[i] = localIpInts[i] & maskInts[i];
            if (localIpInts[i] != remoteIpInts[i]) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    public static int[] getIntegerArraysByIp(String ip) {
        String[] splits = StringUtils.split(ip, '.');
        int[] result = new int[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            result[i] = Integer.parseInt(splits[i]);
        }
        return result;
    }
}

