/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.TimeUtils;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InterfaceUtils {
    private static final Logger log = LoggerFactory.getLogger(InterfaceUtils.class);
    private static final String IP_PATTERN = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
    private static final Pattern PATTERN = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)");
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private List<InterfaceAddress> interfaceAddrList = null;
    private long lastRefreshIpTimeS;
    private static final int INTERFACE_TIMEOUTS = 60;
    private List<String> interfaceMacList = null;
    private long lastRefreshMacTimeS;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwlock.readLock();
    private final Lock wLock = this.rwlock.writeLock();

    private InterfaceUtils() {
    }

    public static InterfaceUtils getInstance() {
        return InterfaceUtilsHolder.instance;
    }

    public static List<InterfaceAddress> listAllInterfaceAddrs() {
        return InterfaceUtils.getInstance().doListAllInterfaceAddrs();
    }

    public static List<String> listAllLocalIps() {
        ArrayList<String> list = new ArrayList<String>();
        List<InterfaceAddress> interfaceAddresses = InterfaceUtils.listAllInterfaceAddrs();
        for (InterfaceAddress ifa : interfaceAddresses) {
            list.add(ifa.getAddress().getHostAddress());
        }
        return list;
    }

    public static List<String> listAllLocalMacs() {
        return InterfaceUtils.getInstance().doListAllInterfaceMacs();
    }

    @Deprecated
    public static String getLocalMac() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface net = NetworkInterface.getByInetAddress(address);
            return InterfaceUtils.transByteMacToString(net.getHardwareAddress());
        }
        catch (Exception e) {
            log.warn("Failed to get local mac address.");
            return null;
        }
    }

    public static String getMac(InterfaceAddress address) {
        try {
            byte[] macByte = NetworkInterface.getByInetAddress(address.getAddress()).getHardwareAddress();
            return InterfaceUtils.transByteMacToString(macByte);
        }
        catch (Exception ex) {
            log.warn("Failed to parse {}, Exception: {}", (Object)address, (Object)ex);
            return null;
        }
    }

    public static String transByteMacToString(byte[] macBytes) {
        if (macBytes.length != 6) {
            log.error("Invalid mac {}", (Object)OmadaPIIUtils.encryptWithCache(Arrays.toString(macBytes)));
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < macBytes.length; ++i) {
            if (i != 0) {
                builder.append("-");
            }
            builder.append(String.format("%02X", macBytes[i]));
        }
        return builder.toString();
    }

    private List<InterfaceAddress> doListAllInterfaceAddrs() {
        List<InterfaceAddress> addressList;
        this.rLock.lock();
        try {
            addressList = this.getCachedInterfaceAddrs();
        }
        finally {
            this.rLock.unlock();
        }
        if (!CollectionUtils.isEmpty(addressList)) {
            return addressList;
        }
        this.wLock.lock();
        try {
            addressList = InterfaceUtils.findAllInterfaceAddress();
            this.interfaceAddrList = CollectionUtils.isEmpty(addressList) ? Collections.EMPTY_LIST : Collections.unmodifiableList(addressList);
            this.lastRefreshIpTimeS = System.currentTimeMillis() / 1000L;
        }
        finally {
            this.wLock.unlock();
        }
        return this.interfaceAddrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> doListAllInterfaceMacs() {
        List<String> macList;
        this.rLock.lock();
        try {
            macList = this.getCachedInterfaceMacs();
        }
        finally {
            this.rLock.unlock();
        }
        if (!CollectionUtils.isEmpty(macList)) {
            return macList;
        }
        this.wLock.lock();
        try {
            List<InterfaceAddress> addressList = this.getCachedInterfaceAddrs();
            if (CollectionUtils.isEmpty(addressList)) {
                addressList = InterfaceUtils.findAllInterfaceAddress();
            }
            if (!CollectionUtils.isEmpty(addressList)) {
                macList = new ArrayList<String>(addressList.size());
                for (InterfaceAddress address : addressList) {
                    String mac = InterfaceUtils.getMac(address);
                    if (mac == null) continue;
                    macList.add(mac);
                }
            }
            this.interfaceMacList = CollectionUtils.isEmpty(macList) ? Collections.EMPTY_LIST : Collections.unmodifiableList(macList);
            this.lastRefreshMacTimeS = System.currentTimeMillis() / 1000L;
        }
        finally {
            this.wLock.unlock();
        }
        return this.interfaceMacList;
    }

    private List<InterfaceAddress> getCachedInterfaceAddrs() {
        boolean needRefresh;
        boolean bl = needRefresh = this.interfaceAddrList == null || TimeUtils.isTimeoutS(this.lastRefreshIpTimeS, 60);
        if (!needRefresh) {
            return this.interfaceAddrList;
        }
        return new ArrayList<InterfaceAddress>();
    }

    private List<String> getCachedInterfaceMacs() {
        boolean needRefresh;
        boolean bl = needRefresh = this.interfaceMacList == null || TimeUtils.isTimeoutS(this.lastRefreshMacTimeS, 60);
        if (!needRefresh) {
            return this.interfaceMacList;
        }
        return new ArrayList<String>();
    }

    private static List<InterfaceAddress> findAllInterfaceAddress() {
        ArrayList<InterfaceAddress> list = new ArrayList<InterfaceAddress>(1);
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                List<InterfaceAddress> addresses = ni.getInterfaceAddresses();
                for (InterfaceAddress addr : addresses) {
                    Matcher matcher;
                    String ip = addr.getAddress().getHostAddress();
                    if (ip == null || !(matcher = PATTERN.matcher(ip)).find() || ip.equals(LOCAL_HOST_IP)) continue;
                    list.add(addr);
                }
            }
        }
        catch (SocketException e) {
            log.warn("get local net interface address exception : " + e.getMessage(), (Throwable)e);
            return new ArrayList<InterfaceAddress>();
        }
        InterfaceUtils.sortAddressBySubnetMask(list);
        return list;
    }

    private static void sortAddressBySubnetMask(List<InterfaceAddress> interfaceAddresses) {
        interfaceAddresses.sort((o1, o2) -> o1.getNetworkPrefixLength() > o2.getNetworkPrefixLength() ? -1 : 1);
    }

    private static class InterfaceUtilsHolder {
        static final InterfaceUtils instance = new InterfaceUtils();

        private InterfaceUtilsHolder() {
        }
    }
}

