/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.tplink.smb.ecsp.common.util.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtils.class);
    private static final ExecutorService SHUTDOWN_EXECUTOR = ExecutorUtils.newSingleThreadExecutor(100, "Close-ExecutorService-Timer");

    private ExecutorUtils() {
    }

    public static ExecutorService newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQueue, String name) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryBuilder().setNameFormat(name + "-%s").build());
    }

    public static ExecutorService newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQueue, String name, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryBuilder().setNameFormat(name + "-%s").build(), handler);
    }

    public static ExecutorService newSingleThreadExecutor(int blockQueueSize, String name) {
        return ExecutorUtils.newThreadPoolExecutor(0, 1, 0L, new LinkedBlockingQueue<Runnable>(blockQueueSize), name);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(name + "-%s").build());
    }

    public static ScheduledExecutorService newFixedThreadScheduledExecutor(int nThreads, String name) {
        return new ScheduledThreadPoolExecutor(nThreads, new ThreadFactoryBuilder().setNameFormat(name + "-%s").build());
    }

    public static ExecutorService newFixedThreadPool(int nThreads, int blockQueueSize, String name, RejectedExecutionHandler handler) {
        return ExecutorUtils.newThreadPoolExecutor(nThreads, nThreads, 0L, new LinkedBlockingQueue<Runnable>(blockQueueSize), name, handler);
    }

    public static void gracefulShutdown(Executor executor, int timeout) {
        if (!(executor instanceof ExecutorService) || ExecutorUtils.isTerminated(executor)) {
            return;
        }
        ExecutorService es = (ExecutorService)executor;
        try {
            es.shutdown();
        }
        catch (NullPointerException | SecurityException ex2) {
            return;
        }
        try {
            if (!es.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                es.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            es.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!ExecutorUtils.isTerminated(es)) {
            ExecutorUtils.newThreadToCloseExecutor(es);
        }
    }

    public static void shutdownNow(Executor executor, int timeout) {
        if (!(executor instanceof ExecutorService) || ExecutorUtils.isTerminated(executor)) {
            return;
        }
        ExecutorService es = (ExecutorService)executor;
        try {
            es.shutdownNow();
        }
        catch (NullPointerException | SecurityException ex2) {
            return;
        }
        try {
            es.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (!ExecutorUtils.isTerminated(es)) {
            ExecutorUtils.newThreadToCloseExecutor(es);
        }
    }

    public static boolean isTerminated(Executor executor) {
        return executor instanceof ExecutorService && ((ExecutorService)executor).isTerminated();
    }

    private static void newThreadToCloseExecutor(ExecutorService es) {
        if (!ExecutorUtils.isTerminated(es)) {
            SHUTDOWN_EXECUTOR.execute(() -> {
                try {
                    for (int i = 0; i < 1000; ++i) {
                        es.shutdownNow();
                        if (!es.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }
}

