/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.util;

import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseAdoptResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcspEmMergeUtils {
    private static final Logger log = LoggerFactory.getLogger(EcspEmMergeUtils.class);

    public static EcspMessage merge(EcspMessage ecspMessage1, EcspMessage ecspMessage2) {
        Map<String, Object> additionalPropertiesMap1 = ecspMessage1.getBody().getData();
        Map<String, Object> additionalPropertiesMap2 = ecspMessage2.getBody().getData();
        Map<String, Object> tempMap = EcspEmMergeUtils.deepMergeMaps(additionalPropertiesMap1, additionalPropertiesMap2);
        MessageType messageType = MessageType.fromInteger(ecspMessage1.getMessageType());
        BaseAdoptResponse finalBody = null;
        switch (messageType) {
            case DEVICE_NEGOTIATION: {
                BaseAdoptResponse body1 = (BaseAdoptResponse)ecspMessage1.getBody();
                BaseAdoptResponse body2 = (BaseAdoptResponse)ecspMessage2.getBody();
                finalBody = new BaseAdoptResponse();
                finalBody.setKey(Objects.nonNull(body1.getKey()) ? body1.getKey() : body2.getKey());
                finalBody.setDeviceInfo(Objects.nonNull(body1.getDeviceInfo()) ? body1.getDeviceInfo() : body2.getDeviceInfo());
                finalBody.getAdditionalProperties().putAll(tempMap);
                break;
            }
            default: {
                log.warn("not implement yet, mac:{}, message type: {}", (Object)OmadaPIIUtils.encryptWithCache(ecspMessage1.getMac()), (Object)ecspMessage1.getMessageType());
            }
        }
        return new EcspMessage(ecspMessage1.getHeader(), finalBody);
    }

    public static Map<String, Object> deepMergeMaps(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> result = new HashMap<String, Object>(map1);
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String key = entry.getKey();
            Object value2 = entry.getValue();
            if (result.containsKey(key)) {
                Object value1 = result.get(key);
                result.put(key, EcspEmMergeUtils.mergeValues(value1, value2));
                continue;
            }
            result.put(key, value2);
        }
        return result;
    }

    private static Object mergeValues(Object v1, Object v2) {
        if (v1 instanceof Map && v2 instanceof Map) {
            return EcspEmMergeUtils.deepMergeMaps((Map)v1, (Map)v2);
        }
        if (v1 instanceof Collection && v2 instanceof Collection) {
            ArrayList merged = new ArrayList((Collection)v1);
            merged.addAll((Collection)v2);
            return merged;
        }
        return v2;
    }

    private EcspEmMergeUtils() {
    }
}

