/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.monitor;

import com.tplink.smb.ecsp.common.StringTags;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorHelper {
    private static final Logger log = LoggerFactory.getLogger(MonitorHelper.class);
    private static MeterRegistry staticMeterRegistry = new SimpleMeterRegistry();
    private static boolean enableMonitor = false;
    private static Timer staticTimer = Timer.builder((String)"fake_timer").register(staticMeterRegistry);
    private static AtomicInteger staticInteger = new AtomicInteger();
    private static AtomicLong staticLong = new AtomicLong();

    private MonitorHelper() {
    }

    public static void loadMeterRegistry(@Nullable MeterRegistry meterRegistry) {
        if (Objects.nonNull(meterRegistry) && !meterRegistry.getClass().equals(staticMeterRegistry.getClass()) && !Objects.equals(meterRegistry, staticMeterRegistry)) {
            staticMeterRegistry = meterRegistry;
            enableMonitor = true;
        }
    }

    public static void incCounter(@Nonnull Map<StringTags, Counter> counterMap, @Nonnull String name, @Nonnull StringTags tags) {
        Counter old;
        if (!enableMonitor) {
            return;
        }
        Counter counter = counterMap.get(tags);
        if (null == counter && null != (old = counterMap.putIfAbsent(tags, counter = staticMeterRegistry.counter(name, tags.getTags())))) {
            counter = old;
        }
        counter.increment();
    }

    public static AtomicInteger getIntegerGauge(@Nonnull Map<StringTags, AtomicInteger> gaugeMap, @Nonnull String name, @Nonnull StringTags tags) {
        AtomicInteger old;
        if (!enableMonitor) {
            return staticInteger;
        }
        AtomicInteger gaugeValue = gaugeMap.get(tags);
        if (null == gaugeValue && null != (old = gaugeMap.putIfAbsent(tags, gaugeValue = (AtomicInteger)staticMeterRegistry.gauge(name, tags.getTagList(), (Number)new AtomicInteger(0))))) {
            gaugeValue = old;
        }
        return gaugeValue;
    }

    public static AtomicLong getLongGauge(@Nonnull Map<StringTags, AtomicLong> gaugeMap, @Nonnull String name, @Nonnull StringTags tags) {
        AtomicLong old;
        if (!enableMonitor) {
            return staticLong;
        }
        AtomicLong gaugeValue = gaugeMap.get(tags);
        if (null == gaugeValue && null != (old = gaugeMap.putIfAbsent(tags, gaugeValue = (AtomicLong)staticMeterRegistry.gauge(name, tags.getTagList(), (Number)new AtomicLong(0L))))) {
            gaugeValue = old;
        }
        return gaugeValue;
    }

    public static Timer getTimer(@Nonnull Map<StringTags, Timer> timerMap, @Nonnull String name, @Nonnull StringTags tags) {
        Timer old;
        if (!enableMonitor) {
            return staticTimer;
        }
        Timer timer = timerMap.get(tags);
        if (null == timer && null != (old = timerMap.putIfAbsent(tags, timer = Timer.builder((String)name).tags(tags.getTags()).publishPercentiles(new double[]{0.5, 0.9}).register(staticMeterRegistry)))) {
            timer = old;
        }
        return timer;
    }
}

