/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.monitor;

import com.tplink.smb.ecsp.common.StringTags;
import com.tplink.smb.ecsp.common.monitor.MonitorConstants;
import com.tplink.smb.ecsp.common.monitor.MonitorHelper;
import io.micrometer.core.instrument.Counter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonMonitor {
    private static final Logger log = LoggerFactory.getLogger(CommonMonitor.class);
    private static final Map<StringTags, Counter> serverRouteCounterMap = new ConcurrentHashMap<StringTags, Counter>(3);
    private static final Map<StringTags, Counter> gRPCRequestCounterMap = new ConcurrentHashMap<StringTags, Counter>(2);
    private static final Map<StringTags, Counter> threadPoolCounters = new ConcurrentHashMap<StringTags, Counter>(2);

    private CommonMonitor() {
    }

    public static void incServerRouteGetFailedCounter() {
        MonitorHelper.incCounter(serverRouteCounterMap, "device.server.route.get", MonitorConstants.STATUS_FAILED_TAGS);
    }

    public static void incServerRouteGetCounter() {
        MonitorHelper.incCounter(serverRouteCounterMap, "device.server.route.get", MonitorConstants.STATUS_ALL_TAGS);
    }

    public static void incServerRouteUpdateCounter() {
        MonitorHelper.incCounter(serverRouteCounterMap, "device.server.route", MonitorConstants.SERVER_ROUTE_UPDATE_TAGS);
    }

    public static void incServerRouteExpireCounter() {
        MonitorHelper.incCounter(serverRouteCounterMap, "device.server.route", MonitorConstants.SERVER_ROUTE_EXPIRE_TAGS);
    }

    public static void incServerRouteIgnoreCounter() {
        MonitorHelper.incCounter(serverRouteCounterMap, "device.server.route", MonitorConstants.SERVER_ROUTE_IGNORE_TAGS);
    }

    public static void incSuccessGrpcRequestCounter() {
        MonitorHelper.incCounter(gRPCRequestCounterMap, "grpc.server.requests", MonitorConstants.STATUS_SUCCESS_TAGS);
    }

    public static void incFailedGrpcRequestCounter() {
        MonitorHelper.incCounter(gRPCRequestCounterMap, "grpc.server.requests", MonitorConstants.STATUS_FAILED_TAGS);
    }

    public static void incThreadPoolRejectedCounter(@Nonnull String threadPoolName) {
        StringTags threadPoolTags = new StringTags("name", threadPoolName);
        MonitorHelper.incCounter(threadPoolCounters, "executor.pool.rejected", threadPoolTags);
    }
}

