/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common.exception;

import java.util.HashMap;
import java.util.Map;

public final class ECSPError {
    public static final Map<Integer, String> errCodeSenseMap = new HashMap<Integer, String>();

    public static String getDefaultErrorMessage(int errorCode) {
        return errCodeSenseMap.get(errorCode);
    }

    private ECSPError() {
    }

    static {
        errCodeSenseMap.put(0, "ERR_SUCCESS");
        errCodeSenseMap.put(-25001, "ERR_AUTHENTICATION_FAILED");
        errCodeSenseMap.put(-25002, "ERR_USER_INVALID");
        errCodeSenseMap.put(-25003, "ERR_USER_NOT_ADMIN");
        errCodeSenseMap.put(-25004, "UNSUPPORTED_CIPHER_TYPE");
    }

    public static final class ERR_CODE {
        public static final int ERR_SUCCESS = 0;
        public static final int ERR_AUTHENTICATION_FAILED = -25001;
        public static final int ERR_USER_INVALID = -25002;
        public static final int ERR_USER_NOT_ADMIN = -25003;
        public static final int UNSUPPORTED_CIPHER_TYPE = -25004;

        private ERR_CODE() {
        }
    }
}

