/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import com.tplink.smb.ecsp.common.util.ArrayUtils;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.NetUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class URL
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    private final String protocol;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final String path;
    private final Map<String, String> parameters;
    private final Map<String, Map<String, String>> methodParameters;
    private final transient CacheHolder cacheHolder;

    private void checkArgument() {
        if (StringUtils.isEmpty(this.username) && StringUtils.isNotEmpty(this.password)) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
    }

    public static URLBuilder builder() {
        return new InternalBuilder();
    }

    public static URL valueOf(String url) {
        if (StringUtils.isNull(url)) {
            throw new IllegalArgumentException("url == null");
        }
        String protocol = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int i = url.indexOf(63);
        if (i >= 0) {
            String[] parts = url.substring(i + 1).split("&");
            parameters = new HashMap<String, String>();
            for (String part : parts) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    String key = part.substring(0, j);
                    String value = part.substring(j + 1);
                    parameters.put(key, value);
                    continue;
                }
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf(47);
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.lastIndexOf(64)) >= 0) {
            username = url.substring(0, i);
            int j = username.indexOf(58);
            if (j >= 0) {
                password = username.substring(j + 1);
                username = username.substring(0, j);
            }
            url = url.substring(i + 1);
        }
        if ((i = url.lastIndexOf(58)) >= 0 && i < url.length() - 1 && url.lastIndexOf(37) <= i) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        return URL.builder().protocol(protocol).username(username).password(password).host(host).port(port).path(path).parameters(parameters).build();
    }

    private Map<String, Number> getNumbers() {
        if (this.cacheHolder.numbers == null) {
            this.cacheHolder.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.cacheHolder.numbers;
    }

    public boolean isLocalHost() {
        return NetUtils.isLocalHost(this.host) || this.getParameter("localhost", false);
    }

    public boolean isAnyHost() {
        return "0.0.0.0".equals(this.host) || this.getParameter("anyhost", false);
    }

    public static void putMethodParameter(String method, String key, String value, Map<String, Map<String, String>> methodParameters) {
        Map subParameter = methodParameters.computeIfAbsent(method, k -> new HashMap());
        subParameter.put(key, value);
    }

    public String getParameter(String key) {
        return this.parameters != null ? this.parameters.get(key) : null;
    }

    public boolean getParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public double getParameter(String key, double defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    public float getParameter(String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    public long getParameter(String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public int getParameter(String key, int defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    public short getParameter(String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    public byte getParameter(String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    public int getPositiveParameter(String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public URL addParameter(String key, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.getParameters() != null && value.equals(this.getParameters().get(key))) {
            return this;
        }
        HashMap<String, String> map = this.getParameters() != null ? new HashMap<String, String>(this.getParameters()) : new HashMap();
        map.put(key, value);
        return this.toBuilder().parameters(map).build();
    }

    public URL addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        HashMap<String, String> map = this.getParameters() != null ? new HashMap<String, String>(this.getParameters()) : new HashMap();
        map.put(key, value);
        return this.toBuilder().parameters(map).build();
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.parameters);
        if (this.protocol != null) {
            map.put("protocol", this.protocol);
        }
        if (this.username != null) {
            map.put("username", this.username);
        }
        if (this.password != null) {
            map.put("password", this.password);
        }
        if (this.host != null) {
            map.put("host", this.host);
        }
        if (this.port > 0) {
            map.put("port", String.valueOf(this.port));
        }
        if (this.path != null) {
            map.put("path", this.path);
        }
        return map;
    }

    public String toString() {
        if (this.cacheHolder.string == null) {
            this.cacheHolder.string = this.buildString(false, true, new String[0]);
        }
        return this.cacheHolder.string;
    }

    private String getAddress(String host, int port) {
        if (this.cacheHolder.address == null) {
            this.cacheHolder.address = port <= 0 ? host : host + ":" + port;
        }
        return this.cacheHolder.address;
    }

    public String toString(String ... parameters) {
        return this.buildString(false, true, parameters);
    }

    public String toIdentityString() {
        if (this.cacheHolder.identity == null) {
            this.cacheHolder.identity = this.buildString(true, false, new String[0]);
        }
        return this.cacheHolder.identity;
    }

    public String toIdentityString(String ... parameters) {
        return this.buildString(true, false, parameters);
    }

    public String toFullString() {
        if (this.cacheHolder.full == null) {
            this.cacheHolder.full = this.buildString(true, true, new String[0]);
        }
        return this.cacheHolder.full;
    }

    public String toFullString(String ... parameters) {
        return this.buildString(true, true, parameters);
    }

    public String toParameterString() {
        if (this.cacheHolder.parameter == null) {
            this.cacheHolder.parameter = this.toParameterString(new String[0]);
        }
        return this.cacheHolder.parameter;
    }

    public String toParameterString(String ... parameters) {
        StringBuilder buf = new StringBuilder();
        this.buildParameters(buf, false, parameters);
        return buf.toString();
    }

    private String buildString(boolean appendUser, boolean appendParameter, String ... parameters) {
        return this.buildString(appendUser, appendParameter, false, false, parameters);
    }

    private String buildString(boolean appendUser, boolean appendParameter, boolean useIP, boolean useService, String ... parameters) {
        String pathTemp;
        String hostTemp;
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty(this.protocol)) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if (appendUser && StringUtils.isNotEmpty(this.username)) {
            buf.append(this.username);
            if (StringUtils.isNotEmpty(this.password)) {
                buf.append(":");
                buf.append(this.password);
            }
            buf.append("@");
        }
        if (StringUtils.isNotEmpty(hostTemp = useIP ? this.cacheHolder.ip : this.getHost())) {
            buf.append(hostTemp);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if (StringUtils.isNotEmpty(pathTemp = useService ? this.cacheHolder.serviceKey : this.getPath())) {
            buf.append("/");
            buf.append(pathTemp);
        }
        if (appendParameter) {
            this.buildParameters(buf, true, parameters);
        }
        return buf.toString();
    }

    private void buildParameters(StringBuilder buf, boolean concat, String[] parameters) {
        if (CollectionUtils.isEmptyMap(this.getParameters())) {
            return;
        }
        List<String> includes = ArrayUtils.isEmpty(parameters) ? null : Arrays.asList(parameters);
        boolean first = true;
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
            if (StringUtils.isEmpty(entry.getKey()) || includes != null && !includes.contains(entry.getKey())) continue;
            if (first) {
                if (concat) {
                    buf.append("?");
                }
                first = false;
            } else {
                buf.append("&");
            }
            buf.append(entry.getKey());
            buf.append("=");
            buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
        }
    }

    public java.net.URL toJavaURL() {
        try {
            return new java.net.URL(this.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URL other = (URL)obj;
        if (!StringUtils.isEquals(this.host, other.host)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (!StringUtils.isEquals(this.password, other.password)) {
            return false;
        }
        if (!StringUtils.isEquals(this.path, other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (!StringUtils.isEquals(this.protocol, other.protocol)) {
            return false;
        }
        return StringUtils.isEquals(this.username, other.username);
    }

    private static CacheHolder $default$cacheHolder() {
        return new CacheHolder();
    }

    URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Map<String, String>> methodParameters, CacheHolder cacheHolder) {
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.methodParameters = methodParameters;
        this.cacheHolder = cacheHolder;
    }

    public URLBuilder toBuilder() {
        return new URLBuilder().protocol(this.protocol).username(this.username).password(this.password).host(this.host).port(this.port).path(this.path).parameters(this.parameters).methodParameters(this.methodParameters).cacheHolder(this.cacheHolder);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, Map<String, String>> getMethodParameters() {
        return this.methodParameters;
    }

    public CacheHolder getCacheHolder() {
        return this.cacheHolder;
    }

    public static class InternalBuilder
    extends URLBuilder {
        InternalBuilder() {
        }

        @Override
        public URL build() {
            String path;
            URL url = super.build();
            url.checkArgument();
            url.cacheHolder.address = url.getAddress(url.host, url.port);
            for (path = url.path; path != null && path.startsWith("/"); path = path.substring(1)) {
            }
            return url.toBuilder().port(Math.max(url.port, 0)).path(path).build();
        }
    }

    public static class URLBuilder {
        private String protocol;
        private String username;
        private String password;
        private String host;
        private int port;
        private String path;
        private Map<String, String> parameters;
        private Map<String, Map<String, String>> methodParameters;
        private boolean cacheHolder$set;
        private CacheHolder cacheHolder$value;

        URLBuilder() {
        }

        public URLBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public URLBuilder username(String username) {
            this.username = username;
            return this;
        }

        public URLBuilder password(String password) {
            this.password = password;
            return this;
        }

        public URLBuilder host(String host) {
            this.host = host;
            return this;
        }

        public URLBuilder port(int port) {
            this.port = port;
            return this;
        }

        public URLBuilder path(String path) {
            this.path = path;
            return this;
        }

        public URLBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public URLBuilder methodParameters(Map<String, Map<String, String>> methodParameters) {
            this.methodParameters = methodParameters;
            return this;
        }

        public URLBuilder cacheHolder(CacheHolder cacheHolder) {
            this.cacheHolder$value = cacheHolder;
            this.cacheHolder$set = true;
            return this;
        }

        public URL build() {
            CacheHolder cacheHolder$value = this.cacheHolder$value;
            if (!this.cacheHolder$set) {
                cacheHolder$value = URL.$default$cacheHolder();
            }
            return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, this.parameters, this.methodParameters, cacheHolder$value);
        }

        public String toString() {
            return "URL.URLBuilder(protocol=" + this.protocol + ", username=" + this.username + ", password=" + this.password + ", host=" + this.host + ", port=" + this.port + ", path=" + this.path + ", parameters=" + this.parameters + ", methodParameters=" + this.methodParameters + ", cacheHolder$value=" + this.cacheHolder$value + ")";
        }
    }

    static class CacheHolder {
        transient Map<String, Number> numbers;
        transient String ip;
        transient String full;
        transient String identity;
        transient String parameter;
        transient String string;
        transient String serviceKey;
        transient String address;

        CacheHolder() {
        }
    }
}

