/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.exception.TransError;

public class TransResult<T> {
    private int errCode;
    private String msg;
    private T result;
    private AddressDTO addressDTO;

    public TransResult() {
        this.errCode = 0;
        this.msg = TransError.getDefaultErrorMessage(this.errCode);
    }

    public TransResult(int errCode) {
        this.errCode = errCode;
        this.msg = TransError.getDefaultErrorMessage(this.errCode);
    }

    public TransResult(T result) {
        this.errCode = 0;
        this.msg = TransError.getDefaultErrorMessage(this.errCode);
        this.result = result;
    }

    public TransResult(T result, AddressDTO addressDTO) {
        this.errCode = 0;
        this.msg = TransError.getDefaultErrorMessage(this.errCode);
        this.result = result;
        this.addressDTO = addressDTO;
    }

    public TransResult(int errCode, T result) {
        this.errCode = errCode;
        this.msg = TransError.getDefaultErrorMessage(this.errCode);
        this.result = result;
    }

    public TransResult(int errCode, String msg, T result) {
        this.errCode = errCode;
        this.msg = msg;
        this.result = result;
    }

    public boolean isOK() {
        return 0 == this.errCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getResult() {
        return this.result;
    }

    public AddressDTO getAddressDTO() {
        return this.addressDTO;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setAddressDTO(AddressDTO addressDTO) {
        this.addressDTO = addressDTO;
    }

    public String toString() {
        return "TransResult(errCode=" + this.getErrCode() + ", msg=" + this.getMsg() + ", result=" + this.getResult() + ", addressDTO=" + this.getAddressDTO() + ")";
    }

    public TransResult(int errCode, String msg, T result, AddressDTO addressDTO) {
        this.errCode = errCode;
        this.msg = msg;
        this.result = result;
        this.addressDTO = addressDTO;
    }
}

