/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import com.tplink.smb.ecsp.common.monitor.CommonMonitor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExecutorRejectedPolicy {
    CALLER_RUNS("CallerRunsPolicy"),
    ABORT("AbortPolicy"),
    DISCARD("DiscardPolicy"),
    DISCARD_OLDEST("DiscardOldestPolicy");

    private final String policy;
    private static final String REJECTED_EXECUTION_HANDLER_LOG = "Thread pool is EXHAUSTED! Rejected policy is %s! Thread Name: %s, Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d), Executor status: (isShutdown:%s, isTerminated:%s, isTerminating:%s)!";

    private ExecutorRejectedPolicy(String policy) {
        this.policy = policy;
    }

    public static RejectedExecutionHandler getRejectedHandler(ExecutorRejectedPolicy policy, String executorName) {
        switch (policy) {
            case CALLER_RUNS: {
                return new CallerRunsPolicyWithReport(executorName);
            }
            case ABORT: {
                return new AbortPolicyWithReport(executorName);
            }
            case DISCARD: {
                return new DiscardPolicyWithReport(executorName);
            }
        }
        return new DiscardOldestPolicyWithReport(executorName);
    }

    public String getPolicy() {
        return this.policy;
    }

    public static class CallerRunsPolicyWithReport
    extends ThreadPoolExecutor.CallerRunsPolicy {
        private static final Logger log = LoggerFactory.getLogger(CallerRunsPolicyWithReport.class);
        private final String executorName;

        CallerRunsPolicyWithReport(String executorName) {
            this.executorName = executorName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            CommonMonitor.incThreadPoolRejectedCounter(this.executorName);
            String msg = String.format(ExecutorRejectedPolicy.REJECTED_EXECUTION_HANDLER_LOG, "Caller Runs", this.executorName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
            log.warn(msg);
            super.rejectedExecution(r, e);
        }
    }

    public static class AbortPolicyWithReport
    extends ThreadPoolExecutor.AbortPolicy {
        private static final Logger log = LoggerFactory.getLogger(AbortPolicyWithReport.class);
        private final String executorName;

        AbortPolicyWithReport(String executorName) {
            this.executorName = executorName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            CommonMonitor.incThreadPoolRejectedCounter(this.executorName);
            String msg = String.format(ExecutorRejectedPolicy.REJECTED_EXECUTION_HANDLER_LOG, "Abort", this.executorName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
            log.warn(msg);
            super.rejectedExecution(r, e);
        }
    }

    public static class DiscardPolicyWithReport
    extends ThreadPoolExecutor.DiscardPolicy {
        private static final Logger log = LoggerFactory.getLogger(DiscardPolicyWithReport.class);
        private final String executorName;

        DiscardPolicyWithReport(String executorName) {
            this.executorName = executorName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            CommonMonitor.incThreadPoolRejectedCounter(this.executorName);
            String msg = String.format(ExecutorRejectedPolicy.REJECTED_EXECUTION_HANDLER_LOG, "Discard", this.executorName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
            log.warn(msg);
            super.rejectedExecution(r, e);
        }
    }

    public static class DiscardOldestPolicyWithReport
    extends ThreadPoolExecutor.DiscardOldestPolicy {
        private static final Logger log = LoggerFactory.getLogger(DiscardOldestPolicyWithReport.class);
        private final String executorName;

        DiscardOldestPolicyWithReport(String executorName) {
            this.executorName = executorName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            CommonMonitor.incThreadPoolRejectedCounter(this.executorName);
            String msg = String.format(ExecutorRejectedPolicy.REJECTED_EXECUTION_HANDLER_LOG, "DiscardOldest", this.executorName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
            log.warn(msg);
            super.rejectedExecution(r, e);
        }
    }
}

