/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import com.tplink.smb.ecsp.common.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum DeviceType {
    AP("ap", "ap"),
    GATEWAY("gateway", "osg"),
    SWITCH("switch", "osw"),
    PRO_AP("pro ap", "pro ap"),
    PRO_GATEWAY("pro gateway", "pro osg"),
    PRO_SWITCH("pro switch", "pro osw"),
    FESTA_AP("festa ap", "festa ap"),
    FESTA_GATEWAY("festa gateway", "festa osg"),
    FESTA_SWITCH("festa switch", "festa osw"),
    EMS("ems", "ems"),
    OLT("olt", "olt"),
    ONU("onu", "onu");

    private final String type;
    private final String alias;
    private static final Map<String, DeviceType> typeMap;

    private DeviceType(String type, String alias) {
        this.type = type;
        this.alias = alias;
    }

    private static DeviceType fromString(String type) {
        return typeMap.get(type);
    }

    public static DeviceType resolve(String type) {
        if (StringUtils.isNull(type)) {
            return AP;
        }
        return DeviceType.fromString(type);
    }

    public boolean equalsType(String type) {
        return Objects.equals(this.type, type);
    }

    public String toString() {
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public String getAlias() {
        return this.alias;
    }

    static {
        typeMap = new HashMap<String, DeviceType>(8);
        for (DeviceType type : DeviceType.values()) {
            typeMap.put(type.getType(), type);
        }
    }
}

