/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;

public class DeviceInformMessage {
    EcspMessage ecspMessage;
    private AddressDTO addressDTO;
    private boolean isFirstInform;

    public static DeviceInformMessageBuilder builder() {
        return new DeviceInformMessageBuilder();
    }

    public DeviceInformMessageBuilder toBuilder() {
        return new DeviceInformMessageBuilder().ecspMessage(this.ecspMessage).addressDTO(this.addressDTO).isFirstInform(this.isFirstInform);
    }

    public EcspMessage getEcspMessage() {
        return this.ecspMessage;
    }

    public AddressDTO getAddressDTO() {
        return this.addressDTO;
    }

    public boolean isFirstInform() {
        return this.isFirstInform;
    }

    public String toString() {
        return "DeviceInformMessage(ecspMessage=" + this.getEcspMessage() + ", addressDTO=" + this.getAddressDTO() + ", isFirstInform=" + this.isFirstInform() + ")";
    }

    public DeviceInformMessage() {
    }

    public DeviceInformMessage(EcspMessage ecspMessage, AddressDTO addressDTO, boolean isFirstInform) {
        this.ecspMessage = ecspMessage;
        this.addressDTO = addressDTO;
        this.isFirstInform = isFirstInform;
    }

    public static class DeviceInformMessageBuilder {
        private EcspMessage ecspMessage;
        private AddressDTO addressDTO;
        private boolean isFirstInform;

        DeviceInformMessageBuilder() {
        }

        public DeviceInformMessageBuilder ecspMessage(EcspMessage ecspMessage) {
            this.ecspMessage = ecspMessage;
            return this;
        }

        public DeviceInformMessageBuilder addressDTO(AddressDTO addressDTO) {
            this.addressDTO = addressDTO;
            return this;
        }

        public DeviceInformMessageBuilder isFirstInform(boolean isFirstInform) {
            this.isFirstInform = isFirstInform;
            return this;
        }

        public DeviceInformMessage build() {
            return new DeviceInformMessage(this.ecspMessage, this.addressDTO, this.isFirstInform);
        }

        public String toString() {
            return "DeviceInformMessage.DeviceInformMessageBuilder(ecspMessage=" + this.ecspMessage + ", addressDTO=" + this.addressDTO + ", isFirstInform=" + this.isFirstInform + ")";
        }
    }
}

