/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import java.net.InetSocketAddress;

public class DeviceInfo {
    private String mac;
    private DeviceType deviceType;
    private DeviceNetStatus netStatus;
    private InetSocketAddress address;
    private InetSocketAddress serverAddress;
    private long updateTime;

    public static DeviceInfoBuilder builder() {
        return new DeviceInfoBuilder();
    }

    public DeviceInfoBuilder toBuilder() {
        return new DeviceInfoBuilder().mac(this.mac).deviceType(this.deviceType).netStatus(this.netStatus).address(this.address).serverAddress(this.serverAddress).updateTime(this.updateTime);
    }

    public String getMac() {
        return this.mac;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public DeviceNetStatus getNetStatus() {
        return this.netStatus;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String toString() {
        return "DeviceInfo(mac=" + this.getMac() + ", deviceType=" + this.getDeviceType() + ", netStatus=" + this.getNetStatus() + ", address=" + this.getAddress() + ", serverAddress=" + this.getServerAddress() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    public DeviceInfo() {
    }

    public DeviceInfo(String mac, DeviceType deviceType, DeviceNetStatus netStatus, InetSocketAddress address, InetSocketAddress serverAddress, long updateTime) {
        this.mac = mac;
        this.deviceType = deviceType;
        this.netStatus = netStatus;
        this.address = address;
        this.serverAddress = serverAddress;
        this.updateTime = updateTime;
    }

    public static class DeviceInfoBuilder {
        private String mac;
        private DeviceType deviceType;
        private DeviceNetStatus netStatus;
        private InetSocketAddress address;
        private InetSocketAddress serverAddress;
        private long updateTime;

        DeviceInfoBuilder() {
        }

        public DeviceInfoBuilder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public DeviceInfoBuilder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DeviceInfoBuilder netStatus(DeviceNetStatus netStatus) {
            this.netStatus = netStatus;
            return this;
        }

        public DeviceInfoBuilder address(InetSocketAddress address) {
            this.address = address;
            return this;
        }

        public DeviceInfoBuilder serverAddress(InetSocketAddress serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public DeviceInfoBuilder updateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this.mac, this.deviceType, this.netStatus, this.address, this.serverAddress, this.updateTime);
        }

        public String toString() {
            return "DeviceInfo.DeviceInfoBuilder(mac=" + this.mac + ", deviceType=" + this.deviceType + ", netStatus=" + this.netStatus + ", address=" + this.address + ", serverAddress=" + this.serverAddress + ", updateTime=" + this.updateTime + ")";
        }
    }
}

