/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum CipherType {
    SHA256(4, "SHA-256"),
    MD5(5, "MD5");

    private final int code;
    private final String algorithmName;
    private static final Map<Integer, CipherType> CODE_MAP;

    private CipherType(int code, String algorithmName) {
        this.code = code;
        this.algorithmName = algorithmName;
    }

    public static CipherType fromCode(Integer code) {
        if (Objects.isNull(code)) {
            return MD5;
        }
        return CODE_MAP.get(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public static Map<Integer, CipherType> getAllAlgorithms() {
        return CODE_MAP;
    }

    static {
        HashMap<Integer, CipherType> map = new HashMap<Integer, CipherType>();
        for (CipherType type : CipherType.values()) {
            map.put(type.code, type);
        }
        CODE_MAP = Collections.unmodifiableMap(map);
    }
}

