/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.dmp.proto2.compress;

import com.google.protobuf.ByteString;
import com.tplink.smb.dmp.proto2.compress.CompressException;
import com.tplink.smb.dmp.proto2.compress.Compression;
import com.tplink.smb.dmp.proto2.compress.DecompressException;
import com.tplink.smb.ecsp.common.util.LzoUtils;
import java.io.IOException;

public class LzoCompression
implements Compression {
    private static final LzoCompression INSTANCE = new LzoCompression();

    private LzoCompression() {
    }

    public static LzoCompression getInstance() {
        return INSTANCE;
    }

    @Override
    public ByteString compress(ByteString data) {
        try {
            return LzoUtils.compress(data);
        }
        catch (IOException e) {
            throw new CompressException("Failed to compress data", e);
        }
    }

    @Override
    public ByteString decompress(ByteString in) throws DecompressException {
        try {
            return LzoUtils.decompress(in);
        }
        catch (IOException e) {
            throw new DecompressException("Failed to decompress data", e);
        }
    }
}

