/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.dmp.proto2;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.tplink.smb.dmp.proto2.ContentType;
import com.tplink.smb.dmp.proto2.compress.CompressUtils;
import com.tplink.smb.dmp.proto2.compress.Compression;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.omada.proto.device.monitor.ComponentDTO;
import com.tplink.smb.omada.proto.device.monitor.ComponentListDTO;
import com.tplink.smb.omada.proto.device.monitor.MonitorMessageDTO;
import com.tplink.smb.omada.proto.device.monitor.MonitorMessageHeaderDTO;
import com.tplink.smb.omada.proto.device.monitor.MsgTypeEnum;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public record Proto2MonitorMessage(@Nonnull MonitorMessageHeaderDTO header, @Nonnull ImmutableMap<Integer, ComponentDTO> componentMap) implements Message
{
    @Override
    public ByteBuffer pack() {
        ByteString originData;
        ContentType contentType = ContentType.resolve(this.header.getContentType(), () -> new ContentType(null, "protobuf2"));
        if (this.header.getMsgType() == MsgTypeEnum.MSG_COMPONENT_LIST || this.componentMap.size() > 1) {
            ComponentListDTO.Builder ComponentListDTOBuilder = ComponentListDTO.newBuilder();
            this.componentMap.forEach((k, v) -> ComponentListDTOBuilder.addComponents(v));
            originData = ComponentListDTOBuilder.build().toByteString();
        } else {
            originData = ByteString.EMPTY;
        }
        if (contentType.isCompressed()) {
            String compressMethod = contentType.compressMethod();
            Compression compression = (Compression)CompressUtils.COMPRESS_MAP.get((Object)compressMethod);
            if (compression == null) {
                throw new IllegalArgumentException("Unknown compression method: " + compressMethod);
            }
            ByteString compressed = compression.compress(originData);
            return MonitorMessageDTO.newBuilder().setHeader(this.header).setData(compressed).build().toByteString().asReadOnlyByteBuffer();
        }
        return MonitorMessageDTO.newBuilder().setHeader(this.header).setData(originData).build().toByteString().asReadOnlyByteBuffer();
    }
}

