/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.dmp.proto2;

import com.tplink.smb.ecsp.common.util.StringUtils;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record ContentType(@Nullable String compressMethod, @Nonnull String messageCodec) {
    public static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("(?<d>plain|compressed)(/(?<cp>[\\w-_.]+))?/(?<cd>[\\w-_.]+)");

    @Nonnull
    public static ContentType resolve(@Nullable String contentType, @Nonnull Supplier<ContentType> defaultSupplier) {
        if (StringUtils.isNull(contentType)) {
            return defaultSupplier.get();
        }
        Matcher matcher = CONTENT_TYPE_PATTERN.matcher(contentType);
        if (matcher.matches()) {
            return new ContentType(matcher.group("cp"), matcher.group("cd"));
        }
        throw new IllegalArgumentException("Illegal content type: " + contentType);
    }

    public boolean isCompressed() {
        return this.compressMethod != null;
    }
}

