/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.device;

import com.tplink.smb.omada.manager.port.mongo.device.configsync.UnSupportDispositionInfoDataPO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ComponentInfoPO {
    private Map<String, Integer> realComponents;
    private Map<String, ComponentVersionInfoPO> realComponentsV2;
    private Map<String, List<Integer>> notSupportComponents;
    private Map<String, ComponentCapInfoPO> componentCapInfo;
    private Integer version;

    public boolean isSupportByComponentVer(String componentName, int targetVer, int targetFunctionVer) {
        return this.getComponentVersionInfo(componentName).map(ver -> ver.getVersion() >= targetVer && ver.getFunctionVersion() >= targetFunctionVer).orElse(false);
    }

    public Optional<ComponentVersionInfoPO> getComponentVersionInfo(String componentName) {
        switch (this.version) {
            case 1: {
                if (Objects.isNull(this.realComponents)) {
                    return Optional.empty();
                }
                return Optional.ofNullable(this.realComponents.get(componentName)).map(ver -> new ComponentVersionInfoPO((Integer)ver, 0));
            }
            case 2: {
                if (Objects.isNull(this.realComponentsV2)) {
                    return Optional.empty();
                }
                return Optional.ofNullable(this.realComponentsV2.get(componentName));
            }
        }
        return Optional.empty();
    }

    @Generated
    public Map<String, Integer> getRealComponents() {
        return this.realComponents;
    }

    @Generated
    public Map<String, ComponentVersionInfoPO> getRealComponentsV2() {
        return this.realComponentsV2;
    }

    @Generated
    public Map<String, List<Integer>> getNotSupportComponents() {
        return this.notSupportComponents;
    }

    @Generated
    public Map<String, ComponentCapInfoPO> getComponentCapInfo() {
        return this.componentCapInfo;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public void setRealComponents(Map<String, Integer> realComponents) {
        this.realComponents = realComponents;
    }

    @Generated
    public void setRealComponentsV2(Map<String, ComponentVersionInfoPO> realComponentsV2) {
        this.realComponentsV2 = realComponentsV2;
    }

    @Generated
    public void setNotSupportComponents(Map<String, List<Integer>> notSupportComponents) {
        this.notSupportComponents = notSupportComponents;
    }

    @Generated
    public void setComponentCapInfo(Map<String, ComponentCapInfoPO> componentCapInfo) {
        this.componentCapInfo = componentCapInfo;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public ComponentInfoPO() {
    }

    @Generated
    public ComponentInfoPO(Map<String, Integer> realComponents, Map<String, ComponentVersionInfoPO> realComponentsV2, Map<String, List<Integer>> notSupportComponents, Map<String, ComponentCapInfoPO> componentCapInfo, Integer version) {
        this.realComponents = realComponents;
        this.realComponentsV2 = realComponentsV2;
        this.notSupportComponents = notSupportComponents;
        this.componentCapInfo = componentCapInfo;
        this.version = version;
    }

    public static class ComponentVersionInfoPO {
        private Integer version;
        private Integer functionVersion;

        public static ComponentVersionInfoPO buildErrorComponent() {
            return new ComponentVersionInfoPO(-1, -1);
        }

        public boolean isError() {
            return this.version == -1 || this.functionVersion == -1;
        }

        @Generated
        public Integer getVersion() {
            return this.version;
        }

        @Generated
        public Integer getFunctionVersion() {
            return this.functionVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentVersionInfoPO)) {
                return false;
            }
            ComponentVersionInfoPO other = (ComponentVersionInfoPO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Integer this$functionVersion = this.getFunctionVersion();
            Integer other$functionVersion = other.getFunctionVersion();
            return !(this$functionVersion == null ? other$functionVersion != null : !((Object)this$functionVersion).equals(other$functionVersion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComponentVersionInfoPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Integer $functionVersion = this.getFunctionVersion();
            result = result * 59 + ($functionVersion == null ? 43 : ((Object)$functionVersion).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentInfoPO.ComponentVersionInfoPO(version=" + this.getVersion() + ", functionVersion=" + this.getFunctionVersion() + ")";
        }

        @Generated
        public ComponentVersionInfoPO(Integer version, Integer functionVersion) {
            this.version = version;
            this.functionVersion = functionVersion;
        }

        @Generated
        public ComponentVersionInfoPO() {
        }
    }

    public static class ComponentCapInfoPO {
        private List<String> unsupportCaps;
        private Integer entryLimit;
        private List<UnSupportDispositionInfoDataPO> unsupportCapKeys;

        @Generated
        public List<String> getUnsupportCaps() {
            return this.unsupportCaps;
        }

        @Generated
        public Integer getEntryLimit() {
            return this.entryLimit;
        }

        @Generated
        public List<UnSupportDispositionInfoDataPO> getUnsupportCapKeys() {
            return this.unsupportCapKeys;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentCapInfoPO)) {
                return false;
            }
            ComponentCapInfoPO other = (ComponentCapInfoPO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$entryLimit = this.getEntryLimit();
            Integer other$entryLimit = other.getEntryLimit();
            if (this$entryLimit == null ? other$entryLimit != null : !((Object)this$entryLimit).equals(other$entryLimit)) {
                return false;
            }
            List<String> this$unsupportCaps = this.getUnsupportCaps();
            List<String> other$unsupportCaps = other.getUnsupportCaps();
            if (this$unsupportCaps == null ? other$unsupportCaps != null : !((Object)this$unsupportCaps).equals(other$unsupportCaps)) {
                return false;
            }
            List<UnSupportDispositionInfoDataPO> this$unsupportCapKeys = this.getUnsupportCapKeys();
            List<UnSupportDispositionInfoDataPO> other$unsupportCapKeys = other.getUnsupportCapKeys();
            return !(this$unsupportCapKeys == null ? other$unsupportCapKeys != null : !((Object)this$unsupportCapKeys).equals(other$unsupportCapKeys));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComponentCapInfoPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $entryLimit = this.getEntryLimit();
            result = result * 59 + ($entryLimit == null ? 43 : ((Object)$entryLimit).hashCode());
            List<String> $unsupportCaps = this.getUnsupportCaps();
            result = result * 59 + ($unsupportCaps == null ? 43 : ((Object)$unsupportCaps).hashCode());
            List<UnSupportDispositionInfoDataPO> $unsupportCapKeys = this.getUnsupportCapKeys();
            result = result * 59 + ($unsupportCapKeys == null ? 43 : ((Object)$unsupportCapKeys).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentInfoPO.ComponentCapInfoPO(unsupportCaps=" + this.getUnsupportCaps() + ", entryLimit=" + this.getEntryLimit() + ", unsupportCapKeys=" + this.getUnsupportCapKeys() + ")";
        }

        @Generated
        public ComponentCapInfoPO(List<String> unsupportCaps, Integer entryLimit, List<UnSupportDispositionInfoDataPO> unsupportCapKeys) {
            this.unsupportCaps = unsupportCaps;
            this.entryLimit = entryLimit;
            this.unsupportCapKeys = unsupportCapKeys;
        }

        @Generated
        public ComponentCapInfoPO() {
        }
    }
}

