/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.configuration.version;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.Sharded;
import org.springframework.data.mongodb.core.mapping.ShardingStrategy;

@Document(collection="configversion")
@Sharded(shardKey={"omadac_id", "mac"}, shardingStrategy=ShardingStrategy.HASH, immutableKey=true)
public class ConfigVersionPO {
    @Id
    private String id;
    @Field(value="omadac_id")
    private String omadacId;
    @Indexed
    @Field(value="mac")
    private String mac;
    private Integer current;
    @Version
    Long version;
    @Field(value="inc_config_flags")
    private Map<String, List<String>> incConfigFlags;

    public void addIncConfigFlag(String incConfigFlagName, String version) {
        if (this.incConfigFlags == null) {
            this.incConfigFlags = new HashMap<String, List<String>>();
        }
        this.incConfigFlags.computeIfAbsent(incConfigFlagName, k2 -> new ArrayList()).add(version);
    }

    public ConfigVersionPO(String omadacId, String mac, int current) {
        this.omadacId = omadacId;
        this.mac = mac;
        this.current = current;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Integer getCurrent() {
        return this.current;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, List<String>> getIncConfigFlags() {
        return this.incConfigFlags;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setCurrent(Integer current) {
        this.current = current;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setIncConfigFlags(Map<String, List<String>> incConfigFlags) {
        this.incConfigFlags = incConfigFlags;
    }

    @Generated
    public String toString() {
        return "ConfigVersionPO(id=" + this.getId() + ", omadacId=" + this.getOmadacId() + ", mac=" + this.getMac() + ", current=" + this.getCurrent() + ", version=" + this.getVersion() + ", incConfigFlags=" + this.getIncConfigFlags() + ")";
    }

    @Generated
    public ConfigVersionPO(String id, String omadacId, String mac, Integer current, Long version, Map<String, List<String>> incConfigFlags) {
        this.id = id;
        this.omadacId = omadacId;
        this.mac = mac;
        this.current = current;
        this.version = version;
        this.incConfigFlags = incConfigFlags;
    }

    @Generated
    public ConfigVersionPO() {
    }
}

