/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork;

import com.tplink.smb.omada.common.e.h;
import com.tplink.smb.omada.common.h.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.Sharded;
import org.springframework.data.mongodb.core.mapping.ShardingStrategy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

@Document(collection="lannetwork")
@Sharded(shardKey={"omadac_id", "site_id"}, shardingStrategy=ShardingStrategy.HASH, immutableKey=true)
public class LanNetworkPO
extends BaseLanNetworkPO
implements h {
    @Indexed
    @Field(value="site_id")
    private String siteId;
    @Field(value="entry_id")
    private Integer entryId;
    @Field(value="template_id")
    private String templateId;
    @Field(value="override")
    private Boolean override;
    private static final long TIMEOUT_PERIOD = TimeUnit.MILLISECONDS.toNanos(15000L);

    public Set<Integer> getAvailableNums(String omadacId, String siteId, Object template, h po) {
        MongoTemplate mongoTemplate = (MongoTemplate)template;
        long startTime = System.nanoTime();
        boolean timeout = false;
        LanNetworkPO newLanNetworkPO = (LanNetworkPO)po;
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId));
        List lanNetworkPOS = mongoTemplate.find(query, LanNetworkPO.class);
        HashSet<Integer> dbEntryIds = new HashSet<Integer>(lanNetworkPOS.size());
        lanNetworkPOS.forEach(lanNetworkPO -> {
            if (CollectionUtils.isEmpty(lanNetworkPO.getVlanEntryIdMap())) {
                return;
            }
            dbEntryIds.addAll(lanNetworkPO.getVlanEntryIdMap().values());
        });
        dbEntryIds.add(newLanNetworkPO.getEntryId());
        int size = newLanNetworkPO.getVlanList().size();
        HashSet<Integer> preEntryIds = new HashSet<Integer>(size);
        while (!timeout && preEntryIds.size() < size) {
            Integer preEntryId = (int)(Math.random() * 2.147483647E9 + 1.0);
            if (preEntryIds.contains(preEntryId)) continue;
            timeout = this.isTimeout(startTime, TIMEOUT_PERIOD);
            if (dbEntryIds.contains(preEntryId)) continue;
            preEntryIds.add(preEntryId);
        }
        if (timeout) {
            throw new c("Failed to getAvailableNum, site:" + siteId + " class:" + this.getClass());
        }
        return preEntryIds;
    }

    private boolean isTimeout(long pastTimeNs, long timeoutNs) {
        long timeTemp = System.nanoTime() - pastTimeNs;
        return Math.abs(timeTemp) >= timeoutNs;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Integer getEntryId() {
        return this.entryId;
    }

    @Generated
    public String getTemplateId() {
        return this.templateId;
    }

    @Generated
    public Boolean getOverride() {
        return this.override;
    }

    @Generated
    public LanNetworkPO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public LanNetworkPO setEntryId(Integer entryId) {
        this.entryId = entryId;
        return this;
    }

    @Generated
    public LanNetworkPO setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @Generated
    public LanNetworkPO setOverride(Boolean override) {
        this.override = override;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "LanNetworkPO(super=" + super.toString() + ", siteId=" + this.getSiteId() + ", entryId=" + this.getEntryId() + ", templateId=" + this.getTemplateId() + ", override=" + this.getOverride() + ")";
    }

    @Generated
    public LanNetworkPO() {
    }
}

