/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.internal.dto.audit;

import com.tplink.smb.omada.common.auditlog.BuildAuditLogParamsDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditLogDTO.class);
    private String mspId;
    private String omadacId;
    private String siteId;
    private String auditLogKey;
    private String operator;
    private Integer resource;
    private String ip;
    private Long time;
    private Integer resultCode;
    private String label;
    private String oldValue;
    private String newValue;
    private String[] params;
    private Integer settingType;
    private Map<String, String> clientParamMap;

    public static AuditLogDTO buildAuditLogDTO(String omadacId, String siteId, String auditLogKey, String operator, Integer resource, String ip, Long time, Integer resultCode, String ... params) {
        AuditLogDTO auditLogDTO = AuditLogDTO.builder().omadacId(omadacId).auditLogKey(auditLogKey).operator(operator).resource(resource).ip(ip).time(time).resultCode(resultCode).params(params).build();
        if (Objects.isNull(siteId)) {
            return auditLogDTO;
        }
        auditLogDTO.setSiteId(siteId);
        return auditLogDTO;
    }

    public static AuditLogDTO buildAuditLogDTO(String omadacId, String siteId, String auditLogKey, String operator, Integer resource, String ip, Long time, BuildAuditLogParamsDTO buildAuditLogParamsDTO) {
        AuditLogDTO auditLogDTO = AuditLogDTO.builder().omadacId(omadacId).auditLogKey(auditLogKey).operator(operator).resource(resource).ip(ip).time(time).label(buildAuditLogParamsDTO.getLabel()).resultCode(buildAuditLogParamsDTO.getResCode()).oldValue(buildAuditLogParamsDTO.getOldValue()).newValue(buildAuditLogParamsDTO.getNewValue()).params(buildAuditLogParamsDTO.getParams().toArray(new String[0])).settingType(buildAuditLogParamsDTO.getSettingType()).clientParamMap(buildAuditLogParamsDTO.getClientParamMap()).build();
        if (Objects.isNull(siteId)) {
            return auditLogDTO;
        }
        auditLogDTO.setSiteId(siteId);
        return auditLogDTO;
    }

    public static AuditLogDTO buildMspAuditLogDTO(String mspId, String auditLogKey, String operator, Integer resource, String ip, Long time, Integer resultCode, String ... params) {
        return AuditLogDTO.builder().mspId(mspId).auditLogKey(auditLogKey).operator(operator).resource(resource).ip(ip).time(time).resultCode(resultCode).params(params).build();
    }

    public static AuditLogDTO buildMspAuditLogDTO(String mspId, String auditLogKey, String operator, Integer resource, String ip, Long time, BuildAuditLogParamsDTO buildAuditLogParamsDTO) {
        return AuditLogDTO.builder().mspId(mspId).auditLogKey(auditLogKey).operator(operator).resource(resource).ip(ip).time(time).label(buildAuditLogParamsDTO.getLabel()).resultCode(buildAuditLogParamsDTO.getResCode()).oldValue(buildAuditLogParamsDTO.getOldValue()).newValue(buildAuditLogParamsDTO.getNewValue()).params(buildAuditLogParamsDTO.getParams().toArray(new String[0])).settingType(buildAuditLogParamsDTO.getSettingType()).build();
    }

    public String toJson() {
        return x.a((Object)this);
    }

    public Optional<Boolean> isRoot() {
        if (T.a((String)this.omadacId) && T.a((String)this.siteId)) {
            log.warn("Invalid parameters for audit log,omadacId:{},siteId:{}", (Object)this.omadacId, (Object)this.siteId);
            return Optional.empty();
        }
        if (T.a((String)this.siteId)) {
            return Optional.ofNullable(Boolean.TRUE);
        }
        return Optional.ofNullable(Boolean.FALSE);
    }

    public Boolean check() {
        if (Objects.isNull(this.time) || T.a((String)this.operator) || Objects.isNull(this.resource) || T.a((String)this.ip) || Objects.isNull(this.resultCode)) {
            log.warn("Illegal Audit Log DTO :{}", (Object)this.toString());
            return false;
        }
        return true;
    }

    public Boolean mspCheck() {
        if (T.a((String)this.mspId) || Objects.isNull(this.time) || T.a((String)this.operator) || Objects.isNull(this.resource) || T.a((String)this.ip) || Objects.isNull(this.resultCode)) {
            log.warn("Illegal Msp Audit Log DTO :{}", (Object)this.toString());
            return false;
        }
        return true;
    }

    @Generated
    public static AuditLogDTOBuilder builder() {
        return new AuditLogDTOBuilder();
    }

    @Generated
    public void setMspId(String mspId) {
        this.mspId = mspId;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setAuditLogKey(String auditLogKey) {
        this.auditLogKey = auditLogKey;
    }

    @Generated
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @Generated
    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Generated
    public void setParams(String[] params) {
        this.params = params;
    }

    @Generated
    public void setSettingType(Integer settingType) {
        this.settingType = settingType;
    }

    @Generated
    public void setClientParamMap(Map<String, String> clientParamMap) {
        this.clientParamMap = clientParamMap;
    }

    @Generated
    public String getMspId() {
        return this.mspId;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getAuditLogKey() {
        return this.auditLogKey;
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Integer getResultCode() {
        return this.resultCode;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getOldValue() {
        return this.oldValue;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Generated
    public String[] getParams() {
        return this.params;
    }

    @Generated
    public Integer getSettingType() {
        return this.settingType;
    }

    @Generated
    public Map<String, String> getClientParamMap() {
        return this.clientParamMap;
    }

    @Generated
    public AuditLogDTO() {
    }

    @Generated
    public AuditLogDTO(String mspId, String omadacId, String siteId, String auditLogKey, String operator, Integer resource, String ip, Long time, Integer resultCode, String label, String oldValue, String newValue, String[] params, Integer settingType, Map<String, String> clientParamMap) {
        this.mspId = mspId;
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.auditLogKey = auditLogKey;
        this.operator = operator;
        this.resource = resource;
        this.ip = ip;
        this.time = time;
        this.resultCode = resultCode;
        this.label = label;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.params = params;
        this.settingType = settingType;
        this.clientParamMap = clientParamMap;
    }

    @Generated
    public String toString() {
        return "AuditLogDTO(mspId=" + this.getMspId() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", auditLogKey=" + this.getAuditLogKey() + ", operator=" + this.getOperator() + ", resource=" + this.getResource() + ", ip=" + this.getIp() + ", time=" + this.getTime() + ", resultCode=" + this.getResultCode() + ", label=" + this.getLabel() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", params=" + Arrays.deepToString(this.getParams()) + ", settingType=" + this.getSettingType() + ", clientParamMap=" + this.getClientParamMap() + ")";
    }

    @Generated
    public static class AuditLogDTOBuilder {
        @Generated
        private String mspId;
        @Generated
        private String omadacId;
        @Generated
        private String siteId;
        @Generated
        private String auditLogKey;
        @Generated
        private String operator;
        @Generated
        private Integer resource;
        @Generated
        private String ip;
        @Generated
        private Long time;
        @Generated
        private Integer resultCode;
        @Generated
        private String label;
        @Generated
        private String oldValue;
        @Generated
        private String newValue;
        @Generated
        private String[] params;
        @Generated
        private Integer settingType;
        @Generated
        private Map<String, String> clientParamMap;

        @Generated
        AuditLogDTOBuilder() {
        }

        @Generated
        public AuditLogDTOBuilder mspId(String mspId) {
            this.mspId = mspId;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder auditLogKey(String auditLogKey) {
            this.auditLogKey = auditLogKey;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder time(Long time) {
            this.time = time;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder resultCode(Integer resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder label(String label) {
            this.label = label;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder oldValue(String oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder params(String[] params) {
            this.params = params;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder settingType(Integer settingType) {
            this.settingType = settingType;
            return this;
        }

        @Generated
        public AuditLogDTOBuilder clientParamMap(Map<String, String> clientParamMap) {
            this.clientParamMap = clientParamMap;
            return this;
        }

        @Generated
        public AuditLogDTO build() {
            return new AuditLogDTO(this.mspId, this.omadacId, this.siteId, this.auditLogKey, this.operator, this.resource, this.ip, this.time, this.resultCode, this.label, this.oldValue, this.newValue, this.params, this.settingType, this.clientParamMap);
        }

        @Generated
        public String toString() {
            return "AuditLogDTO.AuditLogDTOBuilder(mspId=" + this.mspId + ", omadacId=" + this.omadacId + ", siteId=" + this.siteId + ", auditLogKey=" + this.auditLogKey + ", operator=" + this.operator + ", resource=" + this.resource + ", ip=" + this.ip + ", time=" + this.time + ", resultCode=" + this.resultCode + ", label=" + this.label + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", params=" + Arrays.deepToString(this.params) + ", settingType=" + this.settingType + ", clientParamMap=" + this.clientParamMap + ")";
        }
    }
}

