/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.internal.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.a;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OmadaLogDTO {
    private String mspId;
    private String omadacId;
    private String siteId;
    @com.tplink.smb.omada.a.a
    private String deviceMac;
    private String omadaLogKey;
    private String module;
    private String[] params;
    private Map<String, String> paramMap;
    private Date time;
    private String content;
    private DeviceTypeEnum deviceType;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @com.tplink.smb.omada.a.a(b=true, c=false)
    private Map<String, String> macNameMap;
    private List<String> resolveKeys;
    private Boolean alert;
    private String alertId;
    private Boolean resolve;
    private Boolean update;
    @Nullable
    private String deviceModel;
    @Nullable
    private String deviceModelVersion;
    private String clientType;
    private Boolean clientManager;
    private Map<String, String> clientParamMap;

    private OmadaLogDTO(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String[] params, Date time, String content, Map<String, String> macNameMap, DeviceTypeEnum deviceType) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.params = params;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
    }

    private OmadaLogDTO(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String[] params, Date time, String content, Map<String, String> macNameMap, Map<String, String> clientParamMap, DeviceTypeEnum deviceType) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.params = params;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
        this.clientParamMap = clientParamMap;
    }

    private OmadaLogDTO(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String[] params, Date time, String content, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String clientType, Boolean clientManager, Map<String, String> clientParamMap) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.params = params;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
        this.clientType = clientType;
        this.clientManager = clientManager;
        this.clientParamMap = clientParamMap;
    }

    private OmadaLogDTO(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> paramMap, Date time, String content, Map<String, String> macNameMap, DeviceTypeEnum deviceType) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.paramMap = paramMap;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
    }

    private OmadaLogDTO(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> paramMap, Date time, String content, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String clientType, Boolean clientManager, Map<String, String> clientParamMap) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.paramMap = paramMap;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
        this.clientType = clientType;
        this.clientManager = clientManager;
        this.clientParamMap = clientParamMap;
    }

    private OmadaLogDTO(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String[] params, Date time, String content, Map<String, String> macNameMap, DeviceTypeEnum deviceType, List<String> resolveKeys) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.params = params;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
        this.resolveKeys = resolveKeys;
    }

    private OmadaLogDTO(String omadacId, String siteId, String mac, DeviceTypeEnum deviceType, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, String content, List<String> resolveKeys) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.deviceMac = mac;
        this.omadaLogKey = omadaLogKeyEnumDTO.name();
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime());
        this.content = content;
        this.deviceType = deviceType;
        this.resolveKeys = resolveKeys;
    }

    public static LogDTO buildDeviceLog(String omadacId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, null, omadaLogKeyEnumDTO, params, time, null, macNameMap, deviceType);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildDeviceLog(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, time, null, macNameMap, deviceType);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildDeviceLogWithCondition(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, DeviceTypeEnum deviceType, Boolean alert, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, time, null, macNameMap, deviceType);
        omadaLog.setAlert(alert);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildClientLog(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, String clientType, Boolean clientManager, DeviceTypeEnum deviceType, Map<String, String> clientParamMap, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, time, null, macNameMap, deviceType, clientType, clientManager, clientParamMap);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildDeviceLog(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, DeviceTypeEnum deviceType, Map<String, String> paramMap) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, paramMap, time, null, macNameMap, deviceType);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildClientLog(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String clientType, Boolean clientManager, Map<String, String> clientParamMap, Map<String, String> paramMap) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, paramMap, time, null, macNameMap, deviceType, clientType, clientManager, clientParamMap);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildDeviceAlertResolveLog(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, Map<String, String> macNameMap, DeviceTypeEnum deviceType, List<String> resolveKeys, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, time, "ALERT_RESOLVE", macNameMap, deviceType, resolveKeys);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, null, omadaLogKeyEnumDTO, params, time, null, null, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, null, omadaLogKeyEnumDTO, params, null, null, null, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildDeviceResolveLog(String omadacId, String siteId, String mac, DeviceTypeEnum deviceType, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, List<String> resolveKeys) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, mac, deviceType, omadaLogKeyEnumDTO, Calendar.getInstance().getTime(), "ALERT_RESOLVE", resolveKeys);
        if (!omadaLog.validateDeviceResolveLog()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildResolveLog(String omadacId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, List<String> resolveKeys, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, null, omadaLogKeyEnumDTO, params, Calendar.getInstance().getTime(), "ALERT_RESOLVE", null, null, resolveKeys);
        if (!omadaLog.validateResolveLog()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildResolveLog(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, List<String> resolveKeys, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, Calendar.getInstance().getTime(), "ALERT_RESOLVE", null, null, resolveKeys);
        if (!omadaLog.validateResolveLog()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildMspLogWithContent(String mspId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String content) {
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().mspId(mspId)).omadaLogKey(omadaLogKeyEnumDTO.name())).time(Calendar.getInstance().getTime())).content(content)).build()).build();
    }

    public static LogDTO buildMspLogWithContentAndTime(String mspId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String content, Date date) {
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().mspId(mspId)).omadaLogKey(omadaLogKeyEnumDTO.name())).time(date)).content(content)).build()).build();
    }

    public static LogDTO buildMspLog(String mspId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String ... params) {
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().mspId(mspId)).omadaLogKey(omadaLogKeyEnumDTO.name())).time(Calendar.getInstance().getTime())).params(params)).build()).build();
    }

    public static LogDTO buildMspResolveLog(String mspId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, List<String> resolveKeys, String ... params) {
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().mspId(mspId)).omadaLogKey(omadaLogKeyEnumDTO.name())).time(Calendar.getInstance().getTime())).params(params)).resolveKeys(resolveKeys)).build()).build();
    }

    public static LogDTO buildMspDeviceLog(String mspId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String ... params) {
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().mspId(mspId)).omadaLogKey(omadaLogKeyEnumDTO.name())).time(Calendar.getInstance().getTime())).macNameMap(macNameMap)).deviceType(deviceType)).params(params)).build()).build();
    }

    public static LogDTO buildMspDeviceLogWithDeviceModel(String mspId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> macNameMap, DeviceTypeEnum deviceType, String deviceModel, String deviceModelVersion, String ... params) {
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().mspId(mspId)).omadaLogKey(omadaLogKeyEnumDTO.name())).time(Calendar.getInstance().getTime())).macNameMap(macNameMap)).deviceType(deviceType)).deviceModel(deviceModel)).deviceModelVersion(deviceModelVersion)).params(params)).build()).build();
    }

    public static LogDTO build(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, time, null, null, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, null, null, null, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, String content) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, null, omadaLogKeyEnumDTO, (String[])null, time, content, null, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Date time, String content) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, (String[])null, time, content, null, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> macNameMap, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, null, null, macNameMap, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO buildClient(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> macNameMap, Map<String, String> clientParamMap, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, null, null, macNameMap, clientParamMap, null);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(String omadacId, String siteId, OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, String clientType, Boolean clientManager, Map<String, String> macNameMap, Map<String, String> clientParamMap, String ... params) {
        OmadaLogDTO omadaLog = new OmadaLogDTO(omadacId, siteId, omadaLogKeyEnumDTO, params, null, null, macNameMap, null, clientType, clientManager, clientParamMap);
        if (!omadaLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO(omadaLog).build();
    }

    public static LogDTO build(@Nonnull String omadacId, @Nullable String siteId, @Nonnull OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> macNameMap, @Nonnull Map<String, String> paramMap) {
        Object omadaLog = ((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().omadacId(omadacId)).siteId(siteId)).omadaLogKey(omadaLogKeyEnumDTO.name())).macNameMap(macNameMap)).paramMap(paramMap)).time(Calendar.getInstance().getTime())).build();
        if (!((OmadaLogDTO)omadaLog).validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)omadaLog).build();
    }

    public static LogDTO buildClient(@Nonnull String omadacId, @Nullable String siteId, @Nonnull OmadaLogKeyEnumDTO omadaLogKeyEnumDTO, Map<String, String> macNameMap, Map<String, String> clientParamMap, @Nonnull Map<String, String> paramMap) {
        Object omadaLog = ((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)((OmadaLogDTOBuilder)OmadaLogDTO.builder().omadacId(omadacId)).siteId(siteId)).omadaLogKey(omadaLogKeyEnumDTO.name())).macNameMap(macNameMap)).paramMap(paramMap)).clientParamMap(clientParamMap)).time(Calendar.getInstance().getTime())).build();
        if (!((OmadaLogDTO)omadaLog).validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(a.a.b()).omadaLogDTO((OmadaLogDTO)omadaLog).build();
    }

    public String toJson() {
        return x.a((Object)this);
    }

    public boolean validate() {
        if (T.a((String)this.omadacId) || T.a((String)this.omadaLogKey) || this.time == null) {
            return false;
        }
        return this.params != null && this.params.length != 0 || !CollectionUtils.isEmpty(this.paramMap) || !T.a((String)this.content) || !CollectionUtils.isEmpty(this.resolveKeys);
    }

    private boolean validateDeviceResolveLog() {
        if (T.a((String)this.omadacId) || T.a((String)this.siteId) || T.a((String)this.deviceMac) || T.a((String)this.omadaLogKey) || this.time == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(this.resolveKeys);
    }

    public boolean validateResolveLog() {
        if (T.a((String)this.omadacId) || T.a((String)this.omadaLogKey) || this.time == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(this.resolveKeys);
    }

    public Boolean validateMspLog() {
        if (T.a((String)this.mspId) || T.a((String)this.omadaLogKey) || Objects.isNull(this.time)) {
            return Boolean.FALSE;
        }
        if ((Objects.isNull(this.params) || this.params.length < 1) && CollectionUtils.isEmpty(this.paramMap) && T.a((String)this.content)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean validateMspResolveLog() {
        if (T.a((String)this.mspId) || T.a((String)this.omadaLogKey) || Objects.isNull(this.time)) {
            return Boolean.FALSE;
        }
        if (CollectionUtils.isEmpty(this.resolveKeys)) {
            return false;
        }
        return Boolean.TRUE;
    }

    public boolean isGlobal() {
        return T.b((String)this.omadacId) && T.a((String)this.siteId);
    }

    public boolean isSite() {
        return T.b((String)this.siteId) && T.b((String)this.omadacId);
    }

    public boolean isMsp() {
        return !T.a((String)this.mspId);
    }

    public boolean isDeviceLog() {
        return Objects.nonNull(this.deviceType) && !T.c((String)this.deviceType.c());
    }

    @Generated
    protected OmadaLogDTO(OmadaLogDTOBuilder<?, ?> b2) {
        this.mspId = b2.mspId;
        this.omadacId = b2.omadacId;
        this.siteId = b2.siteId;
        this.deviceMac = b2.deviceMac;
        this.omadaLogKey = b2.omadaLogKey;
        this.module = b2.module;
        this.params = b2.params;
        this.paramMap = b2.paramMap;
        this.time = b2.time;
        this.content = b2.content;
        this.deviceType = b2.deviceType;
        this.macNameMap = b2.macNameMap;
        this.resolveKeys = b2.resolveKeys;
        this.alert = b2.alert;
        this.alertId = b2.alertId;
        this.resolve = b2.resolve;
        this.update = b2.update;
        this.deviceModel = b2.deviceModel;
        this.deviceModelVersion = b2.deviceModelVersion;
        this.clientType = b2.clientType;
        this.clientManager = b2.clientManager;
        this.clientParamMap = b2.clientParamMap;
    }

    @Generated
    public static OmadaLogDTOBuilder<?, ?> builder() {
        return new OmadaLogDTOBuilderImpl();
    }

    @Generated
    public void setMspId(String mspId) {
        this.mspId = mspId;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setOmadaLogKey(String omadaLogKey) {
        this.omadaLogKey = omadaLogKey;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setParams(String[] params) {
        this.params = params;
    }

    @Generated
    public void setParamMap(Map<String, String> paramMap) {
        this.paramMap = paramMap;
    }

    @Generated
    public void setTime(Date time) {
        this.time = time;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setDeviceType(DeviceTypeEnum deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setMacNameMap(Map<String, String> macNameMap) {
        this.macNameMap = macNameMap;
    }

    @Generated
    public void setResolveKeys(List<String> resolveKeys) {
        this.resolveKeys = resolveKeys;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    @Generated
    public void setResolve(Boolean resolve) {
        this.resolve = resolve;
    }

    @Generated
    public void setUpdate(Boolean update) {
        this.update = update;
    }

    @Generated
    public void setDeviceModel(@Nullable String deviceModel) {
        this.deviceModel = deviceModel;
    }

    @Generated
    public void setDeviceModelVersion(@Nullable String deviceModelVersion) {
        this.deviceModelVersion = deviceModelVersion;
    }

    @Generated
    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    @Generated
    public void setClientManager(Boolean clientManager) {
        this.clientManager = clientManager;
    }

    @Generated
    public void setClientParamMap(Map<String, String> clientParamMap) {
        this.clientParamMap = clientParamMap;
    }

    @Generated
    public String getMspId() {
        return this.mspId;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getOmadaLogKey() {
        return this.omadaLogKey;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public String[] getParams() {
        return this.params;
    }

    @Generated
    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    @Generated
    public Date getTime() {
        return this.time;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public DeviceTypeEnum getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Map<String, String> getMacNameMap() {
        return this.macNameMap;
    }

    @Generated
    public List<String> getResolveKeys() {
        return this.resolveKeys;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public String getAlertId() {
        return this.alertId;
    }

    @Generated
    public Boolean getResolve() {
        return this.resolve;
    }

    @Generated
    public Boolean getUpdate() {
        return this.update;
    }

    @Nullable
    @Generated
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Nullable
    @Generated
    public String getDeviceModelVersion() {
        return this.deviceModelVersion;
    }

    @Generated
    public String getClientType() {
        return this.clientType;
    }

    @Generated
    public Boolean getClientManager() {
        return this.clientManager;
    }

    @Generated
    public Map<String, String> getClientParamMap() {
        return this.clientParamMap;
    }

    @Generated
    public OmadaLogDTO(String mspId, String omadacId, String siteId, String deviceMac, String omadaLogKey, String module, String[] params, Map<String, String> paramMap, Date time, String content, DeviceTypeEnum deviceType, Map<String, String> macNameMap, List<String> resolveKeys, Boolean alert, String alertId, Boolean resolve, Boolean update, @Nullable String deviceModel, @Nullable String deviceModelVersion, String clientType, Boolean clientManager, Map<String, String> clientParamMap) {
        this.mspId = mspId;
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.deviceMac = deviceMac;
        this.omadaLogKey = omadaLogKey;
        this.module = module;
        this.params = params;
        this.paramMap = paramMap;
        this.time = time;
        this.content = content;
        this.deviceType = deviceType;
        this.macNameMap = macNameMap;
        this.resolveKeys = resolveKeys;
        this.alert = alert;
        this.alertId = alertId;
        this.resolve = resolve;
        this.update = update;
        this.deviceModel = deviceModel;
        this.deviceModelVersion = deviceModelVersion;
        this.clientType = clientType;
        this.clientManager = clientManager;
        this.clientParamMap = clientParamMap;
    }

    @Generated
    public OmadaLogDTO() {
    }

    @Generated
    public static abstract class OmadaLogDTOBuilder<C extends OmadaLogDTO, B extends OmadaLogDTOBuilder<C, B>> {
        @Generated
        private String mspId;
        @Generated
        private String omadacId;
        @Generated
        private String siteId;
        @Generated
        private String deviceMac;
        @Generated
        private String omadaLogKey;
        @Generated
        private String module;
        @Generated
        private String[] params;
        @Generated
        private Map<String, String> paramMap;
        @Generated
        private Date time;
        @Generated
        private String content;
        @Generated
        private DeviceTypeEnum deviceType;
        @Generated
        private Map<String, String> macNameMap;
        @Generated
        private List<String> resolveKeys;
        @Generated
        private Boolean alert;
        @Generated
        private String alertId;
        @Generated
        private Boolean resolve;
        @Generated
        private Boolean update;
        @Generated
        private String deviceModel;
        @Generated
        private String deviceModelVersion;
        @Generated
        private String clientType;
        @Generated
        private Boolean clientManager;
        @Generated
        private Map<String, String> clientParamMap;

        @Generated
        public B mspId(String mspId) {
            this.mspId = mspId;
            return this.self();
        }

        @Generated
        public B omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this.self();
        }

        @Generated
        public B siteId(String siteId) {
            this.siteId = siteId;
            return this.self();
        }

        @Generated
        public B deviceMac(String deviceMac) {
            this.deviceMac = deviceMac;
            return this.self();
        }

        @Generated
        public B omadaLogKey(String omadaLogKey) {
            this.omadaLogKey = omadaLogKey;
            return this.self();
        }

        @Generated
        public B module(String module) {
            this.module = module;
            return this.self();
        }

        @Generated
        public B params(String[] params) {
            this.params = params;
            return this.self();
        }

        @Generated
        public B paramMap(Map<String, String> paramMap) {
            this.paramMap = paramMap;
            return this.self();
        }

        @Generated
        public B time(Date time) {
            this.time = time;
            return this.self();
        }

        @Generated
        public B content(String content) {
            this.content = content;
            return this.self();
        }

        @Generated
        public B deviceType(DeviceTypeEnum deviceType) {
            this.deviceType = deviceType;
            return this.self();
        }

        @Generated
        public B macNameMap(Map<String, String> macNameMap) {
            this.macNameMap = macNameMap;
            return this.self();
        }

        @Generated
        public B resolveKeys(List<String> resolveKeys) {
            this.resolveKeys = resolveKeys;
            return this.self();
        }

        @Generated
        public B alert(Boolean alert) {
            this.alert = alert;
            return this.self();
        }

        @Generated
        public B alertId(String alertId) {
            this.alertId = alertId;
            return this.self();
        }

        @Generated
        public B resolve(Boolean resolve) {
            this.resolve = resolve;
            return this.self();
        }

        @Generated
        public B update(Boolean update) {
            this.update = update;
            return this.self();
        }

        @Generated
        public B deviceModel(@Nullable String deviceModel) {
            this.deviceModel = deviceModel;
            return this.self();
        }

        @Generated
        public B deviceModelVersion(@Nullable String deviceModelVersion) {
            this.deviceModelVersion = deviceModelVersion;
            return this.self();
        }

        @Generated
        public B clientType(String clientType) {
            this.clientType = clientType;
            return this.self();
        }

        @Generated
        public B clientManager(Boolean clientManager) {
            this.clientManager = clientManager;
            return this.self();
        }

        @Generated
        public B clientParamMap(Map<String, String> clientParamMap) {
            this.clientParamMap = clientParamMap;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OmadaLogDTO.OmadaLogDTOBuilder(mspId=" + this.mspId + ", omadacId=" + this.omadacId + ", siteId=" + this.siteId + ", deviceMac=" + this.deviceMac + ", omadaLogKey=" + this.omadaLogKey + ", module=" + this.module + ", params=" + Arrays.deepToString(this.params) + ", paramMap=" + this.paramMap + ", time=" + this.time + ", content=" + this.content + ", deviceType=" + this.deviceType + ", macNameMap=" + this.macNameMap + ", resolveKeys=" + this.resolveKeys + ", alert=" + this.alert + ", alertId=" + this.alertId + ", resolve=" + this.resolve + ", update=" + this.update + ", deviceModel=" + this.deviceModel + ", deviceModelVersion=" + this.deviceModelVersion + ", clientType=" + this.clientType + ", clientManager=" + this.clientManager + ", clientParamMap=" + this.clientParamMap + ")";
        }
    }

    @Generated
    private static final class OmadaLogDTOBuilderImpl
    extends OmadaLogDTOBuilder<OmadaLogDTO, OmadaLogDTOBuilderImpl> {
        @Generated
        private OmadaLogDTOBuilderImpl() {
        }

        @Override
        @Generated
        protected OmadaLogDTOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OmadaLogDTO build() {
            return new OmadaLogDTO(this);
        }
    }
}

