/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.mongo.repository;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mongodb.MongoCommandException;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.tplink.smb.omada.common.h.c;
import com.tplink.smb.omada.common.mongo.repository.MongoSliceProperties;
import com.tplink.smb.omada.common.mongo.repository.e;
import com.tplink.smb.omada.common.mongo.repository.f;
import com.tplink.smb.omada.common.mongo.repository.t;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.ShardKey;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.CollectionUtils;

public abstract class r<P> {
    public static final String ENSURE_SHARD = "ensureShard";
    public static final String ENSURE_INDEX = "ensureIndex";
    public static final String ENABLE_SHARDING = "enableSharding";
    public static final String COLL_STATS = "collStats";
    public static final String VOID = "-";
    public static final int RES_OK = 1;
    public static final String KEY_OK = "ok";
    public static final String KEY_SIZE = "size";
    public static final String KEY_SHARDED = "sharded";
    public static final int[] RETRY_INTERVAL_MS = new int[]{1000, 2000, 3000, 5000, 8000, 15000, 30000, 60000, 90000, 150000};
    protected static final Cache<String, Set<f>> collectionNamesCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).build();
    private static final Logger log = LoggerFactory.getLogger(r.class);
    private MongoSliceProperties mongoSliceProperties = (MongoSliceProperties)a.b(MongoSliceProperties.class);
    protected e collectionMaintenanceMeters = (e)a.b(e.class);

    private static int getIntFromDoc(Document document, String key) {
        return Optional.ofNullable(document.get((Object)key)).filter(v -> v instanceof Number).map(v -> ((Number)v).intValue()).orElse(0);
    }

    protected List<String> listCollectionNamesFromDB() {
        return this.getCollectionNames(true).stream().sorted(Comparator.comparingLong(f::b)).map(f::a).collect(Collectors.toList());
    }

    protected void iteratorCollections(Consumer<String> consumer) {
        this.iteratorCollections(false, consumer);
    }

    protected void iteratorCollectionsByTimeWithSkip(Sort.Direction direction, Query originalQuery, BiConsumer<String, Query> consumer, long ... timeArray) {
        if (timeArray == null || timeArray.length < 1) {
            return;
        }
        if (timeArray.length % 2 == 1) {
            throw new IllegalArgumentException("Length of array 'time' should be even number, current is: " + Arrays.toString(timeArray));
        }
        t timeRanges = new t(timeArray);
        if (originalQuery.getLimit() == 0) {
            this.iteratorCollectionsByTime(direction, timeRanges.a(), timeRanges.b(), name -> consumer.accept((String)name, originalQuery));
            return;
        }
        List<String> collectionNames = this.getCollectionNames().stream().filter(collection -> timeRanges.a((Range<Long>)Range.between((Comparable)Long.valueOf(collection.b()), (Comparable)Long.valueOf(collection.c())))).sorted(Comparator.comparingLong(f::b)).map(f::a).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collectionNames)) {
            return;
        }
        if (collectionNames.size() == 1) {
            String collectionName = (String)collectionNames.get(0);
            consumer.accept(collectionName, originalQuery);
            return;
        }
        this.iteratorCollectionsWithSkipAndLimit(collectionNames, originalQuery, consumer);
    }

    protected void iteratorCollectionsByTimeWithSkip(Sort.Direction direction, long start, long end, Query originalQuery, BiConsumer<String, Query> mapper) {
        this.iteratorCollectionsByTimeWithSkip((f v) -> true, direction, start, end, originalQuery, mapper);
    }

    protected void iteratorCollectionsByTimeWithSkip(@Nonnull Predicate<f> filter, Sort.Direction direction, long startSec, long endSec, Query originalQuery, BiConsumer<String, Query> consumer) {
        if (originalQuery.getSkip() == 0L && originalQuery.getLimit() == 0) {
            log.trace("Origin query is {}, not paged.", (Object)originalQuery);
            this.iteratorCollectionsByTime(direction, startSec, endSec, name -> consumer.accept((String)name, originalQuery));
            return;
        }
        log.trace("Filtering collection of {} by startSec: {}, endSec: {}. Sorting: {}", new Object[]{this.getCollectionNameOrPrefixIfSliced(), startSec, endSec, direction});
        List<String> relatedCollections = this.getCollectionNames().stream().filter(timeRange -> startSec <= timeRange.c() && endSec >= timeRange.b()).filter(filter).sorted(direction == Sort.Direction.ASC ? Comparator.comparingLong(f::b) : Comparator.comparingLong(f::b).reversed()).map(f::a).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(relatedCollections)) {
            log.trace("No collection of {} is within time range: [{}, {}], skip iterator.Origin Query: {}", new Object[]{this.getCollectionNameOrPrefixIfSliced(), startSec, endSec, originalQuery});
            return;
        }
        if (relatedCollections.size() == 1) {
            log.trace("Only one collection {} is within time range: [{}, {}], Using query: {}", new Object[]{relatedCollections, startSec, endSec, originalQuery});
            String collectionName = relatedCollections.get(0);
            consumer.accept(collectionName, originalQuery);
            return;
        }
        this.iteratorCollectionsWithSkipAndLimit(relatedCollections, originalQuery, consumer);
    }

    protected void iteratorCollectionsByTimeAscWithSkip(long startSec, long endSec, Query originalQuery, BiConsumer<String, Query> mapper) {
        this.iteratorCollectionsByTimeWithSkip(Sort.Direction.ASC, startSec, endSec, originalQuery, mapper);
    }

    protected void iteratorCollectionsByTimeDescWithSkip(long startSec, long endSec, Query originalQuery, BiConsumer<String, Query> mapper) {
        this.iteratorCollectionsByTimeWithSkip(Sort.Direction.DESC, startSec, endSec, originalQuery, mapper);
    }

    protected void iteratorCollections(boolean forceUpdateCache, Consumer<String> consumer) {
        if (!this.isCollectionSliced()) {
            consumer.accept(this.getCollectionNameOrPrefixIfSliced());
            return;
        }
        Set<f> collections = this.getCollectionNames(forceUpdateCache);
        if (CollectionUtils.isEmpty(collections)) {
            log.debug("No collection starts with \"{}\"", (Object)this.getCollectionNameOrPrefixIfSliced());
            return;
        }
        List sortedCollectionNames = this.getCollectionNames().stream().sorted(Comparator.comparingLong(f::b)).collect(Collectors.toList());
        for (f c2 : sortedCollectionNames) {
            consumer.accept(c2.a());
        }
    }

    protected void iteratorCollectionsByTimeAsc(long timeStartSec, long timeEndSec, Consumer<String> consumer) {
        this.iteratorCollectionsByTime(Sort.Direction.ASC, timeStartSec, timeEndSec, consumer);
    }

    protected void iteratorCollectionsByTimeDesc(long timeStartSec, long timeEndSec, Consumer<String> consumer) {
        this.iteratorCollectionsByTime(Sort.Direction.DESC, timeStartSec, timeEndSec, consumer);
    }

    protected void iteratorCollectionsByTime(Sort.Direction direction, long timeStartSec, long timeEndSec, Consumer<String> consumer) {
        if (!this.isCollectionSliced()) {
            consumer.accept(this.getCollectionNameOrPrefixIfSliced());
            return;
        }
        Set<f> collections = this.getCollectionNames();
        if (CollectionUtils.isEmpty(collections)) {
            log.debug("No collection starts with \"{}\"", (Object)this.getCollectionNameOrPrefixIfSliced());
            return;
        }
        if (timeStartSec > timeEndSec) {
            long tmp = timeStartSec;
            timeStartSec = timeEndSec;
            timeEndSec = tmp;
        }
        List sortedCollectionNames = this.getCollectionNames().stream().sorted(direction.isAscending() ? Comparator.comparingLong(f::b) : Comparator.comparingLong(f::b).reversed()).collect(Collectors.toList());
        for (f c2 : sortedCollectionNames) {
            if (timeStartSec > c2.c() || timeEndSec < c2.b()) continue;
            try {
                consumer.accept(c2.a());
            }
            catch (Exception e2) {
                log.error("Failed to execute DB operation on collection {}", (Object)c2.a(), (Object)e2);
                throw e2;
            }
        }
    }

    protected void dbMaintenance(boolean needClearData) {
        String dataCategory = this.getCollectionNameOrPrefixIfSliced();
        if (!this.isCollectionSliced()) {
            log.debug("Data: {} is NOT a time-based sliced repository, ensuring indexes.", (Object)dataCategory);
            this.ensureIndexes(dataCategory, this.getIndexDefinitions(), true);
            return;
        }
        log.debug("Starting to maintenance collections of {}", (Object)dataCategory);
        this.ensureShardingEnabledOnDB();
        Set<String> currentPeriodCollectionNames = this.buildCurrentPeriodCollectionNames();
        this.ensureCollections(currentPeriodCollectionNames);
        Set<String> nextPeriodCollectionNames = this.buildNextPeriodCollectionNames();
        this.ensureCollections(nextPeriodCollectionNames);
        Set<f> collectionNames = this.getCollectionNames();
        log.debug("Starting to check old collections of {}, current collections: {}", (Object)dataCategory, collectionNames);
        if (needClearData) {
            long dataRetentionSec = this.getDataRetentionSec();
            this.tryDropCollectionOrDeleteByTimeLessThan(dataRetentionSec, () -> {});
        }
        log.debug("Refreshing collection name cache of {}...", (Object)dataCategory);
        collectionNamesCache.invalidate((Object)this.getCollectionNameOrPrefixIfSliced());
        collectionNames = this.getCollectionNames(true);
        log.debug("Finished check old data of {}, current collections: {}", (Object)dataCategory, collectionNames);
    }

    protected void ensureShardingEnabledOnDB() {
        if (!OmadacType.s()) {
            return;
        }
        String dbName = this.getMongoTemplate().getDb().getName();
        try {
            MongoDatabase admin = this.getMongoTemplate().getMongoDatabaseFactory().getMongoDatabase("admin");
            Document enableSharding = new Document(ENABLE_SHARDING, (Object)dbName);
            this.executeWithRetry(() -> admin.runCommand((Bson)enableSharding), e2 -> this.collectionMaintenanceMeters.a(dbName, VOID, ENABLE_SHARDING, (Throwable)e2));
            log.debug("Successfully ensured sharding is enabled on DB {}.", (Object)dbName);
        }
        catch (Throwable e3) {
            log.error("Failed to enable sharding, DB: {}", (Object)dbName, (Object)e3);
            this.collectionMaintenanceMeters.a(dbName, VOID, ENABLE_SHARDING, e3);
        }
    }

    protected void tryDropCollectionOrDeleteByTimeLessThan(long dataRetentionSec, Runnable onNotSliced) {
        if (!this.isCollectionSliced()) {
            onNotSliced.run();
            return;
        }
        log.debug("Checking data older than timestamp: {} of {}", (Object)dataRetentionSec, (Object)this.getCollectionNameOrPrefixIfSliced());
        AtomicInteger droppedCount = new AtomicInteger(0);
        this.iteratorCollections(true, collectionName -> {
            if (this.isCollectionOlderThan(dataRetentionSec, (String)collectionName)) {
                log.debug("Collection: {} is older than {}, Dropping...", collectionName, (Object)dataRetentionSec);
                this.getMongoTemplate().dropCollection(collectionName);
                droppedCount.addAndGet(1);
            }
        });
        log.debug("Finished check data older than timestamp: {} of {}, Dropped {} collections", new Object[]{dataRetentionSec, this.getCollectionNameOrPrefixIfSliced(), droppedCount});
    }

    protected void ensureCollection(String collectionName) {
        MongoDatabase db = this.getMongoTemplate().getDb();
        String dbName = db.getName();
        long start = System.currentTimeMillis();
        this.ensureShard(dbName, collectionName, true);
        log.info("Starting to maintenance collection for ensureCollection: {}, DB: {}", (Object)collectionName, (Object)dbName);
        this.ensureIndexes(collectionName, this.getIndexDefinitions(), true);
        log.info("Finished maintenance collection for ensureCollection: {}, DB: {}", (Object)collectionName, (Object)dbName);
        this.collectionMaintenanceMeters.a(dbName, collectionName, System.currentTimeMillis() - start);
        this.getCollectionNames(true);
    }

    protected void ensureCollections(Set<String> collectionNames) {
        MongoDatabase db = this.getMongoTemplate().getDb();
        String dbName = db.getName();
        boolean needPreCreateCollection = this.needPreCreateCollection();
        collectionNames.forEach(collectionName -> {
            if (!this.beforeMaintainCollection(dbName, (String)collectionName)) {
                return;
            }
            log.debug("Starting to maintenance collection: {}, DB: {}", collectionName, (Object)dbName);
            this.ensureShard(dbName, (String)collectionName, needPreCreateCollection);
            this.ensureIndexes((String)collectionName, this.getIndexDefinitions(), needPreCreateCollection);
        });
        log.debug("Finished maintenance collection: {}, DB: {}", collectionNames, (Object)dbName);
        this.getCollectionNames(true);
    }

    protected <T> T executeWithRetry(Supplier<T> supplier, Consumer<Throwable> onEachFailure) throws Throwable {
        Object ex = new c("Execution Failed!");
        for (int interval : RETRY_INTERVAL_MS) {
            try {
                return supplier.get();
            }
            catch (MongoCommandException | UncategorizedMongoDbException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                ex = e3;
                onEachFailure.accept(e3);
                log.warn("MongoDB Command Execution failed, Waiting {}ms for next execution.", (Object)interval, (Object)e3);
                Thread.sleep(interval);
            }
        }
        throw ex;
    }

    protected void ensureShard(String dbName, String collectionName, boolean preCreateCollection) {
        ShardKey shardKey;
        boolean collStatsOK;
        Document collStats;
        if (!OmadacType.s()) {
            return;
        }
        try {
            boolean isAlreadySharded;
            Document collStatsDoc = new Document(COLL_STATS, (Object)collectionName);
            MongoDatabase db = this.getMongoTemplate().getDb();
            collStats = this.executeWithRetry(() -> db.runCommand((Bson)collStatsDoc), e2 -> this.collectionMaintenanceMeters.a(dbName, collectionName, COLL_STATS, (Throwable)e2));
            collStatsOK = 1 == r.getIntFromDoc(collStats, KEY_OK);
            this.collectionMaintenanceMeters.a(dbName, collectionName, COLL_STATS);
            log.trace("Collection stats of {} : {}", (Object)collectionName, (Object)collStats);
            boolean bl = isAlreadySharded = collStatsOK && collStats.getBoolean((Object)KEY_SHARDED, false);
            if (isAlreadySharded) {
                log.debug("Collection: {}, DB: {} is already sharded.", (Object)collectionName, (Object)dbName);
                return;
            }
        }
        catch (Throwable e3) {
            log.error("Failed to execute command: 'collStats' on collection: {}, DB: {}", new Object[]{collectionName, dbName, e3});
            this.collectionMaintenanceMeters.a(dbName, collectionName, COLL_STATS, e3);
            return;
        }
        MongoCollection collection = this.getMongoTemplate().getCollection(collectionName);
        MongoMappingContext mappingCtx = (MongoMappingContext)this.getMongoTemplate().getConverter().getMappingContext();
        MongoPersistentEntity entity = (MongoPersistentEntity)mappingCtx.getPersistentEntity(this.getPOClass());
        if (entity == null) {
            entity = new BasicMongoPersistentEntity((TypeInformation)ClassTypeInformation.from(this.getPOClass()));
        }
        if (!(shardKey = entity.getShardKey()).isSharded()) {
            log.debug("Collection: {}, DB: {} is not sharded, skip.", (Object)collectionName, (Object)dbName);
            return;
        }
        try {
            Document shardDef = this.toDocument(shardKey);
            if (collStatsOK && r.getIntFromDoc(collStats, KEY_SIZE) > 0) {
                log.info("Collection {} is already created, trying to create hash index: {}", (Object)collectionName, (Object)shardDef);
                collection.createIndex((Bson)shardDef);
            } else if (!preCreateCollection) {
                log.debug("Collection {} is not existed and don't need ensureShard it in advance.", (Object)collectionName);
                return;
            }
            MongoDatabase admin = this.getMongoTemplate().getMongoDatabaseFactory().getMongoDatabase("admin");
            String fullCollectionName = dbName + "." + collectionName;
            log.debug("Sharding collection: {}, shard key: {}", (Object)fullCollectionName, (Object)shardDef);
            Document shardCollection = new Document("shardCollection", (Object)fullCollectionName).append("key", (Object)shardDef);
            this.executeWithRetry(() -> admin.runCommand((Bson)shardCollection), e2 -> this.collectionMaintenanceMeters.a(dbName, collectionName, ENSURE_SHARD, (Throwable)e2));
            this.collectionMaintenanceMeters.a(dbName, collectionName, ENSURE_SHARD);
        }
        catch (Throwable e4) {
            log.error("Failed to create shard of collection: {}, DB: {}", new Object[]{collectionName, dbName, e4});
            this.collectionMaintenanceMeters.a(dbName, collectionName, ENSURE_SHARD, e4);
        }
    }

    protected void checkThenEnsureIndexes(String collectionName, IndexDefinition[] indexDefinitions) {
        if (indexDefinitions == null || indexDefinitions.length < 1) {
            return;
        }
        MongoDatabase db = this.getMongoTemplate().getDb();
        String dbName = db.getName();
        if (!this.beforeMaintainCollection(dbName, collectionName)) {
            return;
        }
        this.ensureIndexes(collectionName, indexDefinitions, true);
    }

    protected void ensureIndexes(String collectionName, IndexDefinition[] indexDefinitions, boolean preCreateCollection) {
        if (indexDefinitions == null || indexDefinitions.length < 1) {
            return;
        }
        IndexOperations indexOperations = this.getMongoTemplate().indexOps(collectionName);
        String dbName = this.getMongoTemplate().getDb().getName();
        Set<Document> idxes = this.getCollectionIdx(collectionName);
        if (!preCreateCollection && CollectionUtils.isEmpty(idxes)) {
            log.debug("Collection {} is not existed and don't need ensureIndexes in advance.", (Object)collectionName);
            return;
        }
        for (IndexDefinition indexDefinition : indexDefinitions) {
            if (idxes.contains(indexDefinition.getIndexKeys())) {
                log.debug("Index: {} of collection: {}, DB: {} already exists, skip create index.", new Object[]{indexDefinition, collectionName, dbName});
                continue;
            }
            try {
                log.debug("Ensuring index: {} of collection: {}, DB: {}", new Object[]{indexDefinition, collectionName, dbName});
                if (indexDefinition instanceof Index) {
                    ((Index)indexDefinition).background();
                }
                this.executeWithRetry(() -> indexOperations.ensureIndex(indexDefinition), e2 -> this.collectionMaintenanceMeters.a(dbName, collectionName, ENSURE_INDEX, (Throwable)e2));
                this.collectionMaintenanceMeters.a(dbName, collectionName, ENSURE_INDEX);
            }
            catch (Throwable e3) {
                log.error("Failed to create index: {} on collection: {}, db: {}", new Object[]{indexDefinition, collectionName, dbName, e3});
                this.collectionMaintenanceMeters.a(dbName, collectionName, ENSURE_INDEX, e3);
            }
        }
    }

    @Nonnull
    protected Set<Document> getCollectionIdx(String collectionName) {
        HashSet<Document> idxes = new HashSet<Document>(10);
        ListIndexesIterable idxIterable = this.getMongoTemplate().getCollection(collectionName).listIndexes();
        for (Document index : idxIterable) {
            idxes.add((Document)index.get((Object)"key", Document.class));
        }
        return idxes;
    }

    protected abstract long getCollectionStartSec(String var1);

    @Nonnull
    protected Set<f> getCollectionNames(boolean forceUpdateCache) {
        Set collectionNames;
        try {
            if (forceUpdateCache) {
                collectionNamesCache.invalidate((Object)this.getCollectionNameOrPrefixIfSliced());
            }
            collectionNames = (Set)collectionNamesCache.get((Object)this.getCollectionNameOrPrefixIfSliced(), () -> {
                HashSet nameSet = new HashSet();
                this.getMongoTemplate().getDb().listCollectionNames().forEach(collectionName -> {
                    f collectionWithTimeRange = this.getEffectiveTimeRangeByCollectionName((String)collectionName);
                    if (collectionWithTimeRange != null) {
                        nameSet.add(collectionWithTimeRange);
                    }
                });
                return nameSet;
            });
        }
        catch (ExecutionException e2) {
            log.error("Failed to fetch collectionNames from mongodb", (Throwable)e2);
            throw new RuntimeException(e2);
        }
        log.trace("Get collectionNames: {}", (Object)collectionNames);
        return collectionNames;
    }

    protected String getCollectionNameForSave(P po) {
        String collection = this.getCollectionNameForQuery(po);
        if (!this.getCollectionNames().contains(this.getEffectiveTimeRangeByCollectionName(collection))) {
            this.ensureCollection(collection);
        }
        return collection;
    }

    protected Map<String, List<P>> groupByCollectionNameForSaveAll(Collection<P> elements) {
        HashMap<String, List<P>> group = new HashMap<String, List<P>>(4);
        for (P p2 : elements) {
            String collection = this.getCollectionNameForQuery(p2);
            List pList = group.computeIfAbsent(collection, key -> {
                if (!this.getCollectionNames().contains(this.getEffectiveTimeRangeByCollectionName(collection))) {
                    this.ensureCollection(collection);
                }
                return new LinkedList();
            });
            pList.add(p2);
        }
        return group;
    }

    protected boolean isCollectionOlderThan(long seconds, String collectionName) {
        if (!this.isCollectionSliced()) {
            return false;
        }
        if (!this.matchCollectionNameOrPrefix(collectionName)) {
            return false;
        }
        String[] parts = collectionName.split("_");
        if (parts.length < 2) {
            return this.getCollectionNames().stream().filter(c2 -> c2.b() != 0L).min(Comparator.comparingLong(f::b)).map(r2 -> r2.b() - 1L).map(aLong -> seconds > aLong).orElse(false);
        }
        long collectionEndSec = this.getCollectionEndSec(parts[1]);
        return seconds > collectionEndSec;
    }

    protected Document toDocument(@Nonnull ShardKey shardKey) {
        Document document = new Document();
        if (CollectionUtils.isEmpty((Collection)shardKey.getPropertyNames()) || shardKey.getPropertyNames().size() != 1) {
            log.warn("Illegal ShardKey: {}", (Object)shardKey);
            return document;
        }
        shardKey.getPropertyNames().stream().findFirst().ifPresent(key -> document.append(key, (Object)"hashed"));
        return document;
    }

    protected abstract long getCollectionEndSec(String var1);

    @Nonnull
    @Deprecated
    protected abstract String getCollectionNameForQuery(P var1);

    @Nonnull
    protected abstract Set<String> buildNextPeriodCollectionNames();

    @Nonnull
    protected abstract Set<String> buildCurrentPeriodCollectionNames();

    private void iteratorCollectionsWithSkipAndLimit(List<String> collectionNames, Query originalQuery, BiConsumer<String, Query> consumer) {
        long querySkip = originalQuery.getSkip();
        int limit = originalQuery.getLimit();
        long skippedSize = 0L;
        int fetchedSize = 0;
        for (String collectionName : collectionNames) {
            Query copied = Query.of((Query)originalQuery).skip(0L).limit(0);
            long count = this.getMongoTemplate().count(copied, collectionName);
            log.trace("Counted collection: {}, result: {}, using query: {}, skippedSize: {}, fetchedSize: {}", new Object[]{collectionName, count, copied, skippedSize, fetchedSize});
            if (count == 0L) continue;
            if (skippedSize + count <= querySkip) {
                log.trace("Skipped query collection: {}, original query: {}, skippedSize: {}, fetchedSize: {}", new Object[]{collectionName, originalQuery, skippedSize += count, fetchedSize});
                continue;
            }
            int need = limit - fetchedSize;
            copied.skip(querySkip - skippedSize).limit(need);
            consumer.accept(collectionName, copied);
            skippedSize += Math.min(querySkip - skippedSize, count);
            log.trace("Queried collection: {}, original query: {}, using query: {}, skippedSize: {}, fetchedSize: {}", new Object[]{collectionName, originalQuery, copied, skippedSize, fetchedSize += (int)Math.min((long)need, count - (querySkip - skippedSize))});
            if (fetchedSize < limit) continue;
            log.trace("Finished after query collection: {}, original query: {}, now skippedSize: {}, fetchedSize: {}", new Object[]{collectionName, originalQuery, skippedSize, fetchedSize});
            break;
        }
    }

    private f getEffectiveTimeRangeByCollectionName(String collectionName) {
        if (!this.matchCollectionNameOrPrefix(collectionName)) {
            return null;
        }
        if (!this.isCollectionSliced()) {
            return new f(collectionName, 0L, Long.MAX_VALUE);
        }
        String[] parts = collectionName.split("_");
        if (parts.length < 2) {
            long current = LocalDateTime.now(ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC);
            return new f(collectionName, 0L, current);
        }
        long collectionStartSec = this.getCollectionStartSec(parts[1]);
        long collectionEndSec = this.getCollectionEndSec(parts[1]);
        return new f(collectionName, collectionStartSec, collectionEndSec);
    }

    private boolean matchCollectionNameOrPrefix(String collectionName) {
        return collectionName.equals(this.getCollectionNameOrPrefixIfSliced()) || collectionName.startsWith(this.getCollectionNameOrPrefixIfSliced() + "_");
    }

    private boolean needPreCreateCollection() {
        return Boolean.TRUE.equals(this.mongoSliceProperties.getPreCreateCollectionEnable());
    }

    @Nonnull
    protected Set<f> getCollectionNames() {
        return this.getCollectionNames(false);
    }

    @Nonnull
    protected abstract IndexDefinition[] getIndexDefinitions();

    protected abstract MongoTemplate getMongoTemplate();

    protected abstract boolean isCollectionSliced();

    @Nonnull
    protected abstract String getCollectionNameOrPrefixIfSliced();

    protected abstract long getDataRetentionSec();

    protected abstract Class<P> getPOClass();

    protected boolean beforeMaintainCollection(String dbName, String collectionName) {
        return true;
    }
}

