/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.mongo.repository;

import com.tplink.smb.omada.common.e.m;
import com.tplink.smb.omada.common.e.n;
import com.tplink.smb.omada.common.mongo.repository.f;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.s;
import jakarta.annotation.Nullable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Query;

public abstract class q<P extends n & m, K>
extends s<P> {
    private static final Logger log = LoggerFactory.getLogger(q.class);
    private static final Pattern PATTERN = Pattern.compile(".+_t(?<t>\\d+)s(?<s>\\d+).*");

    protected abstract int hashCodeOfKey(@Nullable K var1);

    protected boolean sliceKeyMatches(K sliceKey, String collectionName) {
        int hashCode = this.hashCodeOfKey(sliceKey);
        Matcher matcher = PATTERN.matcher(collectionName);
        if (matcher.matches()) {
            int targetIdx;
            int total = Integer.parseInt(matcher.group("t"));
            int sliceIdx = Integer.parseInt(matcher.group("s"));
            return sliceIdx == (targetIdx = Math.abs(hashCode % total) + 1);
        }
        return true;
    }

    protected void iteratorCollectionsBySliceKey(K sliceKey, Consumer<String> consumer) {
        this.iteratorCollections(collectionName -> {
            if (this.sliceKeyMatches(sliceKey, (String)collectionName)) {
                consumer.accept((String)collectionName);
            }
        });
    }

    protected void iteratorCollectionsByTimeAndSliceKey(Sort.Direction direction, long timeStartSec, long timeEndSec, K sliceKey, Consumer<String> consumer) {
        int hashCode = this.hashCodeOfKey(sliceKey);
        this.iteratorCollectionsByTime(direction, timeStartSec, timeEndSec, collectionName -> {
            Matcher matcher = PATTERN.matcher((CharSequence)collectionName);
            if (matcher.matches()) {
                int targetIdx;
                int total = Integer.parseInt(matcher.group("t"));
                int sliceIdx = Integer.parseInt(matcher.group("s"));
                if (sliceIdx != (targetIdx = Math.abs(hashCode % total) + 1)) {
                    return;
                }
            }
            log.trace("Iterating collection: {}", collectionName);
            consumer.accept((String)collectionName);
        });
    }

    protected void iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction direction, long startSec, long endSec, K sliceKey, Query originalQuery, BiConsumer<String, Query> mapper) {
        int hashCode = this.hashCodeOfKey(sliceKey);
        this.iteratorCollectionsByTimeWithSkip((f v) -> {
            String collectionName = v.a();
            Matcher matcher = PATTERN.matcher(collectionName);
            if (matcher.matches()) {
                int targetIdx;
                int total = Integer.parseInt(matcher.group("t"));
                int sliceIdx = Integer.parseInt(matcher.group("s"));
                if (sliceIdx != (targetIdx = Math.abs(hashCode % total) + 1)) {
                    log.trace("Ignoring collection: {}, sliceKey: {}, target sliceIdx: {}", new Object[]{collectionName, sliceKey, targetIdx});
                    return false;
                }
            }
            return true;
        }, direction, startSec, endSec, originalQuery, (collectionName, query) -> {
            log.trace("Iterating collection: {}, decorated query: {}", collectionName, query);
            mapper.accept((String)collectionName, (Query)query);
        });
    }

    @Override
    protected abstract p<P> getStrategy();
}

