/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.packet;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.StringAttribute;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;
import org.tinyradius.util.RadiusUtil;

public class AccessRequest
extends RadiusPacket {
    public static final String AUTH_PAP = "pap";
    public static final String AUTH_CHAP = "chap";
    private String password;
    private String authProtocol = "pap";
    private byte[] chapPassword;
    private byte[] chapChallenge;
    private static SecureRandom random = new SecureRandom();
    private static final int USER_NAME = 1;
    private static final int USER_PASSWORD = 2;
    public static final int CLEARTEXT_PASSWORD = 1100;
    private static final int CHAP_PASSWORD = 3;
    private static final int CHAP_CHALLENGE = 60;
    private static Log logger = LogFactory.getLog(AccessRequest.class);

    public AccessRequest() {
    }

    public AccessRequest(String userName, String userPassword) {
        super(1, AccessRequest.getNextPacketIdentifier());
        this.setUserName(userName);
        this.setUserPassword(userPassword);
    }

    public void setUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException("user name not set");
        }
        if (userName.length() == 0) {
            throw new IllegalArgumentException("empty user name not allowed");
        }
        this.removeAttributes(1);
        this.addAttribute(new StringAttribute(1, userName));
    }

    public void setUserPassword(String userPassword) {
        this.password = userPassword;
    }

    public String getUserPassword() {
        return this.password;
    }

    public String getUserName() {
        List attrs = this.getAttributes(1);
        if (attrs.size() < 1 || attrs.size() > 1) {
            throw new RuntimeException("exactly one User-Name attribute required");
        }
        RadiusAttribute ra = (RadiusAttribute)attrs.get(0);
        return ((StringAttribute)ra).getAttributeValue();
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        if (authProtocol == null || !authProtocol.equals(AUTH_PAP) && !authProtocol.equals(AUTH_CHAP)) {
            throw new IllegalArgumentException("protocol must be pap or chap");
        }
        this.authProtocol = authProtocol;
    }

    public boolean verifyPassword(String plaintext) throws RadiusException {
        if (plaintext == null || plaintext.length() == 0) {
            throw new IllegalArgumentException("password is empty");
        }
        if (this.getAuthProtocol().equals(AUTH_CHAP)) {
            return this.verifyChapPassword(plaintext);
        }
        return this.getUserPassword().equals(plaintext);
    }

    protected void decodeRequestAttributes(String sharedSecret) throws RadiusException {
        RadiusAttribute userPassword = this.getAttribute(2);
        RadiusAttribute chapPassword = this.getAttribute(3);
        RadiusAttribute chapChallenge = this.getAttribute(60);
        if (userPassword != null) {
            this.setAuthProtocol(AUTH_PAP);
            this.password = this.decodePapPassword(userPassword.getAttributeData(), RadiusUtil.getUtf8Bytes(sharedSecret));
            userPassword.setAttributeData(RadiusUtil.getUtf8Bytes(this.password));
        } else if (chapPassword != null && chapChallenge != null) {
            this.setAuthProtocol(AUTH_CHAP);
            this.chapPassword = chapPassword.getAttributeData();
            this.chapChallenge = chapChallenge.getAttributeData();
        } else {
            throw new RadiusException("Access-Request: User-Password or CHAP-Password/CHAP-Challenge missing");
        }
    }

    protected void encodeRequestAttributes(String sharedSecret) {
        if (this.password == null || this.password.length() == 0) {
            String val;
            RadiusAttribute attr = this.getAttribute(1100);
            if (attr != null && (val = attr.getAttributeValue()) != null) {
                this.removeAttributes(1100);
                this.removeAttributes(2);
                this.addAttribute(new StringAttribute(2, val));
            }
            return;
        }
        if (this.getAuthProtocol().equals(AUTH_PAP)) {
            byte[] pass = this.encodePapPassword(RadiusUtil.getUtf8Bytes(this.password), RadiusUtil.getUtf8Bytes(sharedSecret));
            this.addOrModifyAttribute(2, pass);
        } else if (this.getAuthProtocol().equals(AUTH_CHAP)) {
            byte[] challenge = this.createChapChallenge();
            byte[] pass = this.encodeChapPassword(this.password, challenge);
            this.addOrModifyAttribute(3, pass);
            this.addOrModifyAttribute(60, challenge);
        }
    }

    private void addOrModifyAttribute(int type, byte[] data) {
        RadiusAttribute att = this.getAttribute(type);
        if (att == null) {
            this.addAttribute(new RadiusAttribute(type, data));
        } else {
            att.setAttributeData(data);
        }
    }

    private byte[] encodePapPassword(byte[] userPass, byte[] sharedSecret) {
        int n = Math.min(userPass.length, 128);
        byte[] encryptedPass = new byte[(n + 16 - 1) / 16 * 16];
        System.arraycopy(userPass, 0, encryptedPass, 0, n);
        MessageDigest md5 = this.getMd5Digest();
        for (int i = 0; i < encryptedPass.length; i += 16) {
            md5.reset();
            md5.update(sharedSecret);
            if (i == 0) {
                md5.update(this.getAuthenticator());
            } else {
                md5.update(encryptedPass, i - 16, 16);
            }
            byte[] bn = md5.digest();
            for (int j = 0; j < 16; ++j) {
                encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
            }
        }
        return encryptedPass;
    }

    private String decodePapPassword(byte[] encryptedPass, byte[] sharedSecret) throws RadiusException {
        int n;
        if (encryptedPass == null) {
            throw new RadiusException("Null User-Password attribute");
        }
        if (encryptedPass.length < 16 || encryptedPass.length % 16 != 0) {
            throw new RadiusException("Malformed User-Password attribute, length = " + encryptedPass.length + ", but length must be at least 16 and divisible by 16");
        }
        MessageDigest md5 = this.getMd5Digest();
        for (int i = encryptedPass.length - 16; i >= 0; i -= 16) {
            md5.reset();
            md5.update(sharedSecret);
            if (i == 0) {
                md5.update(this.getAuthenticator());
            } else {
                md5.update(encryptedPass, i - 16, 16);
            }
            byte[] bn = md5.digest();
            for (int j = 0; j < 16; ++j) {
                encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
            }
        }
        for (n = encryptedPass.length; n > 0 && encryptedPass[n - 1] == 0; --n) {
        }
        byte[] passtrunc = new byte[n];
        System.arraycopy(encryptedPass, 0, passtrunc, 0, n);
        return RadiusUtil.getStringFromUtf8(passtrunc);
    }

    private byte[] createChapChallenge() {
        byte[] challenge = new byte[16];
        random.nextBytes(challenge);
        return challenge;
    }

    private byte[] encodeChapPassword(String plaintext, byte[] chapChallenge) {
        byte chapIdentifier = (byte)random.nextInt(256);
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        md5.update(chapIdentifier);
        md5.update(RadiusUtil.getUtf8Bytes(plaintext));
        byte[] chapHash = md5.digest(chapChallenge);
        System.arraycopy(chapHash, 0, chapPassword, 1, 16);
        return chapPassword;
    }

    private boolean verifyChapPassword(String plaintext) throws RadiusException {
        if (plaintext == null || plaintext.length() == 0) {
            throw new IllegalArgumentException("plaintext must not be empty");
        }
        if (this.chapChallenge == null || this.chapChallenge.length != 16) {
            throw new RadiusException("CHAP challenge must be 16 bytes");
        }
        if (this.chapPassword == null || this.chapPassword.length != 17) {
            throw new RadiusException("CHAP password must be 17 bytes");
        }
        byte chapIdentifier = this.chapPassword[0];
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        md5.update(chapIdentifier);
        md5.update(RadiusUtil.getUtf8Bytes(plaintext));
        byte[] chapHash = md5.digest(this.chapChallenge);
        for (int i = 0; i < 16; ++i) {
            if (chapHash[i] == this.chapPassword[i + 1]) continue;
            return false;
        }
        return true;
    }

    public boolean hasValidMessageAuthenticator(String sharedSecret) {
        return this.hasValidMessageAuthenticator(sharedSecret, this);
    }
}

