/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.port.schedule.a;

import com.google.common.collect.Lists;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingExpireTime;
import com.tplink.smb.omada.monitor.roaming.port.cache.f;
import com.tplink.smb.omada.monitor.roaming.port.internal.a;
import com.tplink.smb.omada.monitor.roaming.port.schedule.RoamingScheduleProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@b
public class e
implements ScheduledEventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    private RoamingScheduleProperties b;
    @Autowired
    private ScheduleCenter c;
    @Autowired
    private LockService d;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.omadac.b e;
    @Autowired
    private f f;
    @Autowired
    private a g;
    @Autowired
    @Qualifier(value="roamingWorkGroup")
    @Lazy
    private ExecutorService h;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.monitor.roaming.port.a.a i;
    @Autowired
    @Qualifier(value="commThreadPool")
    private ExecutorService j;
    @Autowired
    private com.tplink.smb.omada.monitor.api.c.b.a k;

    @PostConstruct
    public void a() {
        com.tplink.smb.omada.common.concurrent.thread.a.a(() -> {
            ScheduleTask checkExpireScheduleTask = ScheduleTask.builder().withIdentity("monitor:roaming.expire.check.task").withFixedRateTrigger(Integer.valueOf(600000), Integer.valueOf(30000)).withEnableSharding(Integer.valueOf(this.b.getPartitions())).build();
            this.c.saveTask(checkExpireScheduleTask);
            this.c.registerEventHandler("monitor:roaming.expire.check.task", (ScheduledEventHandler)this, this.j);
        });
    }

    @Trace
    public void handle(@Nonnull ScheduledEvent scheduledEvent) {
        Integer shardingIndex = scheduledEvent.getShardingParam().getShardingIndex();
        this.d.doWithTryLock("monitor:roaming.expire.check.lock", (Object)shardingIndex.toString(), () -> {
            this.a(shardingIndex);
            return true;
        }, () -> {
            a.warn("get roaming check expire lock for partition fail, task is running, shardingIndex={}", (Object)shardingIndex);
            return false;
        });
    }

    private void a(Integer shardingIndex) {
        Map omadacSiteMap = this.k.a(shardingIndex.intValue());
        if (CollectionUtils.isEmpty((Map)omadacSiteMap)) {
            return;
        }
        omadacSiteMap.forEach((omadacId, siteIds) -> this.a((String)omadacId));
    }

    private void a(String omadacId) {
        Collection<RoamingExpireTime> roamingExpireTimes = this.f.a(omadacId);
        if (CollectionUtils.isEmpty(roamingExpireTimes)) {
            return;
        }
        this.h.execute(() -> {
            HashMap<String, Set> site2Macs = new HashMap<String, Set>(16);
            roamingExpireTimes.forEach(roamingExpireTime -> {
                Set macSet = site2Macs.getOrDefault(roamingExpireTime.getSiteId(), new HashSet(16));
                macSet.add(roamingExpireTime.getMac());
                site2Macs.put(roamingExpireTime.getSiteId(), macSet);
            });
            site2Macs.forEach((k, v) -> {
                this.i.a((Integer)v.size());
                this.g.b(omadacId, (String)k, Lists.newArrayList((Iterable)v), false);
            });
        });
    }
}

