/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.port.internal;

import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteListDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.monitor.api.internal.roaming.dto.GetRoamingPatRespDTO;
import com.tplink.smb.omada.monitor.roaming.a.d;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingAp;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingApPat;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingCapability;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingRelatedAp;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteStatus;
import com.tplink.smb.omada.monitor.roaming.port.eventcenter.dto.RoamingEventDTO;
import com.tplink.smb.omada.monitor.roaming.port.internal.dto.RoamingApClearDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private d b;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a c;
    @Autowired
    @Qualifier(value="roamingWorkGroup")
    @Lazy
    private ExecutorService d;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a e;

    private void a(String omadacId, String siteId, Set<String> bssids, RoamingAp roamingAp, boolean supportAiRoaming, boolean roamingEnableBySite) {
        a.debug("clearRelevant {}, omadacId={}, siteId={}", new Object[]{roamingAp.getMac(), omadacId, siteId});
        for (int i = 0; i < 2; ++i) {
            if (CollectionUtils.isEmpty(roamingAp.getApList())) {
                return;
            }
            boolean anyRemoved = false;
            ArrayList<RoamingRelatedAp> tempList = new ArrayList<RoamingRelatedAp>(roamingAp.getApList());
            Iterator each = tempList.iterator();
            while (each.hasNext()) {
                RoamingRelatedAp ap = (RoamingRelatedAp)each.next();
                if (!bssids.contains(ap.getBssid())) continue;
                a.debug("handling the aplist of AP {} Neighbor,  - mac: {}, bssid: {}, omadacId={}, siteId={}", new Object[]{roamingAp.getMac(), ap.getMac(), ap.getBssid(), omadacId, siteId});
                each.remove();
                anyRemoved = true;
            }
            if (!anyRemoved) break;
            RoamingAp newRoamingAp = new RoamingAp(roamingAp.getMac(), roamingAp.getBssid(), roamingAp.getRegetNeighbor(), tempList);
            if (this.c.a(omadacId, siteId, roamingAp.getBssid(), roamingAp, newRoamingAp)) {
                a.debug("neighbor list delete, issue: {}\n{}, omadacId={}, siteId={}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
                this.b.a(omadacId, siteId, newRoamingAp.getMac(), newRoamingAp, supportAiRoaming, roamingEnableBySite, false);
                return;
            }
            roamingAp = this.c.a(omadacId, siteId, roamingAp.getBssid());
        }
        a.warn("try clear neighbor list failed, omadac:{}, site:{}, mac:{}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)roamingAp.getMac())});
    }

    public OperationResponse a(String omadacId, String siteId, List<String> macList, boolean reGetNeighbor) {
        if (T.a((String)omadacId) || T.a((String)siteId) || CollectionUtils.isEmpty(macList)) {
            return OperationResponse.PARAM_ERROR;
        }
        Set<RoamingApClearDTO> clearRoamingAps = this.b(omadacId, siteId, macList);
        if (CollectionUtils.isEmpty(clearRoamingAps)) {
            return OperationResponse.SUCCESS;
        }
        this.d.execute(() -> {
            try {
                this.a(omadacId, siteId, clearRoamingAps, reGetNeighbor, null);
            }
            catch (Exception e2) {
                a.error(e2.getMessage() + ", omadacId=" + omadacId + ", siteId=" + siteId, (Throwable)e2);
            }
        });
        return OperationResponse.SUCCESS;
    }

    public OperationResponse b(String omadacId, String siteId, List<String> macList, boolean reGetNeighbor) {
        if (T.a((String)omadacId) || T.a((String)siteId) || CollectionUtils.isEmpty(macList)) {
            return OperationResponse.PARAM_ERROR;
        }
        Set<RoamingApClearDTO> clearRoamingAps = this.b(omadacId, siteId, macList);
        if (CollectionUtils.isEmpty(clearRoamingAps)) {
            return OperationResponse.SUCCESS;
        }
        this.a(omadacId, siteId, clearRoamingAps, reGetNeighbor, null);
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId, String siteId, List<String> macList, boolean reGetNeighbor, boolean roamingEnable, boolean aiRoamingEnable) {
        if (T.a((String)omadacId) || T.a((String)siteId) || CollectionUtils.isEmpty(macList) || Boolean.FALSE.equals(roamingEnable)) {
            return OperationResponse.PARAM_ERROR;
        }
        Set<RoamingApClearDTO> clearRoamingAps = this.b(omadacId, siteId, macList);
        this.d.execute(() -> {
            try {
                this.a(omadacId, siteId, clearRoamingAps, reGetNeighbor, (Boolean)aiRoamingEnable);
            }
            catch (Exception e2) {
                a.error(e2.getMessage() + ", omadacId=" + omadacId + ", siteId=" + siteId, (Throwable)e2);
            }
        });
        return OperationResponse.SUCCESS;
    }

    public List<GetRoamingPatRespDTO> a(String omadacId, String siteId, List<String> macList) {
        if (CollectionUtils.isEmpty(macList)) {
            return new ArrayList<GetRoamingPatRespDTO>();
        }
        ArrayList<GetRoamingPatRespDTO> patList = new ArrayList<GetRoamingPatRespDTO>();
        Map<String, RoamingApPat> roamingApPatMap = this.c.c(omadacId, siteId, new HashSet<String>(macList));
        macList.forEach(mac -> {
            RoamingApPat roamingApPat = (RoamingApPat)roamingApPatMap.get(mac);
            if (roamingApPat != null) {
                patList.add(new GetRoamingPatRespDTO().setOmadacId(omadacId).setSiteId(siteId).setMac(mac).setPat(roamingApPat.getParams()));
            }
        });
        return patList;
    }

    @Nonnull
    private Set<RoamingApClearDTO> b(String omadacId, String siteId, List<String> macList) {
        if (T.a((String)omadacId) || T.a((String)siteId) || CollectionUtils.isEmpty(macList)) {
            return new HashSet<RoamingApClearDTO>();
        }
        HashSet<RoamingApClearDTO> clearRoamingAps = new HashSet<RoamingApClearDTO>(macList.size());
        Map<String, RoamingCapability> roamingCapabilityMap = this.c.a(omadacId, siteId, macList);
        for (String mac : macList) {
            RoamingCapability capability = roamingCapabilityMap.get(mac);
            if (capability == null || !Boolean.TRUE.equals(capability.getSupportRoaming())) continue;
            if (Boolean.TRUE.equals(capability.getSupportRoamingV2())) {
                clearRoamingAps.add(new RoamingApClearDTO(mac, false));
                continue;
            }
            clearRoamingAps.add(new RoamingApClearDTO(mac, true));
        }
        return clearRoamingAps;
    }

    private void a(String omadacId, String siteId, @Nonnull Set<RoamingApClearDTO> clearRoamingAps, boolean reGetNeighbor, @Nullable Boolean aiRoamingEnable) {
        Set<String> clearRoamingApMacs = clearRoamingAps.stream().map(RoamingApClearDTO::getDeviceMac).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(clearRoamingApMacs)) {
            return;
        }
        a.debug("start batchClearApRoamingInfo, omadacId:{}, siteId:{}, apMacs:{}, regetNeighbor:{}, aiRoamingEnable:{}", new Object[]{omadacId, siteId, clearRoamingApMacs, reGetNeighbor, aiRoamingEnable});
        HashSet<String> bssidSetByMacs = new HashSet<String>(clearRoamingApMacs.size());
        Map<String, Set<String>> apBssidMap = this.c.e(omadacId, siteId, clearRoamingApMacs);
        if (CollectionUtils.isEmpty(apBssidMap)) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : apBssidMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            bssidSetByMacs.addAll((Collection<String>)entry.getValue());
        }
        if (CollectionUtils.isEmpty(bssidSetByMacs)) {
            return;
        }
        if (!reGetNeighbor) {
            this.c.b(omadacId, siteId, bssidSetByMacs);
        } else {
            Map<String, RoamingAp> cacheRoamingApMap = this.c.a(omadacId, siteId, bssidSetByMacs);
            HashMap<String, RoamingAp> updateRoamingApMap = new HashMap<String, RoamingAp>(cacheRoamingApMap.size());
            bssidSetByMacs.forEach(bssid -> {
                RoamingAp roamingAp = (RoamingAp)cacheRoamingApMap.get(bssid);
                if (roamingAp != null) {
                    RoamingAp newRoamingAp = new RoamingAp(roamingAp.getMac(), (String)bssid, 2, (List<RoamingRelatedAp>)new ArrayList<RoamingRelatedAp>());
                    updateRoamingApMap.putIfAbsent((String)bssid, newRoamingAp);
                }
            });
            this.c.a(omadacId, siteId, updateRoamingApMap);
        }
        if (reGetNeighbor) {
            RoamingEventDTO roamingEvent = new RoamingEventDTO(omadacId, siteId, RoamingEventDTO.RoamingEventType.UNSTABLE);
            DomainEventBusHolder.getPublisher().publish((DomainEvent)roamingEvent);
        }
        if (aiRoamingEnable == null) {
            aiRoamingEnable = Optional.ofNullable(this.b.a(omadacId, siteId)).map(RoamingSiteStatus::getAiRoamingEnable).orElse(false);
        }
        this.a(omadacId, siteId, bssidSetByMacs, this.c.c(omadacId, siteId), (boolean)aiRoamingEnable);
        this.c.f(omadacId, siteId, clearRoamingApMacs);
        if (reGetNeighbor) {
            clearRoamingAps.forEach(roamingApClearDTO -> {
                if (Boolean.TRUE.equals(roamingApClearDTO.getNeedReGetNeighbor())) {
                    this.b.b(omadacId, siteId, roamingApClearDTO.getDeviceMac());
                }
            });
        } else {
            this.c.g(omadacId, siteId, clearRoamingApMacs);
            this.c.d(omadacId, siteId, clearRoamingApMacs);
        }
    }

    private void a(String omadacId, String siteId, Set<String> bssids, Set<String> aiRoamingMacs, boolean aiRoamingEnableBySite) {
        if (CollectionUtils.isEmpty(bssids)) {
            return;
        }
        HashSet<String> clearRoamingMacs = new HashSet<String>();
        this.c.a(omadacId, siteId).stream().filter(Objects::nonNull).map(RoamingAp.class::cast).filter(roamingAp -> !CollectionUtils.isEmpty(roamingAp.getApList())).forEach(roamingAp -> {
            if (roamingAp.getApList().stream().map(RoamingRelatedAp::getBssid).anyMatch(bssids::contains)) {
                clearRoamingMacs.add(roamingAp.getMac());
                this.a(omadacId, siteId, bssids, (RoamingAp)roamingAp, aiRoamingMacs.contains(roamingAp.getMac()), aiRoamingEnableBySite);
            }
        });
        this.b.a(omadacId, siteId, clearRoamingMacs);
    }

    @Deprecated
    public OperationResponse a(String omadacId, String siteId, Boolean roamingEnable, Boolean aiRoamingEnable) {
        if (T.a((String)omadacId) || T.a((String)siteId)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.FALSE.equals(roamingEnable)) {
            this.c.g(omadacId, siteId);
            DomainEventBusHolder.getPublisher().publish((DomainEvent)new RoamingEventDTO(omadacId, siteId, RoamingEventDTO.RoamingEventType.CLOSE));
        } else if (Boolean.FALSE.equals(aiRoamingEnable)) {
            this.c.b(omadacId, siteId);
        } else {
            DomainEventBusHolder.getPublisher().publish((DomainEvent)new RoamingEventDTO(omadacId, siteId, RoamingEventDTO.RoamingEventType.UNSTABLE));
        }
        this.c.a(omadacId, siteId, new RoamingSiteStatus(roamingEnable, aiRoamingEnable));
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId) {
        List siteList = (List)this.e.a(new QuerySiteListDTO(omadacId)).getResult();
        if (CollectionUtils.isEmpty((Collection)siteList)) {
            return OperationResponse.SUCCESS;
        }
        for (SiteDTO siteDTO : siteList) {
            this.c.g(omadacId, siteDTO.getId());
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId, String siteId) {
        this.c.g(omadacId, siteId);
        return OperationResponse.SUCCESS;
    }
}

