/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.port.eventcenter.a;

import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.device.manage.message.config.InformIntervalConfig;
import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.manager.device.api.internal.c.c.a.c;
import com.tplink.smb.omada.manager.device.api.internal.device.b;
import com.tplink.smb.omada.manager.device.api.internal.device.request.a.g;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageCapabilityDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageDTO;
import com.tplink.smb.omada.monitor.roaming.port.a.a;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteTime;
import com.tplink.smb.omada.monitor.roaming.port.eventcenter.dto.RoamingEventDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class f
implements DomainEventSubscriber<RoamingEventDTO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(f.class);
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a b;
    @Autowired
    @Qualifier(value="roamingWorkGroup")
    @Lazy
    private ExecutorService c;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.a d;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.c.c.a e;
    @Autowired
    @Lazy
    private a f;
    @Autowired
    private b g;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(RoamingEventDTO.class, (DomainEventSubscriber)this, this.c);
    }

    public void a(@Nonnull RoamingEventDTO roamingEvent) {
        String omadacId = roamingEvent.getOmadacId();
        String siteId = roamingEvent.getSiteId();
        RoamingSiteTime oldTime = this.b.d(omadacId, siteId);
        RoamingEventDTO.RoamingEventType eventType = RoamingEventDTO.RoamingEventType.valueOf(roamingEvent.getRoamingEventType());
        if (oldTime == null && eventType != RoamingEventDTO.RoamingEventType.CLOSE) {
            this.b.a(omadacId, siteId, new RoamingSiteTime(System.currentTimeMillis(), false));
            return;
        }
        switch (eventType) {
            case UNSTABLE: {
                this.a(omadacId, siteId);
                break;
            }
            case STABLE: {
                try {
                    this.b.a(omadacId, siteId, new RoamingSiteTime(System.currentTimeMillis(), true));
                    this.f.a(Boolean.TRUE);
                    this.c.execute(() -> {
                        a.debug("status changed, roaming stable, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
                        this.a(omadacId, siteId, 8640);
                    });
                }
                catch (RejectedExecutionException r) {
                    a.warn("Roaming stable rejected, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
                    this.a(omadacId, siteId, 8640);
                }
                break;
            }
            case CLOSE: {
                a.debug("roaming closed reset inform interval, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
                this.a(omadacId, siteId, 3);
                break;
            }
            default: {
                String deviceId = roamingEvent.getDeviceId();
                a.warn("Undefined roaming event found event type : {}, mac : {}, omadacId={}, siteId={}", new Object[]{roamingEvent.getRoamingEventType(), com.tplink.smb.omada.common.util.e.a.d((String)deviceId), omadacId, siteId});
            }
        }
    }

    private void a(String omadacId, String siteId, Integer interval) {
        InformIntervalConfig issuedIntervalInfo = new InformIntervalConfig();
        issuedIntervalInfo.setRoamingInterval(Integer.valueOf(Math.min(30, interval)));
        issuedIntervalInfo.setProbeClients(interval);
        Set connectApMacSet = this.g.a(omadacId, siteId, DeviceTypeEnum.a, Boolean.valueOf(false));
        a.debug("connected ap macs :{}, omadacId={}, siteId={}", new Object[]{connectApMacSet, omadacId, siteId});
        g request = com.tplink.smb.omada.manager.device.api.internal.device.request.a.g.a().a(omadacId).a(new ArrayList(connectApMacSet)).a();
        List apImages = (List)this.d.a(request).e();
        if (CollectionUtils.isEmpty((Collection)apImages)) {
            return;
        }
        Map apImageMap = apImages.stream().collect(Collectors.toMap(DeviceImageDTO::getMac, Function.identity()));
        for (String mac : connectApMacSet) {
            Integer supportRoaming;
            ApImageDTO apImage = (ApImageDTO)apImageMap.get(mac);
            if (apImage == null || apImage.getStatus() == null || !apImage.getStatus().e() || (supportRoaming = ((ApImageCapabilityDTO)apImage.getCapability()).getSupportRoaming()) == null || supportRoaming == 0 || com.tplink.smb.omada.monitor.roaming.b.a.a(apImage)) continue;
            a.debug("roaming interval changed ap mac :{}, omadacId={}, siteId={}", new Object[]{mac, omadacId, siteId});
            c deviceRequest = new c();
            deviceRequest.a(omadacId);
            deviceRequest.b(mac);
            deviceRequest.c(DeviceTypeEnum.a.b());
            HashMap<String, InformIntervalConfig> setMap = new HashMap<String, InformIntervalConfig>();
            setMap.put(ApSetKeyEnum.INTERVAL.key(), issuedIntervalInfo);
            deviceRequest.a(setMap);
            this.e.b(deviceRequest);
        }
    }

    private void a(String omadacId, String siteId) {
        RoamingSiteTime oldTime = this.b.d(omadacId, siteId);
        if (oldTime == null) {
            return;
        }
        this.b.a(omadacId, siteId, new RoamingSiteTime(System.currentTimeMillis(), false));
        if (Boolean.TRUE.equals(oldTime.getStable())) {
            this.c.execute(() -> {
                a.debug("status changed, roaming unstable, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
                this.a(omadacId, siteId, 3);
            });
        }
    }

    public /* synthetic */ void handleEvent(@Nonnull Object object) {
        this.a((RoamingEventDTO)((Object)object));
    }
}

