/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.port.eventcenter.a;

import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedRoamingInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedRoamingPat;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceQueryDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.ap.ApInformDomainEventDTO;
import com.tplink.smb.omada.monitor.roaming.RoamingProperties;
import com.tplink.smb.omada.monitor.roaming.a.b;
import com.tplink.smb.omada.monitor.roaming.a.d;
import com.tplink.smb.omada.monitor.roaming.port.a.a;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingApPat;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingCapability;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteStatus;
import com.tplink.smb.omada.monitor.roaming.port.cache.h;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class c
implements DomainEventSubscriber<ApInformDomainEventDTO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private LockService b;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a c;
    @Autowired
    private d d;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.a e;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a f;
    @Autowired
    @Qualifier(value="roamingWorkGroup")
    @Lazy
    private ExecutorService g;
    @Autowired
    @Lazy
    private a h;
    @Autowired
    private RoamingProperties i;
    @Autowired
    private b j;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.a.c k;
    @Autowired
    private h l;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.a.a m;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(ApInformDomainEventDTO.class, (DomainEventSubscriber)this, this.g);
    }

    public void a(@Nonnull ApInformDomainEventDTO apInform) {
        a.debug("start handle roaming inform, omadac:{}, site:{}, mac:{}", new Object[]{apInform.getOmadacId(), apInform.getSiteId(), com.tplink.smb.omada.common.util.e.a.d((String)apInform.getDeviceMac())});
        if (this.i.isShutdown()) {
            a.debug("stop handle roaming inform, omadac:{}, site:{}, mac:{}", new Object[]{apInform.getOmadacId(), apInform.getSiteId(), apInform.getDeviceMac()});
            return;
        }
        EapInformBody informBody = (EapInformBody)apInform.getInformBody();
        ReportedRoamingInfo reportedRoamingInfo = informBody.getReportedRoamingInfo();
        if (reportedRoamingInfo == null) {
            return;
        }
        long informTime = apInform.getTimestamp();
        this.a(apInform.getOmadacId(), apInform.getSiteId(), apInform.getDeviceMac(), reportedRoamingInfo, informTime);
    }

    @Trace
    private void a(String omadacId, String siteId, String deviceMac, ReportedRoamingInfo reportedRoamingInfo, long informTime) {
        this.h.a();
        RoamingSiteStatus siteStatus = this.d.a(omadacId, siteId);
        if (siteStatus.getRoamingEnable() == null || !siteStatus.getRoamingEnable().booleanValue()) {
            return;
        }
        boolean aiRoamingEnable = Boolean.TRUE.equals(siteStatus.getAiRoamingEnable());
        boolean reportPat = false;
        if (aiRoamingEnable && (reportedRoamingInfo.getReportedRoamingPat() != null || reportedRoamingInfo.getReportedRoamingPatNew() != null)) {
            this.a(omadacId, siteId, deviceMac, reportedRoamingInfo);
            reportPat = true;
        }
        this.a(omadacId, siteId, deviceMac, reportedRoamingInfo, aiRoamingEnable, reportPat);
        boolean nonPingPongRoamingEnable = Boolean.TRUE.equals(siteStatus.getNonPingPongRoamingEnable());
        if (!CollectionUtils.isEmpty((Collection)reportedRoamingInfo.getUnstableConnectEventList())) {
            if (!nonPingPongRoamingEnable) {
                a.debug("skip handle unstable event of omadacId : {} siteId : {} deviceMac : {} for nonPingPongRoamingEnable is false", new Object[]{omadacId, siteId, deviceMac});
            } else {
                this.l.a(omadacId, siteId, deviceMac, informTime, reportedRoamingInfo.getUnstableConnectEventList());
            }
        }
    }

    private void a(String omadacId, String siteId, String deviceMac, ReportedRoamingInfo roamingInfo) {
        a.debug("Received AP pat data from mac:{}, omadacId:{}, siteId:{}.", new Object[]{deviceMac, omadacId, siteId});
        ReportedRoamingPat reportedRoamingPat = roamingInfo.getReportedRoamingPat();
        if (reportedRoamingPat == null) {
            reportedRoamingPat = roamingInfo.getReportedRoamingPatNew();
        } else {
            reportedRoamingPat.setBandNum(Integer.valueOf(3));
            reportedRoamingPat.setBwNum(Integer.valueOf(4));
            reportedRoamingPat.setMcslevelNum(Integer.valueOf(3));
        }
        RoamingApPat cachedPat = this.c.c(omadacId, siteId, deviceMac);
        if (cachedPat == null) {
            if (reportedRoamingPat.getParams() == null) {
                a.debug("First reported roaming pat params is null, ap {}, omadacId={}, siteId={}", new Object[]{deviceMac, omadacId, siteId});
                cachedPat = new RoamingApPat(reportedRoamingPat.getBandNum(), reportedRoamingPat.getBwNum(), reportedRoamingPat.getMcslevelNum());
                cachedPat.setParamUp(reportedRoamingPat.getParamUp());
            } else {
                a.debug("First reported roaming pat params is not null, init ap {} pat data, omadacId={}, siteId={}", new Object[]{deviceMac, omadacId, siteId});
                cachedPat = new RoamingApPat(reportedRoamingPat.getBandNum(), reportedRoamingPat.getBwNum(), reportedRoamingPat.getMcslevelNum(), deviceMac, reportedRoamingPat.getParams(), null);
            }
        } else if (reportedRoamingPat.getParams() != null) {
            cachedPat = new RoamingApPat(reportedRoamingPat.getBandNum(), reportedRoamingPat.getBwNum(), reportedRoamingPat.getMcslevelNum(), cachedPat.getMac(), reportedRoamingPat.getParams(), null);
        } else if ((cachedPat = this.d.a(cachedPat, reportedRoamingPat.getParamUp(), omadacId, siteId, deviceMac)) == null) {
            return;
        }
        this.c.a(omadacId, siteId, deviceMac, cachedPat);
        if (roamingInfo.getApNeighborTable() != null || roamingInfo.getApNeighborTableV2() != null) {
            return;
        }
        this.d.a(omadacId, siteId, deviceMac, cachedPat);
    }

    private void a(String omadacId, String siteId, String deviceMac, ReportedRoamingInfo roamingInfo, boolean aiRoamingEnable, boolean reportPat) {
        try {
            this.b(omadacId, siteId, deviceMac, roamingInfo, aiRoamingEnable, reportPat);
        }
        catch (Exception e2) {
            a.warn(e2.getMessage() + ", omadacId=" + omadacId + ", siteId=" + siteId, (Throwable)e2);
        }
    }

    private void b(String omadacId, String siteId, String deviceMac, ReportedRoamingInfo roamingInfo, boolean aiRoamingEnable, boolean reportPat) {
        RoamingCapability apCap = this.c.f(omadacId, siteId, deviceMac);
        ApImageDTO apImage = null;
        if (apCap == null) {
            DeviceQueryDTO queryDTO = DeviceQueryDTO.builder().omadacId(omadacId).mac(deviceMac).build();
            apImage = this.e.a(queryDTO);
            if (apImage == null || !apImage.getStatus().b()) {
                a.warn("Failed to handle inform event, {} not exist or not online, omadacId={}, siteId={}", new Object[]{deviceMac, omadacId, siteId});
                return;
            }
            apCap = new RoamingCapability(apImage);
            this.c.a(omadacId, siteId, deviceMac, apCap);
        }
        if (!CollectionUtils.isEmpty((Collection)roamingInfo.getApNeighborTableV2())) {
            long startTime = System.nanoTime();
            this.k.a(omadacId, siteId, deviceMac, roamingInfo.getApNeighborTableV2(), aiRoamingEnable, reportPat);
            this.h.a(System.nanoTime() - startTime, "handle_neighborlist_new");
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)roamingInfo.getApNeighborTable())) {
            long startTimeA = System.nanoTime();
            this.j.a(omadacId, siteId, deviceMac, roamingInfo.getApNeighborTable(), apImage, apCap, aiRoamingEnable);
            this.h.a(System.nanoTime() - startTimeA, "handle_neighborlist");
            return;
        }
        long startTimeB = System.nanoTime();
        this.j.a(omadacId, siteId, deviceMac, Boolean.TRUE.equals(apCap.getSupportRoamingV2()), Boolean.TRUE.equals(apCap.getSupportAiRoaming()), aiRoamingEnable, roamingInfo.getReportedProbeClientList());
        this.h.a(System.nanoTime() - startTimeB, "handle_probe_client");
    }

    public /* synthetic */ void handleEvent(@Nonnull Object object) {
        this.a((ApInformDomainEventDTO)object);
    }
}

