/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.port.eventcenter.a;

import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.device.manage.message.config.InformIntervalConfig;
import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.manager.device.api.internal.c.c.a.c;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.DeviceEventDTO;
import com.tplink.smb.omada.monitor.roaming.a.d;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingCapability;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteGetNeighborStatus;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteStatus;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteTime;
import com.tplink.smb.omada.monitor.roaming.port.cache.f;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a
implements DomainEventSubscriber<DeviceEventDTO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.internal.a b;
    @Autowired
    private d c;
    @Autowired
    private f d;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.c.c.a e;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a f;
    @Autowired
    @Qualifier(value="roamingWorkGroup")
    @Lazy
    private ExecutorService g;

    @PostConstruct
    private void a() {
        DomainEventBusHolder.getHandlerRegistry().register(DeviceEventDTO.class, (DomainEventSubscriber)this, this.g);
    }

    @Trace
    public void a(@Nonnull DeviceEventDTO deviceEventDTO) {
        a.debug("RoamingDeviceEventSubscriber received device event message from eventCenter:{}", (Object)deviceEventDTO);
        DeviceTypeEnum deviceType = DeviceTypeEnum.b((String)deviceEventDTO.getDeviceType());
        DeviceEventDTO.DeviceEventType eventType = DeviceEventDTO.DeviceEventType.resolve((String)deviceEventDTO.getEventType());
        if (!Objects.equals(DeviceTypeEnum.a, deviceType) || CollectionUtils.isEmpty((Collection)deviceEventDTO.getMacs()) || eventType == null) {
            return;
        }
        String omadacId = deviceEventDTO.getOmadacId();
        String siteId = deviceEventDTO.getSiteId();
        Long oldLastSeen = deviceEventDTO.getOldLastSeen();
        switch (eventType) {
            case ADOPT_SUCCESS: {
                RoamingSiteStatus roamingSiteStatus = this.c.a(omadacId, siteId);
                RoamingSiteTime roamingSiteTime = this.f.d(omadacId, siteId);
                if (roamingSiteStatus != null && Boolean.TRUE.equals(roamingSiteStatus.getRoamingEnable())) {
                    Map<String, RoamingCapability> roamingCapabilityMap = this.f.a(omadacId, siteId, deviceEventDTO.getMacs());
                    deviceEventDTO.getMacs().forEach(mac -> {
                        if (roamingCapabilityMap.get(mac) != null) {
                            RoamingCapability roamingCapability = (RoamingCapability)roamingCapabilityMap.get(mac);
                            this.d.b(omadacId, siteId, (String)mac);
                            a.debug("Roaming expire time clear omadacId:{}, siteId:{}, mac:{}.", new Object[]{omadacId, siteId, mac});
                            if (roamingSiteTime != null && Boolean.TRUE.equals(roamingSiteTime.getStable())) {
                                this.a(omadacId, (String)mac, roamingCapability);
                            }
                        }
                    });
                }
                if (Boolean.TRUE.equals(deviceEventDTO.getFirstAdopt())) {
                    this.a(omadacId, siteId);
                    break;
                }
                if (oldLastSeen == null || !this.a(oldLastSeen)) break;
                this.a(omadacId, siteId);
                break;
            }
            case DISCONNECTED: {
                deviceEventDTO.getMacs().forEach(mac -> this.d.a(omadacId, siteId, (String)mac));
                break;
            }
            case FORGET: 
            case MOVE_SITE: {
                a.debug("Roaming cache clear omadacId:{}, siteId:{}, macs:{}.", new Object[]{omadacId, siteId, deviceEventDTO.getMacs()});
                this.b.b(omadacId, siteId, deviceEventDTO.getMacs(), false);
                ((List)Optional.ofNullable(deviceEventDTO.getMacs()).orElse(new ArrayList())).forEach(mac -> this.d.b(omadacId, siteId, (String)mac));
                break;
            }
            case ISOLATED: 
            case REBOOT: 
            case POE_OFF: {
                break;
            }
            default: {
                a.error("unknown event type found, omadacId {}, siteId {}, event {}", new Object[]{omadacId, siteId, eventType.getKey()});
            }
        }
    }

    private void a(String omadacId, String mac, RoamingCapability roamingCapability) {
        if (roamingCapability != null && Boolean.TRUE.equals(roamingCapability.getSupportRoamingV2())) {
            return;
        }
        InformIntervalConfig issuedIntervalInfo = new InformIntervalConfig();
        issuedIntervalInfo.setRoamingInterval(Integer.valueOf(30));
        issuedIntervalInfo.setProbeClients(Integer.valueOf(8640));
        c deviceRequest = new c();
        deviceRequest.a(omadacId);
        deviceRequest.b(mac);
        deviceRequest.c(DeviceTypeEnum.a.b());
        HashMap<String, InformIntervalConfig> setMap = new HashMap<String, InformIntervalConfig>();
        setMap.put(ApSetKeyEnum.INTERVAL.key(), issuedIntervalInfo);
        deviceRequest.a(setMap);
        this.e.b(deviceRequest);
    }

    private boolean a(Long oldLastSeen) {
        long currentTime = System.currentTimeMillis();
        return currentTime - I.a((Long)oldLastSeen) > 1800000L;
    }

    private void a(String omadacId, String siteId) {
        RoamingSiteGetNeighborStatus getNeighborStatus = this.f.h(omadacId, siteId);
        if (getNeighborStatus != null && Boolean.TRUE.equals(getNeighborStatus.getReGetNeighbor())) {
            return;
        }
        getNeighborStatus = new RoamingSiteGetNeighborStatus();
        getNeighborStatus.setReGetNeighbor(true);
        this.f.a(omadacId, siteId, getNeighborStatus);
    }

    @Trace
    public /* synthetic */ void handleEvent(@Nonnull Object object) {
        this.a((DeviceEventDTO)object);
    }
}

