/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.port.cache.dto;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.google.common.collect.ImmutableList;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingRelatedAp;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@DefaultSerializer(value=CompatibleFieldSerializer.class)
@KeepClass
public class RoamingAp {
    private String mac;
    private String bssid;
    private List<RoamingRelatedAp> apList;
    private int regetNeighbor;

    public RoamingAp(String mac, String bssid, int regetNeighbor, List<RoamingRelatedAp> apList) {
        this.bssid = bssid;
        this.mac = mac;
        this.regetNeighbor = regetNeighbor;
        this.apList = apList;
    }

    public boolean isRegetingNeighbor() {
        return this.regetNeighbor > 0;
    }

    public List<RoamingRelatedAp> getApList() {
        return ImmutableList.copyOf(this.apList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoamingAp)) {
            return false;
        }
        RoamingAp roamingAp = (RoamingAp)o;
        return this.getRegetNeighbor() == roamingAp.getRegetNeighbor() && Objects.equals(this.getMac(), roamingAp.getMac()) && Objects.equals(this.getBssid(), roamingAp.getBssid()) && Objects.equals(this.getApList(), roamingAp.getApList());
    }

    public int hashCode() {
        return Objects.hash(this.getMac(), this.getBssid(), this.getApList(), this.getRegetNeighbor());
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getBssid() {
        return this.bssid;
    }

    @Generated
    public int getRegetNeighbor() {
        return this.regetNeighbor;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setBssid(String bssid) {
        this.bssid = bssid;
    }

    @Generated
    public void setApList(List<RoamingRelatedAp> apList) {
        this.apList = apList;
    }

    @Generated
    public void setRegetNeighbor(int regetNeighbor) {
        this.regetNeighbor = regetNeighbor;
    }

    @Generated
    public String toString() {
        return "RoamingAp(mac=" + this.getMac() + ", bssid=" + this.getBssid() + ", apList=" + this.getApList() + ", regetNeighbor=" + this.getRegetNeighbor() + ")";
    }

    @Generated
    public RoamingAp() {
    }
}

