/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.a;

import com.google.common.collect.Lists;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedApNeighborList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedApNeighborListList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingInfo;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingPat;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingPatList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingRelatedAp;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingRelatedApList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingSpec;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingSpecList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingSpecParam;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingSpecParamList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingTopo;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingTopoList;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedApNeighborList;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedProbeClient;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedRoamingRelatedAp;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QueryRoamingSettingDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.RoamingSettingDTO;
import com.tplink.smb.omada.manager.device.api.internal.c.c.a.c;
import com.tplink.smb.omada.manager.device.api.internal.device.request.a.g;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceQueryDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageCapabilityDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageStatusDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.status.UplinkInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.status.WirelessParamDTO;
import com.tplink.smb.omada.monitor.roaming.b.a;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingAp;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingApPat;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingCapability;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingRelatedAp;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingSiteStatus;
import com.tplink.smb.omada.monitor.roaming.port.eventcenter.dto.RoamingEventDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class d {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a b;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.manager.device.api.internal.device.a c;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.c.c.a d;
    @Autowired
    private LockService e;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a f;

    public boolean a(String omadacId, String siteId, String deviceMac) {
        if (T.a((String)omadacId) || T.a((String)siteId) || T.a((String)deviceMac)) {
            return false;
        }
        RoamingCapability apCap = this.b.f(omadacId, siteId, deviceMac);
        if (apCap == null) {
            DeviceQueryDTO queryDTO = DeviceQueryDTO.builder().omadacId(omadacId).mac(deviceMac).build();
            ApImageDTO apImage = this.c.a(queryDTO);
            if (apImage == null || !apImage.getStatus().b()) {
                return false;
            }
            apCap = new RoamingCapability(apImage);
            this.b.a(omadacId, siteId, deviceMac, apCap);
        }
        boolean supportRoaming = Boolean.TRUE.equals(apCap.getSupportRoaming());
        boolean supportAIRoaming = Boolean.TRUE.equals(apCap.getSupportAiRoaming());
        return supportRoaming && supportAIRoaming;
    }

    public void b(String omadacId, String siteId, String apMac) {
        if (T.a((String)omadacId) || T.a((String)siteId) || T.a((String)apMac)) {
            return;
        }
        RoamingCapability apCap = this.b.f(omadacId, siteId, apMac);
        if (apCap == null) {
            DeviceQueryDTO queryDTO = DeviceQueryDTO.builder().omadacId(omadacId).mac(apMac).build();
            ApImageDTO apImage = this.c.a(queryDTO);
            if (apImage == null || !apImage.getStatus().b()) {
                return;
            }
            apCap = new RoamingCapability(apImage);
            this.b.a(omadacId, siteId, apMac, apCap);
        }
        if (!Boolean.TRUE.equals(apCap.getSupportRoaming())) {
            return;
        }
        a.debug("issueApGetNeighbor: {}, omadacId={}", (Object)apMac, (Object)omadacId);
        c request = new c();
        request.a(omadacId);
        request.b(apMac);
        request.c(DeviceTypeEnum.a.b());
        HashMap<String, IssuedRoamingInfo> setMap = new HashMap<String, IssuedRoamingInfo>();
        IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
        issuedRoamingInfo.setRequestNeighbor(Integer.valueOf(1));
        setMap.put(ApSetKeyEnum.ROAMING_CMD.key(), issuedRoamingInfo);
        request.a(setMap);
        this.d.b(request);
    }

    public void a(String omadacId, String siteId, String apMac, RoamingAp roamingAp, boolean supportAiRoaming, boolean aiRoamingEnableBySite, boolean issueNow) {
        if (T.a((String)omadacId) || T.a((String)siteId) || T.a((String)apMac) || roamingAp == null) {
            return;
        }
        Set<String> neighborMacs = this.c(omadacId, siteId, apMac);
        neighborMacs.add(apMac);
        g apImageListRequest = g.a().a(omadacId).a((List)Lists.newArrayList(neighborMacs)).a();
        List apImages = (List)this.c.a(apImageListRequest).e();
        a.debug("Roaming ap neighbor list issued, ap mac : {}, omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
        IssuedApNeighborListList neighborLists = this.a(omadacId, siteId, apMac, new HashSet<ApImageDTO>(apImages), null);
        IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
        if (aiRoamingEnableBySite && supportAiRoaming) {
            Set<ApImageDTO> neighborAps = apImages.stream().filter(apImageDTO -> apImageDTO.getCapability() != null && Objects.equals(1, ((ApImageCapabilityDTO)apImageDTO.getCapability()).getSupportAIRoaming())).collect(Collectors.toSet());
            HashSet<String> oldNeighborMacSet = new HashSet<String>(neighborMacs.size() + 1);
            Map<String, RoamingApPat> roamingApPatMap = this.b.c(omadacId, siteId, neighborMacs);
            IssuedRoamingPatList neighborApPats = this.a(omadacId, siteId, neighborMacs, apMac, roamingApPatMap);
            for (IssuedRoamingPat pat : neighborApPats) {
                oldNeighborMacSet.add(pat.getMac());
            }
            this.b.a(omadacId, siteId, apMac, oldNeighborMacSet);
            IssuedRoamingSpecList neighborApSpecs = this.a(neighborAps);
            IssuedRoamingTopoList neighborApTopo = this.a(omadacId, apImages);
            issuedRoamingInfo.setTopos(neighborApTopo);
            issuedRoamingInfo.setSpecs(neighborApSpecs);
            issuedRoamingInfo.setPats(neighborApPats);
        }
        RoamingEventDTO roamingEvent = new RoamingEventDTO(omadacId, siteId, RoamingEventDTO.RoamingEventType.UNSTABLE);
        DomainEventBusHolder.getPublisher().publish((DomainEvent)roamingEvent);
        if (!CollectionUtils.isEmpty((Collection)neighborLists)) {
            c request = new c();
            request.a(omadacId);
            request.b(apMac);
            request.c(DeviceTypeEnum.a.b());
            HashMap<String, IssuedRoamingInfo> setMap = new HashMap<String, IssuedRoamingInfo>();
            issuedRoamingInfo.setApNeighborLists(neighborLists);
            setMap.put(ApSetKeyEnum.ROAMING_CMD.key(), issuedRoamingInfo);
            request.a(setMap);
            if (issueNow) {
                this.d.b(request);
                return;
            }
            this.b.a(omadacId, siteId, apMac, request);
        }
    }

    public void a(String omadacId, String siteId, Set<String> roamingApMacs) {
        roamingApMacs.forEach(apMac -> {
            c request = this.b.g(omadacId, siteId, (String)apMac);
            if (request != null) {
                this.d.b(request);
            }
        });
    }

    @Nonnull
    public IssuedApNeighborListList a(String omadacId, String siteId, String apMac, Set<ApImageDTO> apImages, @Nullable ApImageDTO issueApImage) {
        IssuedApNeighborListList neighborLists = new IssuedApNeighborListList();
        if (CollectionUtils.isEmpty(apImages)) {
            a.debug("no need to generateIssuedApNeighborLists, apImageList is empty, omadacId:{}, siteId:{}, apMac:{}", new Object[]{omadacId, siteId, apMac});
            return neighborLists;
        }
        Set<String> bssidList = this.b.d(omadacId, siteId, apMac);
        if (CollectionUtils.isEmpty(bssidList)) {
            a.debug("no need to generateIssuedApNeighborLists, bssidList is empty, omadacId:{}, siteId:{}, apMac:{}", new Object[]{omadacId, siteId, apMac});
            return neighborLists;
        }
        HashMap apBssidInfoMap = new HashMap();
        HashMap<String, ApImageDTO> apImageMap = new HashMap<String, ApImageDTO>();
        for (ApImageDTO apImageDTO : apImages) {
            if (Objects.isNull(apImageDTO)) continue;
            apImageMap.put(apImageDTO.getMac(), apImageDTO);
            if (Objects.isNull(apImageDTO.getDeviceStatus()) || CollectionUtils.isEmpty((Collection)((ApImageStatusDTO)apImageDTO.getDeviceStatus()).getBssidInfos())) continue;
            List apBssidInfoList = ((ApImageStatusDTO)apImageDTO.getDeviceStatus()).getBssidInfos();
            apBssidInfoList.forEach(apBssidInfo -> apBssidInfoMap.putIfAbsent(apBssidInfo.getBssid(), apBssidInfo.getRadioId()));
        }
        HashSet<RoamingAp> roamingAps = new HashSet<RoamingAp>();
        Map<String, RoamingAp> roamingApMap = this.b.a(omadacId, siteId, bssidList);
        boolean reportFreq = false;
        for (String bssid : bssidList) {
            RoamingAp roamingAp2;
            if (T.a((String)bssid) || (roamingAp2 = roamingApMap.get(bssid)) == null) continue;
            if (!reportFreq && roamingAp2.getApList().stream().anyMatch(roamingRelatedAp -> Objects.nonNull(roamingRelatedAp.getFrequency()))) {
                reportFreq = true;
            }
            roamingAps.add(roamingAp2);
        }
        ApImageDTO issueImageDTO = (ApImageDTO)apImageMap.get(apMac);
        if (issueImageDTO == null && issueApImage != null) {
            issueImageDTO = issueApImage;
        }
        boolean finalReportFreq = reportFreq;
        ApImageDTO finalApImageDTO = issueImageDTO;
        roamingAps.forEach(roamingAp -> {
            if (finalApImageDTO == null) {
                return;
            }
            IssuedApNeighborList issuedApNeighborList = new IssuedApNeighborList();
            issuedApNeighborList.setBssid(roamingAp.getBssid());
            List<RoamingRelatedAp> apList = roamingAp.getApList();
            if (CollectionUtils.isEmpty(apList)) {
                issuedApNeighborList.setApList(new IssuedRoamingRelatedApList());
                neighborLists.add((Object)issuedApNeighborList);
                return;
            }
            if (!com.tplink.smb.omada.monitor.roaming.b.a.a(finalApImageDTO) && !finalReportFreq) {
                apList = apList.stream().filter(rra -> rra.getChannel() > 0).collect(Collectors.toList());
            }
            IssuedRoamingRelatedApList roamingRelatedApLists = this.a(apList, apImageMap, apBssidInfoMap);
            issuedApNeighborList.setApList(roamingRelatedApLists);
            neighborLists.add((Object)issuedApNeighborList);
        });
        return neighborLists;
    }

    @Nonnull
    private IssuedRoamingRelatedApList a(@Nonnull List<RoamingRelatedAp> apList, Map<String, ApImageDTO> apImageMap, Map<String, Integer> apBssidInfoMap) {
        IssuedRoamingRelatedApList roamingRelatedApLists = new IssuedRoamingRelatedApList();
        for (RoamingRelatedAp rra : apList) {
            ApImageDTO apImage;
            if (rra == null || (apImage = apImageMap.get(rra.getMac())) == null) continue;
            IssuedRoamingRelatedAp issuedRoamingRelatedAp = new IssuedRoamingRelatedAp();
            issuedRoamingRelatedAp.setBssid(rra.getBssid());
            issuedRoamingRelatedAp.setMac(rra.getMac());
            issuedRoamingRelatedAp.setChannel(rra.getChannel());
            issuedRoamingRelatedAp.setFrequency(rra.getFrequency());
            issuedRoamingRelatedAp.setRid(apBssidInfoMap.getOrDefault(rra.getBssid(), -1));
            Integer connectedHop = Optional.ofNullable((ApImageStatusDTO)apImage.getDeviceStatus()).map(ApImageStatusDTO::getConnectedHop).orElse(0);
            issuedRoamingRelatedAp.setHop(connectedHop);
            roamingRelatedApLists.add((Object)issuedRoamingRelatedAp);
        }
        return roamingRelatedApLists;
    }

    @Nonnull
    public IssuedRoamingPatList a(String omadacId, String siteId, Set<String> neighborMacs, String centerApMac, Map<String, RoamingApPat> roamingApPatMap) {
        if (CollectionUtils.isEmpty(neighborMacs) || T.a((String)centerApMac)) {
            return new IssuedRoamingPatList();
        }
        neighborMacs.add(centerApMac);
        IssuedRoamingPatList issuedRoamingPats = new IssuedRoamingPatList();
        RoamingApPat centerApPat = roamingApPatMap.get(centerApMac);
        if (centerApPat == null) {
            return new IssuedRoamingPatList();
        }
        for (String neighborApMac : neighborMacs) {
            if (issuedRoamingPats.size() >= 12) break;
            IssuedRoamingPat issuedRoamingPat = new IssuedRoamingPat();
            RoamingApPat roamingApPat = roamingApPatMap.get(neighborApMac);
            if (roamingApPat == null) {
                a.debug("roaming ap {} pat stat is null, not issued, omadacId={}, siteId={}", new Object[]{neighborApMac, omadacId, siteId});
                continue;
            }
            issuedRoamingPat.setMac(neighborApMac);
            issuedRoamingPat.setBandNum(roamingApPat.getBandNum());
            issuedRoamingPat.setBwNum(roamingApPat.getBwNum());
            issuedRoamingPat.setMcslevelNum(roamingApPat.getMcslevelNum());
            issuedRoamingPat.setParams(com.tplink.smb.omada.monitor.roaming.b.a.a(roamingApPat, centerApPat.getBandNum(), centerApPat.getBwNum(), centerApPat.getMcslevelNum()));
            issuedRoamingPats.add((Object)issuedRoamingPat);
        }
        return issuedRoamingPats;
    }

    @Nonnull
    public IssuedRoamingSpecList a(Set<ApImageDTO> neighborAps) {
        if (CollectionUtils.isEmpty(neighborAps)) {
            return new IssuedRoamingSpecList();
        }
        IssuedRoamingSpecList issuedRoamingSpecs = new IssuedRoamingSpecList();
        for (ApImageDTO neighborAp : neighborAps) {
            WirelessParamDTO wp6g;
            WirelessParamDTO wp5g2;
            WirelessParamDTO wp5g;
            if (neighborAp == null || neighborAp.getCapability() == null || I.a((Integer)((ApImageCapabilityDTO)neighborAp.getCapability()).getSupportAIRoaming()) < 1) continue;
            IssuedRoamingSpec roamingApSpec = new IssuedRoamingSpec();
            roamingApSpec.setMac(neighborAp.getMac());
            IssuedRoamingSpecParamList params = new IssuedRoamingSpecParamList();
            WirelessParamDTO wp2g = ((ApImageStatusDTO)neighborAp.getDeviceStatus()).getWp2g();
            if (wp2g != null) {
                IssuedRoamingSpecParam roamingSpecParam = new IssuedRoamingSpecParam();
                roamingSpecParam.setRid(Integer.valueOf(0));
                roamingSpecParam.setBandwidth(com.tplink.smb.omada.monitor.roaming.b.a.a(wp2g.getBandWidth(), a.a.a));
                roamingSpecParam.setMcs(com.tplink.smb.omada.monitor.roaming.b.a.a(wp2g.getRdMode()));
                roamingSpecParam.setMimo(((ApImageCapabilityDTO)neighborAp.getCapability()).getMimo2g());
                params.add((Object)roamingSpecParam);
            }
            if ((wp5g = ((ApImageStatusDTO)neighborAp.getDeviceStatus()).getWp5g()) != null) {
                IssuedRoamingSpecParam roamingSpecParam = new IssuedRoamingSpecParam();
                roamingSpecParam.setRid(Integer.valueOf(1));
                roamingSpecParam.setBandwidth(com.tplink.smb.omada.monitor.roaming.b.a.a(wp5g.getBandWidth(), a.a.b));
                roamingSpecParam.setMcs(com.tplink.smb.omada.monitor.roaming.b.a.a(wp5g.getRdMode()));
                roamingSpecParam.setMimo(((ApImageCapabilityDTO)neighborAp.getCapability()).getMimo5g());
                params.add((Object)roamingSpecParam);
            }
            if ((wp5g2 = ((ApImageStatusDTO)neighborAp.getDeviceStatus()).getWp5g2()) != null) {
                IssuedRoamingSpecParam roamingSpecParam = new IssuedRoamingSpecParam();
                roamingSpecParam.setRid(Integer.valueOf(2));
                roamingSpecParam.setBandwidth(com.tplink.smb.omada.monitor.roaming.b.a.a(wp5g2.getBandWidth(), a.a.c));
                roamingSpecParam.setMcs(com.tplink.smb.omada.monitor.roaming.b.a.a(wp5g2.getRdMode()));
                roamingSpecParam.setMimo(((ApImageCapabilityDTO)neighborAp.getCapability()).getMimo5g2());
                params.add((Object)roamingSpecParam);
            }
            if ((wp6g = ((ApImageStatusDTO)neighborAp.getDeviceStatus()).getWp6g()) != null) {
                IssuedRoamingSpecParam roamingSpecParam = new IssuedRoamingSpecParam();
                roamingSpecParam.setRid(Integer.valueOf(3));
                roamingSpecParam.setBandwidth(com.tplink.smb.omada.monitor.roaming.b.a.a(wp6g.getBandWidth(), a.a.d));
                roamingSpecParam.setMcs(com.tplink.smb.omada.monitor.roaming.b.a.a(wp6g.getRdMode()));
                roamingSpecParam.setMimo(((ApImageCapabilityDTO)neighborAp.getCapability()).getMimo6g());
                params.add((Object)roamingSpecParam);
            }
            roamingApSpec.setParam(params);
            issuedRoamingSpecs.add((Object)roamingApSpec);
            if (issuedRoamingSpecs.size() < 12) continue;
            break;
        }
        return issuedRoamingSpecs;
    }

    public IssuedRoamingTopoList a(String omadacId, Set<String> neighborApMacs) {
        IssuedRoamingTopoList issuedRoamingTopos = new IssuedRoamingTopoList();
        if (T.a((String)omadacId) || CollectionUtils.isEmpty(neighborApMacs)) {
            return issuedRoamingTopos;
        }
        g request = g.a().a(omadacId).a(new ArrayList<String>(neighborApMacs)).a();
        List apList = (List)this.c.a(request).e();
        if (CollectionUtils.isEmpty((Collection)apList)) {
            return issuedRoamingTopos;
        }
        Map<String, ApImageDTO> apMap = apList.stream().collect(Collectors.toMap(DeviceImageDTO::getMac, Function.identity()));
        for (String neighborApMac : neighborApMacs) {
            ApImageDTO apImage = (ApImageDTO)apMap.get(neighborApMac);
            if (apImage == null) {
                a.debug("ap image {} is null, omadacId={}", (Object)neighborApMac, (Object)omadacId);
                continue;
            }
            this.a(omadacId, neighborApMac, (List<IssuedRoamingTopo>)issuedRoamingTopos, apImage, apMap);
        }
        ListIterator each = issuedRoamingTopos.listIterator();
        HashSet<String> macs = new HashSet<String>(issuedRoamingTopos.size());
        while (each.hasNext()) {
            IssuedRoamingTopo issuedRoamingTopo = (IssuedRoamingTopo)each.next();
            if (macs.contains(issuedRoamingTopo.getMac())) {
                each.remove();
                continue;
            }
            macs.add(issuedRoamingTopo.getMac());
        }
        IssuedRoamingTopoList result = new IssuedRoamingTopoList();
        result.addAll((Collection)issuedRoamingTopos.subList(0, Math.min(issuedRoamingTopos.size(), 48)));
        return result;
    }

    public IssuedRoamingTopoList a(String omadacId, List<ApImageDTO> neighborApImages) {
        IssuedRoamingTopoList issuedRoamingTopos = new IssuedRoamingTopoList();
        if (T.a((String)omadacId) || CollectionUtils.isEmpty(neighborApImages)) {
            return issuedRoamingTopos;
        }
        Map<String, ApImageDTO> apMap = neighborApImages.stream().collect(Collectors.toMap(DeviceImageDTO::getMac, Function.identity()));
        for (ApImageDTO apImage : neighborApImages) {
            this.a(omadacId, apImage.getMac(), (List<IssuedRoamingTopo>)issuedRoamingTopos, apImage, apMap);
        }
        ListIterator each = issuedRoamingTopos.listIterator();
        HashSet<String> macs = new HashSet<String>(issuedRoamingTopos.size());
        while (each.hasNext()) {
            IssuedRoamingTopo issuedRoamingTopo = (IssuedRoamingTopo)each.next();
            if (macs.contains(issuedRoamingTopo.getMac())) {
                each.remove();
                continue;
            }
            macs.add(issuedRoamingTopo.getMac());
        }
        IssuedRoamingTopoList result = new IssuedRoamingTopoList();
        result.addAll((Collection)issuedRoamingTopos.subList(0, Math.min(issuedRoamingTopos.size(), 48)));
        return result;
    }

    private void a(String omadacId, String apMac, List<IssuedRoamingTopo> topos, @Nullable ApImageDTO apImage, @Nonnull Map<String, ApImageDTO> mac2ApImageMap) {
        if (T.a((String)omadacId) || T.a((String)apMac)) {
            return;
        }
        if (apImage == null) {
            apImage = mac2ApImageMap.get(apMac);
        }
        if (Objects.isNull(apImage)) {
            DeviceQueryDTO queryDTO = DeviceQueryDTO.builder().omadacId(omadacId).mac(apMac).build();
            apImage = this.c.a(queryDTO);
            if (apImage == null) {
                a.debug("ap image {} is null, roaming spec is null, omadacId={}", (Object)apMac, (Object)omadacId);
                return;
            }
            mac2ApImageMap.put(apMac, apImage);
        }
        IssuedRoamingTopo issuedRoamingTopo = new IssuedRoamingTopo();
        issuedRoamingTopo.setMac(apImage.getMac());
        Integer[] offset = new Integer[]{0, 0, 0, 0};
        WirelessParamDTO wp2g = ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp2g();
        issuedRoamingTopo.setChUti2g(Optional.ofNullable(wp2g).map(wp -> this.a(wp.getBusyUtil(), wp.getTxUtil(), wp.getRxUtil(), wp.getInterUtil())).orElse(0));
        WirelessParamDTO wp5g = ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g();
        issuedRoamingTopo.setChUti5g(Optional.ofNullable(wp5g).map(wp -> this.a(wp.getBusyUtil(), wp.getTxUtil(), wp.getRxUtil(), wp.getInterUtil())).orElse(0));
        WirelessParamDTO wp5g2 = ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g2();
        issuedRoamingTopo.setChUti5g2(Optional.ofNullable(wp5g2).map(wp -> this.a(wp.getBusyUtil(), wp.getTxUtil(), wp.getRxUtil(), wp.getInterUtil())).orElse(0));
        WirelessParamDTO wp6g = ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp6g();
        issuedRoamingTopo.setChUti6g(Optional.ofNullable(wp6g).map(wp -> this.a(wp.getBusyUtil(), wp.getTxUtil(), wp.getRxUtil(), wp.getInterUtil())).orElse(0));
        if (wp2g != null) {
            offset[0] = wp2g.getAiRoamingOffset() == null ? 0 : wp2g.getAiRoamingOffset();
        }
        if (wp5g != null) {
            offset[1] = wp5g.getAiRoamingOffset() == null ? 0 : wp5g.getAiRoamingOffset();
        }
        if (wp5g2 != null) {
            offset[2] = wp5g2.getAiRoamingOffset() == null ? 0 : wp5g2.getAiRoamingOffset();
        }
        if (wp6g != null) {
            offset[3] = wp6g.getAiRoamingOffset() == null ? 0 : wp6g.getAiRoamingOffset();
        }
        issuedRoamingTopo.setOffset(offset);
        UplinkInfoDTO upLinkInfo = ((ApImageStatusDTO)apImage.getDeviceStatus()).getUplinkInfo();
        if (Objects.equals(Boolean.TRUE, ((ApImageStatusDTO)apImage.getDeviceStatus()).isWirelessLinked()) && upLinkInfo != null) {
            this.a(omadacId, upLinkInfo.getMac(), topos, null, mac2ApImageMap);
            this.a(issuedRoamingTopo, upLinkInfo);
        } else {
            this.a(issuedRoamingTopo, apImage);
        }
        topos.add(issuedRoamingTopo);
    }

    private int a(Integer busyUtil, Integer txUtil, Integer rxUtil, Integer interUtil) {
        if (busyUtil != null) {
            return busyUtil;
        }
        if (txUtil != null && rxUtil != null && interUtil != null) {
            return txUtil + rxUtil + interUtil;
        }
        a.debug("Radid busy util does not exist, return 0.");
        return 0;
    }

    private void a(@Nonnull IssuedRoamingTopo issuedRoamingTopo, @Nonnull UplinkInfoDTO upLinkInfo) {
        issuedRoamingTopo.setPmac(upLinkInfo.getMac());
        issuedRoamingTopo.setRxR2g(Integer.valueOf(0));
        issuedRoamingTopo.setTxR2g(Integer.valueOf(0));
        issuedRoamingTopo.setRxR5g(Integer.valueOf(Objects.equals(upLinkInfo.getParentRadioId(), 1) ? com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getRxRate()) : 0));
        issuedRoamingTopo.setTxR5g(Integer.valueOf(Objects.equals(upLinkInfo.getParentRadioId(), 1) ? com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getTxRate()) : 0));
        issuedRoamingTopo.setRxR5g2(Integer.valueOf(Objects.equals(upLinkInfo.getParentRadioId(), 2) ? com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getRxRate()) : 0));
        issuedRoamingTopo.setTxR5g2(Integer.valueOf(Objects.equals(upLinkInfo.getParentRadioId(), 2) ? com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getTxRate()) : 0));
        issuedRoamingTopo.setRxR6g(Integer.valueOf(Objects.equals(upLinkInfo.getParentRadioId(), 3) ? com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getRxRate()) : 0));
        issuedRoamingTopo.setTxR6g(Integer.valueOf(Objects.equals(upLinkInfo.getParentRadioId(), 3) ? com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getTxRate()) : 0));
        issuedRoamingTopo.setEthR(Integer.valueOf(0));
        issuedRoamingTopo.setEthUti(Integer.valueOf(0));
        if (Objects.isNull(upLinkInfo.getParentRadioId())) {
            issuedRoamingTopo.setRxR5g(com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getRxRate()));
            issuedRoamingTopo.setTxR5g(com.tplink.smb.omada.monitor.roaming.b.a.b(upLinkInfo.getTxRate()));
        }
    }

    private void a(@Nonnull IssuedRoamingTopo issuedRoamingTopo, @Nonnull ApImageDTO apImage) {
        issuedRoamingTopo.setPmac("00-00-00-00-00-00");
        issuedRoamingTopo.setRxR2g(Integer.valueOf(0));
        issuedRoamingTopo.setTxR2g(Integer.valueOf(0));
        issuedRoamingTopo.setRxR5g(Integer.valueOf(0));
        issuedRoamingTopo.setTxR5g(Integer.valueOf(0));
        issuedRoamingTopo.setRxR5g2(Integer.valueOf(0));
        issuedRoamingTopo.setTxR5g2(Integer.valueOf(0));
        issuedRoamingTopo.setRxR6g(Integer.valueOf(0));
        issuedRoamingTopo.setTxR6g(Integer.valueOf(0));
        if (((ApImageStatusDTO)apImage.getDeviceStatus()).getLanTraffic() == null || ((ApImageStatusDTO)apImage.getDeviceStatus()).getLanInfo() == null) {
            issuedRoamingTopo.setEthUti(Integer.valueOf(0));
            issuedRoamingTopo.setEthR(Integer.valueOf(0));
            return;
        }
        if (((ApImageStatusDTO)apImage.getDeviceStatus()).getLanTraffic().getNetworkUtil() == null) {
            issuedRoamingTopo.setEthUti(Integer.valueOf(0));
        } else {
            issuedRoamingTopo.setEthUti(((ApImageStatusDTO)apImage.getDeviceStatus()).getLanTraffic().getNetworkUtil());
        }
        if (Objects.equals(((ApImageStatusDTO)apImage.getDeviceStatus()).getLanInfo().getDuplex(), 1)) {
            issuedRoamingTopo.setEthR(Integer.valueOf(Integer.parseInt(((ApImageStatusDTO)apImage.getDeviceStatus()).getLanInfo().getRate())));
        } else if (Objects.equals(((ApImageStatusDTO)apImage.getDeviceStatus()).getLanInfo().getDuplex(), 2)) {
            issuedRoamingTopo.setEthR(Integer.valueOf(Integer.parseInt(((ApImageStatusDTO)apImage.getDeviceStatus()).getLanInfo().getRate()) * 2));
        } else {
            issuedRoamingTopo.setEthR(Integer.valueOf(0));
        }
    }

    public void a(String omadacId, String siteId, String mac, RoamingApPat roamingApPat) {
        a.debug("start issueNeighborApPat, omadacId:{}, siteId:{}, mac:{}, roamingApPat:{}", new Object[]{omadacId, siteId, mac, roamingApPat});
        if (roamingApPat == null) {
            a.debug("Roaming ap {} pat stat is null, omadacId={}, siteId={}", new Object[]{mac, omadacId, siteId});
            return;
        }
        Set<String> neighborMacs = this.d(omadacId, siteId, mac);
        neighborMacs.add(mac);
        if (CollectionUtils.isEmpty(neighborMacs)) {
            return;
        }
        Map<String, RoamingApPat> roamingApPatMap = this.b.c(omadacId, siteId, neighborMacs);
        for (String neighborApMac : neighborMacs) {
            RoamingApPat neighborApPat;
            if (!this.a(omadacId, siteId, neighborApMac) || (neighborApPat = roamingApPatMap.get(neighborApMac)) == null) continue;
            Set<String> oldNeighborMacs = this.b.b(omadacId, siteId, neighborApMac);
            IssuedRoamingPatList issuedRoamingPats = new IssuedRoamingPatList();
            IssuedRoamingPat issuedRoamingPat = new IssuedRoamingPat();
            issuedRoamingPat.setMac(mac);
            issuedRoamingPat.setBandNum(roamingApPat.getBandNum());
            issuedRoamingPat.setBwNum(roamingApPat.getBwNum());
            issuedRoamingPat.setMcslevelNum(roamingApPat.getMcslevelNum());
            if (roamingApPat.getParamUp() != null && oldNeighborMacs.contains(neighborApMac)) {
                issuedRoamingPat.setParamUp(com.tplink.smb.omada.monitor.roaming.b.a.b(roamingApPat, neighborApPat.getBandNum(), neighborApPat.getBwNum(), neighborApPat.getMcslevelNum()));
                issuedRoamingPats.add((Object)issuedRoamingPat);
            } else {
                issuedRoamingPat.setParams(com.tplink.smb.omada.monitor.roaming.b.a.a(roamingApPat, neighborApPat.getBandNum(), neighborApPat.getBwNum(), neighborApPat.getMcslevelNum()));
                issuedRoamingPats.add((Object)issuedRoamingPat);
            }
            c request = new c();
            request.a(omadacId);
            request.b(neighborApMac);
            request.c(DeviceTypeEnum.a.b());
            HashMap<String, IssuedRoamingInfo> setMap = new HashMap<String, IssuedRoamingInfo>();
            IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
            issuedRoamingInfo.setPats(issuedRoamingPats);
            setMap.put(ApSetKeyEnum.ROAMING_CMD.key(), issuedRoamingInfo);
            request.a(setMap);
            this.d.b(request);
            oldNeighborMacs.add(mac);
            this.b.a(omadacId, siteId, neighborApMac, oldNeighborMacs);
        }
    }

    @Nonnull
    public RoamingAp a(@Nonnull ReportedApNeighborList reportedApNeighborList, String mac) {
        if (CollectionUtils.isEmpty((Collection)reportedApNeighborList.getApList())) {
            return new RoamingAp(mac, reportedApNeighborList.getBssid(), 0, new ArrayList<RoamingRelatedAp>());
        }
        ArrayList<RoamingRelatedAp> apList = new ArrayList<RoamingRelatedAp>();
        for (ReportedRoamingRelatedAp reportedRoamingRelatedAp : reportedApNeighborList.getApList()) {
            String bssid = reportedRoamingRelatedAp.getBssid();
            Integer channel = reportedRoamingRelatedAp.getChannel();
            Integer frequency = reportedRoamingRelatedAp.getFrequency();
            RoamingRelatedAp roamingRelatedAp = new RoamingRelatedAp(null, bssid, (int)channel, frequency);
            apList.add(roamingRelatedAp);
        }
        return new RoamingAp(mac, reportedApNeighborList.getBssid(), 0, apList);
    }

    @Nullable
    public RoamingRelatedAp a(@Nonnull RoamingAp neighborRoamingAp, RoamingRelatedAp centerAp, List<RoamingRelatedAp> newApList) {
        if (CollectionUtils.isEmpty(neighborRoamingAp.getApList())) {
            return null;
        }
        for (RoamingRelatedAp existAp : neighborRoamingAp.getApList()) {
            if (!Objects.equals(existAp.getBssid(), centerAp.getBssid())) continue;
            newApList.remove(existAp);
            return existAp;
        }
        return null;
    }

    @Nullable
    public RoamingRelatedAp a(String deviceMac, @Nonnull ReportedProbeClient probeClient) {
        if (probeClient.getChannel() != null) {
            return new RoamingRelatedAp(deviceMac, probeClient.getBssid(), (int)probeClient.getChannel(), probeClient.getFreq());
        }
        a.warn("Reported probe client channel is null, ap mac {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
        return null;
    }

    @Nonnull
    public Map<String, RoamingRelatedAp> a(RoamingRelatedAp centerAp, List<RoamingRelatedAp> allApList) {
        if (CollectionUtils.isEmpty(allApList)) {
            return new HashMap<String, RoamingRelatedAp>();
        }
        List macList = allApList.stream().map(RoamingRelatedAp::getMac).collect(Collectors.toList());
        macList.add(centerAp.getMac());
        HashMap<String, RoamingRelatedAp> relatedApMap = new HashMap<String, RoamingRelatedAp>(allApList.size());
        for (RoamingRelatedAp roamingRelatedAp : allApList) {
            if (com.tplink.smb.omada.monitor.roaming.b.a.c(centerAp, roamingRelatedAp) || Math.abs(centerAp.getRecvTime() - roamingRelatedAp.getRecvTime()) > 40L) continue;
            relatedApMap.put(roamingRelatedAp.getBssid(), roamingRelatedAp);
        }
        return relatedApMap;
    }

    public Set<String> c(String omadacId, String siteId, String mac) {
        if (T.a((String)omadacId) || T.a((String)siteId) || T.a((String)mac)) {
            return new HashSet<String>();
        }
        Set<String> apBssidSet = this.b.d(omadacId, siteId, mac);
        Map<String, RoamingAp> roamingApMap = this.b.a(omadacId, siteId, apBssidSet);
        return roamingApMap.values().stream().filter(Objects::nonNull).filter(roamingAp -> !CollectionUtils.isEmpty(roamingAp.getApList())).flatMap(roamingAp -> roamingAp.getApList().stream()).filter(Objects::nonNull).map(RoamingRelatedAp::getMac).filter(T::b).collect(Collectors.toSet());
    }

    private Set<String> d(String omadacId, String siteId, String mac) {
        if (T.a((String)omadacId) || T.a((String)siteId) || T.a((String)mac)) {
            return new HashSet<String>();
        }
        return this.b.a(omadacId, siteId).stream().filter(Objects::nonNull).map(RoamingAp.class::cast).filter(roamingAp -> !CollectionUtils.isEmpty(roamingAp.getApList())).filter(roamingAp -> roamingAp.getApList().stream().anyMatch(relatedAp -> Objects.equals(mac, relatedAp.getMac()))).map(RoamingAp::getMac).collect(Collectors.toSet());
    }

    public Set<String> b(String omadacId, String siteId, Set<String> bssids) {
        if (T.a((String)omadacId) || T.a((String)siteId) || CollectionUtils.isEmpty(bssids)) {
            return Collections.emptySet();
        }
        HashSet<String> bssidSet = new HashSet<String>();
        this.b.a(omadacId, siteId).stream().filter(Objects::nonNull).map(RoamingAp.class::cast).filter(roamingAp -> !CollectionUtils.isEmpty(roamingAp.getApList())).forEach(roamingAp -> {
            for (RoamingRelatedAp roamingRelatedAp : roamingAp.getApList()) {
                if (!bssids.contains(roamingRelatedAp.getBssid())) continue;
                bssidSet.add(roamingAp.getBssid());
                return;
            }
        });
        return bssidSet;
    }

    public RoamingSiteStatus a(String omadacId, String siteId) {
        RoamingSiteStatus cacheSiteStatus = this.b.f(omadacId, siteId);
        if (cacheSiteStatus != null) {
            return cacheSiteStatus;
        }
        return (RoamingSiteStatus)this.e.doWithTryLock("monitor:roaming:site.status", (Object)String.join((CharSequence)":", omadacId, siteId), 1L, TimeUnit.SECONDS, () -> {
            QueryRoamingSettingDTO query = new QueryRoamingSettingDTO(omadacId, siteId);
            RoamingSettingDTO roamingSetting = this.f.a(query).orElse(null);
            RoamingSiteStatus roamingSiteStatus = new RoamingSiteStatus(false, false, false);
            if (roamingSetting != null) {
                roamingSiteStatus.setRoamingEnable(roamingSetting.getFastRoamingEnable());
                roamingSiteStatus.setAiRoamingEnable(roamingSetting.getAiRoamingEnable());
                roamingSiteStatus.setNonPingPongRoamingEnable(roamingSetting.getNonPingPongRoamingEnable());
            }
            this.b.a(omadacId, siteId, roamingSiteStatus);
            return roamingSiteStatus;
        }, () -> {
            a.info("Failed to get roaming site status lock of omadac:{}, siteId:{}.", (Object)omadacId, (Object)siteId);
            return new RoamingSiteStatus(false, false, false);
        });
    }

    public RoamingApPat a(@Nonnull RoamingApPat oldPat, @Nonnull List<List<Integer>> paramUp, String omadacId, String siteId, String deviceMac) {
        List<Integer> params = oldPat.getParams();
        int patCapability = oldPat.getBandNum() * oldPat.getMcslevelNum() * oldPat.getBwNum();
        boolean needUpdate = false;
        for (List<Integer> changeParamUp : paramUp) {
            Integer oldValue;
            if (changeParamUp.size() < 2) continue;
            Integer changeIndex = changeParamUp.get(0);
            Integer newValue = changeParamUp.get(1);
            if (changeIndex == null || changeIndex < 0 || changeIndex >= params.size() || !com.tplink.smb.omada.monitor.roaming.b.a.a(patCapability, oldValue = params.get(changeIndex), changeIndex, newValue)) continue;
            needUpdate = true;
            params.set(changeIndex, newValue);
        }
        if (needUpdate) {
            return new RoamingApPat(oldPat.getBandNum(), oldPat.getBwNum(), oldPat.getMcslevelNum(), oldPat.getMac(), params, paramUp);
        }
        a.debug("no need to update roaming pat, omadacId:{}, siteId:{}, mac:{}, paramUp:{}, oldPat:{}", new Object[]{omadacId, siteId, deviceMac, paramUp, oldPat});
        return null;
    }
}

