/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.a;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedApNeighborListList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingInfo;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingPat;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingPatList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingSpecList;
import com.tplink.smb.omada.device.manage.message.config.ap.roaming.IssuedRoamingTopoList;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedApNeighborList;
import com.tplink.smb.omada.manager.device.api.internal.device.request.a.g;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageCapabilityDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageDTO;
import com.tplink.smb.omada.monitor.roaming.a.d;
import com.tplink.smb.omada.monitor.roaming.b.a;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingAp;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingApPat;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingRelatedAp;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a b;
    @Autowired
    private d c;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.a d;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.c.c.a e;

    public void a(String omadacId, String siteId, String deviceMac, List<ReportedApNeighborList> apNeighborTable, boolean aiRoamingEnableBySite, boolean reportPat) {
        a.debug("Received AP new neighborV2 list from mac:{}, omadacId:{}, siteId:{}.", new Object[]{deviceMac, omadacId, siteId});
        HashSet issuedRoamingApMacs = Sets.newHashSet((Object[])new String[]{deviceMac});
        HashSet<String> apReportBssidSet = new HashSet<String>();
        boolean apReportFullNeighbor = false;
        apNeighborTable = apNeighborTable.stream().filter(reportedApNeighborList -> {
            if (T.a((String)reportedApNeighborList.getBssid())) {
                a.warn("Reported AP BSSID is null and illegal, ap mac:{}, omadacId:{}, siteId:{}.", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), omadacId, siteId});
                return false;
            }
            apReportBssidSet.add(reportedApNeighborList.getBssid());
            if (reportedApNeighborList.getFreq() == null) {
                a.warn("Reported AP BSSID freq is null, no need to handle, ap mac:{}, omadacId:{}, siteId:{}.", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), omadacId, siteId});
                return false;
            }
            if (CollectionUtils.isEmpty((Collection)reportedApNeighborList.getApList())) {
                a.debug("NeighborList of reported AP BSSID is not changed, no need to handle, ap mac:{}, bssid:{}, omadacId:{}, siteId:{}.", new Object[]{deviceMac, reportedApNeighborList.getBssid(), omadacId, siteId});
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (Objects.equals(apReportBssidSet.size(), apNeighborTable.size())) {
            apReportFullNeighbor = true;
        }
        Set<String> oldApBssidSet = this.b.d(omadacId, siteId, deviceMac);
        this.b.b(omadacId, siteId, deviceMac, apReportBssidSet);
        for (ReportedApNeighborList reportedApNeighborList2 : apNeighborTable) {
            RoamingAp newRoamingAp = this.c.a(reportedApNeighborList2, deviceMac);
            Set<String> reportNeighborApBssidSet = newRoamingAp.getApList().stream().map(RoamingRelatedAp::getBssid).collect(Collectors.toSet());
            Map<String, RoamingAp> neighborApBssidRoamingApMap = this.b.a(omadacId, siteId, reportNeighborApBssidSet);
            newRoamingAp = this.a(omadacId, siteId, newRoamingAp, neighborApBssidRoamingApMap);
            RoamingRelatedAp centerRoamingAp = new RoamingRelatedAp(deviceMac, newRoamingAp.getBssid(), (int)reportedApNeighborList2.getCh(), reportedApNeighborList2.getFreq());
            issuedRoamingApMacs.addAll(this.a(omadacId, siteId, centerRoamingAp, newRoamingAp, neighborApBssidRoamingApMap));
        }
        this.a(omadacId, siteId, oldApBssidSet, apReportBssidSet);
        this.a(omadacId, siteId, issuedRoamingApMacs, aiRoamingEnableBySite, deviceMac, reportPat, apReportFullNeighbor);
    }

    private Set<String> a(String omadacId, String siteId, RoamingRelatedAp centerAp, RoamingAp newRoamingAp, Map<String, RoamingAp> neighborApBssidRoamingApMap) {
        if (newRoamingAp == null) {
            return Collections.emptySet();
        }
        String bssidKey = newRoamingAp.getBssid();
        RoamingAp oldRoamingAp = this.b.a(omadacId, siteId, bssidKey);
        if (Objects.equals(oldRoamingAp, newRoamingAp)) {
            return Collections.emptySet();
        }
        this.b.a(omadacId, siteId, newRoamingAp.getBssid(), newRoamingAp);
        a.debug("replaceApNeighborListV2 issue: Center AP:{} neighbor list is changed, new neighborList:{}, omadacId:{}, siteId:{}", new Object[]{centerAp.getMac(), newRoamingAp, omadacId, siteId});
        Set<String> relatedBssidList = com.tplink.smb.omada.monitor.roaming.b.a.a(newRoamingAp);
        Set<String> neighborApMacSet = this.a(omadacId, siteId, centerAp, relatedBssidList, neighborApBssidRoamingApMap);
        neighborApMacSet.add(newRoamingAp.getMac());
        neighborApMacSet.add(centerAp.getMac());
        return neighborApMacSet;
    }

    private Set<String> a(String omadacId, String siteId, RoamingRelatedAp centerAp, Set<String> relatedBssidList, Map<String, RoamingAp> neighborApBssidRoamingApMap) {
        if (CollectionUtils.isEmpty(relatedBssidList)) {
            return Sets.newHashSet((Object[])new String[]{centerAp.getMac()});
        }
        HashSet roamingRelatedApMacs = Sets.newHashSet((Object[])new String[]{centerAp.getMac()});
        for (String relatedBssid : relatedBssidList) {
            String neighborApMac = this.a(omadacId, siteId, relatedBssid, centerAp, neighborApBssidRoamingApMap);
            if (neighborApMac == null) continue;
            roamingRelatedApMacs.add(neighborApMac);
        }
        return roamingRelatedApMacs;
    }

    private String a(String omadacId, String siteId, String relatedBssid, RoamingRelatedAp centerAp, Map<String, RoamingAp> neighborApBssidRoamingApMap) {
        for (int i = 0; i < 2; ++i) {
            String bssid;
            String mac;
            boolean changed;
            RoamingAp neighborRoamingAp = neighborApBssidRoamingApMap.get(relatedBssid);
            if (neighborRoamingAp == null) {
                a.debug("Related Bssid:{} RoamingAp not exist, omadacId:{}, siteId:{}", new Object[]{relatedBssid, omadacId, siteId});
                return null;
            }
            ArrayList<RoamingRelatedAp> newApList = new ArrayList<RoamingRelatedAp>(neighborRoamingAp.getApList());
            RoamingRelatedAp existRoamingRelatedAp = this.c.a(neighborRoamingAp, centerAp, newApList);
            if (existRoamingRelatedAp != null) {
                changed = com.tplink.smb.omada.monitor.roaming.b.a.b(centerAp, existRoamingRelatedAp);
                mac = existRoamingRelatedAp.getMac();
                bssid = existRoamingRelatedAp.getBssid();
                Integer channel = centerAp.getChannel();
                Long recvTime = centerAp.getRecvTime();
                Integer freq = centerAp.getFrequency();
                newApList.add(new RoamingRelatedAp(mac, bssid, channel, recvTime, freq));
            } else {
                changed = com.tplink.smb.omada.monitor.roaming.b.a.a(newApList, centerAp);
                a.debug("updateRelatedApNeighborListV2 changed:{}, add new ApNeighbor:{} for bssid:{}, omadacId:{}, siteId:{}", new Object[]{changed, centerAp, relatedBssid, omadacId, siteId});
            }
            mac = neighborRoamingAp.getMac();
            bssid = neighborRoamingAp.getBssid();
            int regetNeighbor = neighborRoamingAp.getRegetNeighbor();
            RoamingAp newRoamingAp = new RoamingAp(mac, bssid, regetNeighbor, newApList);
            if (!this.b.a(omadacId, siteId, bssid, neighborRoamingAp, newRoamingAp)) continue;
            if (changed) {
                a.debug("updateRelatedApNeighborListV2 issue: Related AP:{} neighbor list is changed, issue:{}, omadacId:{}, siteId:{}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
                return mac;
            }
            a.debug("updateRelatedApNeighborListV2 issue: Related AP:{} neighbor list is not changed, issue:{}, omadacId:{}, siteId:{}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
            return null;
        }
        a.warn("try clear update list failed, omadac:{}, site:{}, bssid:{}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)relatedBssid)});
        return null;
    }

    @Nonnull
    private RoamingAp a(String omadacId, String siteId, @Nonnull RoamingAp roamingAp, Map<String, RoamingAp> neighborApBssidRoamingApMap) {
        if (CollectionUtils.isEmpty(roamingAp.getApList())) {
            return roamingAp;
        }
        ArrayList<RoamingRelatedAp> newApList = new ArrayList<RoamingRelatedAp>(roamingAp.getApList());
        ListIterator<RoamingRelatedAp> each = newApList.listIterator();
        while (each.hasNext()) {
            RoamingRelatedAp roamingRelatedAp = (RoamingRelatedAp)each.next();
            String bssid = roamingRelatedAp.getBssid();
            RoamingAp neighborRoamingAp = neighborApBssidRoamingApMap.get(bssid);
            String neighborMac = neighborRoamingAp != null ? neighborRoamingAp.getMac() : this.b.e(omadacId, siteId, bssid);
            each.set(new RoamingRelatedAp(neighborMac, bssid, roamingRelatedAp.getChannel(), roamingRelatedAp.getRecvTime(), roamingRelatedAp.getFrequency()));
        }
        return new RoamingAp(roamingAp.getMac(), roamingAp.getBssid(), roamingAp.getRegetNeighbor(), newApList);
    }

    private void a(String omadacId, String siteId, Set<String> oldApBssidSet, Set<String> reportedBssidList) {
        if (CollectionUtils.isEmpty(oldApBssidSet)) {
            return;
        }
        HashSet<String> needRemovedBssidSet = new HashSet<String>();
        for (String oldBssid : oldApBssidSet) {
            if (reportedBssidList.contains(oldBssid)) continue;
            needRemovedBssidSet.add(oldBssid);
        }
        a.debug("deleteInvalidRoamingApRecordV2 need remove roaming cache bssid:{}, omadacId:{}, siteId:{}", new Object[]{needRemovedBssidSet, omadacId, siteId});
        this.b.b(omadacId, siteId, needRemovedBssidSet);
        this.a(omadacId, siteId, needRemovedBssidSet);
    }

    private void a(String omadacId, String siteId, Set<String> needRemovedBssidSet) {
        if (CollectionUtils.isEmpty(needRemovedBssidSet)) {
            return;
        }
        Set<String> relevantBssids = this.c.b(omadacId, siteId, needRemovedBssidSet);
        if (CollectionUtils.isEmpty(relevantBssids)) {
            return;
        }
        Map<String, RoamingAp> roamingApMap = this.b.a(omadacId, siteId, relevantBssids);
        relevantBssids.forEach(bssid -> this.a(omadacId, siteId, (String)bssid, needRemovedBssidSet, roamingApMap));
    }

    private void a(String omadacId, String siteId, String relevantBssid, Set<String> invalidBssids, Map<String, RoamingAp> roamingApMap) {
        if (relevantBssid == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            int regetNeighbor;
            RoamingAp newRoamingAp;
            RoamingAp roamingAp = roamingApMap.get(relevantBssid);
            if (roamingAp == null || CollectionUtils.isEmpty(roamingAp.getApList())) {
                return;
            }
            ArrayList<RoamingRelatedAp> newApList = new ArrayList<RoamingRelatedAp>(roamingAp.getApList());
            boolean isRemoved = false;
            ListIterator each = newApList.listIterator();
            while (each.hasNext()) {
                if (!invalidBssids.contains(((RoamingRelatedAp)each.next()).getBssid())) continue;
                each.remove();
                isRemoved = true;
                break;
            }
            if (!isRemoved) {
                return;
            }
            String mac = roamingAp.getMac();
            String bssid = roamingAp.getBssid();
            if (!this.b.a(omadacId, siteId, bssid, roamingAp, newRoamingAp = new RoamingAp(mac, bssid, regetNeighbor = roamingAp.getRegetNeighbor(), newApList))) continue;
            a.debug("updateRelatedApNeighborListV2 issue: Related AP:{}, neighbor list is changed, issue:{}, omadacId:{}, siteId:{}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
        }
    }

    private void a(String omadacId, String siteId, Set<String> apMacSet, boolean aiRoamingEnableBySite, String reportMac, boolean reportPat, boolean apReportFullNeighbor) {
        a.debug("start issueApNeighborRecordV2, omadacId:{}, siteId:{}, apMacSet:{}, aiRoamingEnableBySite:{}", new Object[]{omadacId, siteId, apMacSet, aiRoamingEnableBySite});
        if (T.a((String)omadacId) || T.a((String)siteId) || CollectionUtils.isEmpty(apMacSet)) {
            return;
        }
        if (!aiRoamingEnableBySite) {
            return;
        }
        Map<String, Set<String>> apNeighborMacMap = this.b(omadacId, siteId, apMacSet);
        HashSet<String> needQueryApImageSet = new HashSet<String>(apMacSet);
        apNeighborMacMap.values().forEach(needQueryApImageSet::addAll);
        g apImageListRequest = g.a().a(omadacId).a(needQueryApImageSet.stream().filter(mac -> !T.a((String)mac)).collect(Collectors.toList())).a();
        List apImages = (List)this.d.a(apImageListRequest).e();
        Map<String, ApImageDTO> apImageDTOMap = apImages.stream().collect(Collectors.toMap(DeviceImageDTO::getMac, Function.identity()));
        for (String apMac : apMacSet) {
            ApImageDTO issueApImage = (ApImageDTO)apImageDTOMap.get(apMac);
            if (issueApImage == null || issueApImage.getCapability() == null || I.a((Integer)((ApImageCapabilityDTO)issueApImage.getCapability()).getSupportAIRoaming()) < 1) {
                a.debug("Failed to issue roaming ap neighbor list, apImage is null, mac:{}, omadacId:{}, siteId:{}", new Object[]{apMac, omadacId, siteId});
                continue;
            }
            Set<String> neighborApMacs = apNeighborMacMap.get(apMac);
            a.debug("Roaming ap neighbor list issued, ap mac:{}, neighborMacs:{}, omadacId:{}, siteId:{}", new Object[]{apMac, neighborApMacs, omadacId, siteId});
            HashSet<String> needQueryApPatSet = new HashSet<String>(neighborApMacs);
            needQueryApPatSet.add(apMac);
            Map<String, RoamingApPat> roamingApPatMap = this.b.c(omadacId, siteId, needQueryApPatSet);
            this.a(omadacId, siteId, apMac, reportMac, reportPat, neighborApMacs, apImageDTOMap, roamingApPatMap);
            HashSet<ApImageDTO> neighborApImages = new HashSet<ApImageDTO>();
            neighborApMacs.forEach(neighborApMac -> neighborApImages.add((ApImageDTO)apImageDTOMap.get(neighborApMac)));
            IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
            IssuedApNeighborListList issueNeighborList = this.c.a(omadacId, siteId, apMac, neighborApImages, issueApImage);
            if (CollectionUtils.isEmpty((Collection)issueNeighborList)) {
                a.debug("no need to issue roaming ap neighbor list, issueNeighborList is empty, mac:{}, omadacId:{}, siteId:{}", new Object[]{apMac, omadacId, siteId});
                continue;
            }
            issuedRoamingInfo.setApNeighborLists(issueNeighborList);
            HashSet<String> oldNeighborMacSet = new HashSet<String>();
            IssuedRoamingPatList issueNeighborApPats = this.c.a(omadacId, siteId, neighborApMacs, apMac, roamingApPatMap);
            issueNeighborApPats.forEach(issuedRoamingPat -> oldNeighborMacSet.add(issuedRoamingPat.getMac()));
            this.b.a(omadacId, siteId, apMac, oldNeighborMacSet);
            HashSet<ApImageDTO> needSpecApImages = new HashSet<ApImageDTO>(neighborApImages);
            needSpecApImages.add(issueApImage);
            IssuedRoamingSpecList issueNeighborApSpecs = this.c.a(needSpecApImages);
            IssuedRoamingTopoList issueNeighborApTopo = this.c.a(omadacId, apImages);
            issuedRoamingInfo.setTopos(issueNeighborApTopo);
            issuedRoamingInfo.setSpecs(issueNeighborApSpecs);
            issuedRoamingInfo.setPats(issueNeighborApPats);
            com.tplink.smb.omada.manager.device.api.internal.c.c.a.c request = new com.tplink.smb.omada.manager.device.api.internal.c.c.a.c();
            request.a(omadacId);
            request.b(apMac);
            request.c(DeviceTypeEnum.a.b());
            HashMap<String, IssuedRoamingInfo> setMap = new HashMap<String, IssuedRoamingInfo>();
            if (apReportFullNeighbor) {
                issuedRoamingInfo.setFullNeighborIntv(Integer.valueOf(23));
            }
            setMap.put(ApSetKeyEnum.ROAMING_CMD.key(), issuedRoamingInfo);
            request.a(setMap);
            this.e.b(request);
        }
    }

    private Map<String, Set<String>> b(String omadacId, String siteId, Set<String> apMacSet) {
        HashMap<String, Set<String>> apNeighborMacMap = new HashMap<String, Set<String>>();
        apMacSet.forEach(apMac -> apNeighborMacMap.putIfAbsent((String)apMac, this.c.c(omadacId, siteId, (String)apMac)));
        return apNeighborMacMap;
    }

    private void a(String omadacId, String siteId, String issueMac, String reportMac, boolean reportPat, Set<String> neighborApMacs, Map<String, ApImageDTO> apImageDTOMap, Map<String, RoamingApPat> roamingApPatMap) {
        if (!T.a((String)issueMac, (String)reportMac) || !reportPat) {
            return;
        }
        if (CollectionUtils.isEmpty(neighborApMacs)) {
            return;
        }
        a.debug("start handleReportPatIssue, omadacId:{}, siteId:{}, reportMac:{}, neighborApMacs:{}", new Object[]{omadacId, siteId, reportMac, neighborApMacs});
        RoamingApPat reportRoamingApPat = roamingApPatMap.get(reportMac);
        if (reportRoamingApPat == null) {
            a.debug("HandleReportPatIssue roaming ap {} pat is null, omadacId:{}, siteId:{}", new Object[]{reportMac, omadacId, siteId});
            return;
        }
        for (String neighborApMac : neighborApMacs) {
            RoamingApPat neighborApPat;
            ApImageDTO issueApImage;
            if (T.a((String)neighborApMac, (String)reportMac) || (issueApImage = apImageDTOMap.get(neighborApMac)) == null || issueApImage.getCapability() == null || I.a((Integer)((ApImageCapabilityDTO)issueApImage.getCapability()).getSupportRoaming()) < 1 || I.a((Integer)((ApImageCapabilityDTO)issueApImage.getCapability()).getSupportAIRoaming()) < 1 || (neighborApPat = roamingApPatMap.get(neighborApMac)) == null) continue;
            Set<String> oldNeighborMacs = this.b.b(omadacId, siteId, neighborApMac);
            IssuedRoamingPatList issuedRoamingPats = new IssuedRoamingPatList();
            IssuedRoamingPat issuedRoamingPat = new IssuedRoamingPat();
            issuedRoamingPat.setMac(reportMac);
            issuedRoamingPat.setBandNum(reportRoamingApPat.getBandNum());
            issuedRoamingPat.setBwNum(reportRoamingApPat.getBwNum());
            issuedRoamingPat.setMcslevelNum(reportRoamingApPat.getMcslevelNum());
            if (reportRoamingApPat.getParamUp() != null && oldNeighborMacs.contains(neighborApMac)) {
                issuedRoamingPat.setParamUp(com.tplink.smb.omada.monitor.roaming.b.a.b(reportRoamingApPat, neighborApPat.getBandNum(), neighborApPat.getBwNum(), neighborApPat.getMcslevelNum()));
                issuedRoamingPats.add((Object)issuedRoamingPat);
            } else {
                issuedRoamingPat.setParams(com.tplink.smb.omada.monitor.roaming.b.a.a(reportRoamingApPat, neighborApPat.getBandNum(), neighborApPat.getBwNum(), neighborApPat.getMcslevelNum()));
                issuedRoamingPats.add((Object)issuedRoamingPat);
            }
            com.tplink.smb.omada.manager.device.api.internal.c.c.a.c request = new com.tplink.smb.omada.manager.device.api.internal.c.c.a.c();
            request.a(omadacId);
            request.b(neighborApMac);
            request.c(DeviceTypeEnum.a.b());
            HashMap<String, IssuedRoamingInfo> setMap = new HashMap<String, IssuedRoamingInfo>();
            IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
            issuedRoamingInfo.setPats(issuedRoamingPats);
            setMap.put(ApSetKeyEnum.ROAMING_CMD.key(), issuedRoamingInfo);
            request.a(setMap);
            this.e.b(request);
            oldNeighborMacs.add(reportMac);
            this.b.a(omadacId, siteId, neighborApMac, oldNeighborMacs);
        }
    }
}

